/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.util.StringLib;

public class JValueSlider
extends JComponent {
    private Number m_min;
    private Number m_max;
    private Number m_value;
    private boolean m_ignore = false;
    private JLabel m_label;
    private JSlider m_slider;
    private JTextField m_field;
    private List m_listeners;
    private int m_smin = 0;
    private int m_srange = 100;

    public JValueSlider(String string, double d, double d2, double d3) {
        this(string, new Double(d), new Double(d2), new Double(d3));
    }

    public JValueSlider(String string, float f, float f2, float f3) {
        this(string, new Float(f), new Float(f2), new Float(f3));
    }

    public JValueSlider(String string, int n, int n2, int n3) {
        this(string, new Integer(n), new Integer(n2), new Integer(n3));
        this.m_smin = n;
        this.m_srange = n2 - n;
        this.m_slider.setMinimum(n);
        this.m_slider.setMaximum(n2);
        this.setValue(new Integer(n3));
    }

    public JValueSlider(String string, long l, long l2, long l3) {
        this(string, new Long(l), new Long(l2), new Long(l3));
    }

    public JValueSlider(String string, Number number, Number number2, Number number3) {
        this.m_min = number;
        this.m_max = number2;
        this.m_value = number3;
        this.m_slider = new JSlider();
        this.m_label = new JLabel(string);
        this.m_field = new JTextField();
        this.m_listeners = new ArrayList();
        this.m_field.setBorder(null);
        this.setSliderValue();
        this.setFieldValue();
        this.initUI();
    }

    protected void initUI() {
        this.m_slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (JValueSlider.this.m_ignore) {
                    return;
                }
                JValueSlider.this.m_ignore = true;
                JValueSlider.this.m_value = JValueSlider.this.getSliderValue();
                JValueSlider.this.setFieldValue();
                JValueSlider.this.fireChangeEvent();
                JValueSlider.this.m_ignore = false;
            }
        });
        this.m_field.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JValueSlider.this.m_ignore) {
                    return;
                }
                JValueSlider.this.m_ignore = true;
                Number number = JValueSlider.this.getFieldValue();
                if (number != JValueSlider.this.m_value) {
                    JValueSlider.this.m_value = number;
                    JValueSlider.this.setSliderValue();
                }
                JValueSlider.this.fireChangeEvent();
                JValueSlider.this.m_ignore = false;
            }
        });
        this.m_field.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                String string = JValueSlider.this.m_field.getText();
                if (JValueSlider.isTextObscured(JValueSlider.this.m_field, string)) {
                    JValueSlider.this.m_field.setToolTipText(string);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                JValueSlider.this.m_field.setToolTipText(null);
            }
        });
        this.m_label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                String string = JValueSlider.this.m_label.getText();
                if (JValueSlider.isTextObscured(JValueSlider.this.m_label, string)) {
                    JValueSlider.this.m_label.setToolTipText(string);
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                JValueSlider.this.m_label.setToolTipText(null);
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.m_label);
        this.add(this.m_slider);
        this.add(this.m_field);
    }

    private static boolean isTextObscured(JComponent jComponent, String string) {
        Graphics graphics = jComponent.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(jComponent.getFont());
        int n = fontMetrics.stringWidth(string);
        return n > jComponent.getWidth();
    }

    public Number getValue() {
        return this.m_value;
    }

    public void setValue(Number number) {
        this.m_value = number;
        this.setSliderValue();
        this.setFieldValue();
    }

    private Number getSliderValue() {
        if (this.m_value instanceof Integer) {
            int n = this.m_slider.getValue();
            int n2 = this.m_min.intValue();
            int n3 = this.m_max.intValue();
            return new Integer(n2 + (n - this.m_smin) * (n3 - n2) / this.m_srange);
        }
        if (this.m_value instanceof Long) {
            int n = this.m_slider.getValue();
            long l = this.m_min.longValue();
            long l2 = this.m_max.longValue();
            return new Long(l + (long)(n - this.m_smin) * (l2 - l) / (long)this.m_srange);
        }
        double d = (double)(this.m_slider.getValue() - this.m_smin) / (double)this.m_srange;
        double d2 = this.m_min.doubleValue();
        double d3 = this.m_max.doubleValue();
        double d4 = d2 + d * (d3 - d2);
        return this.m_value instanceof Double ? (Number)new Double(d4) : (Number)new Float((float)d4);
    }

    private void setSliderValue() {
        int n;
        if (this.m_value instanceof Double || this.m_value instanceof Float) {
            double d = this.m_value.doubleValue();
            double d2 = this.m_min.doubleValue();
            double d3 = this.m_max.doubleValue();
            n = this.m_smin + (int)Math.round((double)this.m_srange * ((d - d2) / (d3 - d2)));
        } else {
            long l = this.m_value.longValue();
            long l2 = this.m_min.longValue();
            long l3 = this.m_max.longValue();
            n = this.m_smin + (int)((long)this.m_srange * (l - l2) / (l3 - l2));
        }
        this.m_slider.setValue(n);
    }

    private Number getFieldValue() {
        long l;
        if (this.m_value instanceof Double || this.m_value instanceof Float) {
            double d;
            try {
                d = Double.parseDouble(this.m_field.getText());
            }
            catch (Exception exception) {
                return this.m_value;
            }
            if (d < this.m_min.doubleValue() || d > this.m_max.doubleValue()) {
                return this.m_value;
            }
            return this.m_value instanceof Double ? (Number)new Double(d) : (Number)new Float((float)d);
        }
        try {
            l = Long.parseLong(this.m_field.getText());
        }
        catch (Exception exception) {
            return this.m_value;
        }
        if (l < this.m_min.longValue() || l > this.m_max.longValue()) {
            return this.m_value;
        }
        return this.m_value instanceof Long ? (Number)new Long(l) : (Number)new Integer((int)l);
    }

    private void setFieldValue() {
        String string = this.m_value instanceof Double || this.m_value instanceof Float ? StringLib.formatNumber(this.m_value.doubleValue(), 3) : String.valueOf(this.m_value.longValue());
        this.m_field.setText(string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.m_listeners.contains(changeListener)) {
            this.m_listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_listeners.remove(changeListener);
    }

    protected void fireChangeEvent() {
        Iterator iterator = this.m_listeners.iterator();
        ChangeEvent changeEvent = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ChangeListener changeListener = (ChangeListener)iterator.next();
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public void setBackground(Color color) {
        this.m_field.setBackground(color);
        this.m_label.setBackground(color);
        this.m_slider.setBackground(color);
        super.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        this.m_field.setForeground(color);
        this.m_label.setForeground(color);
        this.m_slider.setForeground(color);
        super.setForeground(color);
    }

    @Override
    public void setFont(Font font) {
        this.m_field.setFont(font);
        this.m_label.setFont(font);
        this.m_slider.setFont(font);
        super.setFont(font);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        int n = Math.min(40, dimension.width / 5);
        int n2 = Math.min(100, (dimension.width - n) / 2);
        int n3 = dimension.width - n - n2;
        super.setPreferredSize(dimension);
        Dimension dimension2 = new Dimension(n2, dimension.height);
        this.m_label.setPreferredSize(dimension2);
        dimension2 = new Dimension(n3, dimension.height);
        this.m_slider.setPreferredSize(dimension2);
        dimension2 = new Dimension(n, dimension.height);
        this.m_field.setPreferredSize(dimension2);
    }
}

