/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import prefuse.Visualization;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.search.SearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;

public class JSearchPanel
extends JPanel
implements DocumentListener,
ActionListener {
    private Object m_lock;
    private SearchTupleSet m_searcher;
    private JTextField m_queryF = new JTextField(15);
    private JLabel m_resultL = new JLabel("          ");
    private JLabel m_searchL = new JLabel("search >> ");
    private Box m_sbox = new Box(0);
    private String[] m_fields;
    private Color m_cancelColor = ColorLib.getColor(255, 75, 75);
    private boolean m_includeHitCount = false;
    private boolean m_monitorKeys = false;
    private boolean m_autoIndex = true;
    private boolean m_showBorder = true;
    private boolean m_showCancel = true;

    public JSearchPanel(SearchTupleSet searchTupleSet, String string) {
        this(searchTupleSet, string, false);
    }

    public JSearchPanel(SearchTupleSet searchTupleSet, String string, boolean bl) {
        this(null, searchTupleSet, new String[]{string}, false, bl);
    }

    public JSearchPanel(TupleSet tupleSet, SearchTupleSet searchTupleSet, String[] stringArray, boolean bl, boolean bl2) {
        this.m_lock = new Object();
        this.m_fields = stringArray;
        this.m_autoIndex = bl;
        this.m_monitorKeys = bl2;
        this.m_searcher = searchTupleSet != null ? searchTupleSet : new PrefixSearchTupleSet();
        this.init(tupleSet);
    }

    public JSearchPanel(Visualization visualization, String string) {
        this(visualization, Visualization.ALL_ITEMS, string, true);
    }

    public JSearchPanel(Visualization visualization, String string, String string2) {
        this(visualization, string, string2, true);
    }

    public JSearchPanel(Visualization visualization, String string, String string2, boolean bl) {
        this(visualization, string, Visualization.SEARCH_ITEMS, new String[]{string2}, bl, false);
    }

    public JSearchPanel(Visualization visualization, String string, String string2, boolean bl, boolean bl2) {
        this(visualization, string, Visualization.SEARCH_ITEMS, new String[]{string2}, bl, true);
    }

    public JSearchPanel(Visualization visualization, String string, String string2, String string3, boolean bl, boolean bl2) {
        this(visualization, string, string2, new String[]{string3}, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSearchPanel(Visualization visualization, String string, String string2, String[] stringArray, boolean bl, boolean bl2) {
        this.m_lock = visualization;
        this.m_fields = stringArray;
        this.m_autoIndex = bl;
        this.m_monitorKeys = bl2;
        TupleSet tupleSet = visualization.getGroup(string2);
        if (tupleSet != null) {
            if (!(tupleSet instanceof SearchTupleSet)) throw new IllegalStateException("Search focus set not instance of SearchTupleSet!");
            this.m_searcher = (SearchTupleSet)tupleSet;
        } else {
            this.m_searcher = new PrefixSearchTupleSet();
            visualization.addFocusGroup(string2, this.m_searcher);
        }
        this.init(visualization.getGroup(string));
    }

    private void init(TupleSet tupleSet) {
        if (this.m_autoIndex && tupleSet != null) {
            for (int i = 0; i < this.m_fields.length; ++i) {
                this.m_searcher.index(tupleSet.tuples(), this.m_fields[i]);
            }
            tupleSet.addTupleSetListener(new TupleSetListener(){

                @Override
                public void tupleSetChanged(TupleSet tupleSet, Tuple[] tupleArray, Tuple[] tupleArray2) {
                    int n;
                    int n2;
                    if (tupleArray != null) {
                        for (n2 = 0; n2 < tupleArray.length; ++n2) {
                            for (n = 0; n < JSearchPanel.this.m_fields.length; ++n) {
                                JSearchPanel.this.m_searcher.index(tupleArray[n2], JSearchPanel.this.m_fields[n]);
                            }
                        }
                    }
                    if (tupleArray2 != null && JSearchPanel.this.m_searcher.isUnindexSupported()) {
                        for (n2 = 0; n2 < tupleArray2.length; ++n2) {
                            for (n = 0; n < JSearchPanel.this.m_fields.length; ++n) {
                                JSearchPanel.this.m_searcher.unindex(tupleArray2[n2], JSearchPanel.this.m_fields[n]);
                            }
                        }
                    }
                }
            });
        }
        this.m_queryF.addActionListener(this);
        if (this.m_monitorKeys) {
            this.m_queryF.getDocument().addDocumentListener(this);
        }
        this.m_queryF.setMaximumSize(new Dimension(400, 100));
        this.m_queryF.setPreferredSize(new Dimension(200, 20));
        this.m_queryF.setBorder(null);
        this.setBackground(Color.WHITE);
        this.initUI();
    }

    private void initUI() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 0));
        this.m_sbox.removeAll();
        this.m_sbox.add(Box.createHorizontalStrut(3));
        this.m_sbox.add(this.m_queryF);
        this.m_sbox.add(Box.createHorizontalStrut(3));
        if (this.m_showCancel) {
            this.m_sbox.add(new CancelButton());
            this.m_sbox.add(Box.createHorizontalStrut(3));
        }
        if (this.m_showBorder) {
            this.m_sbox.setBorder(BorderFactory.createLineBorder(this.getForeground()));
        } else {
            this.m_sbox.setBorder(null);
        }
        this.m_sbox.setMaximumSize(new Dimension(400, 100));
        this.m_sbox.setPreferredSize(new Dimension(171, 20));
        Box box = new Box(0);
        if (this.m_includeHitCount) {
            box.add(this.m_resultL);
            box.add(Box.createHorizontalStrut(10));
        }
        box.add(this.m_searchL);
        box.add(Box.createHorizontalStrut(3));
        box.add(this.m_sbox);
        this.add(box);
    }

    @Override
    public void requestFocus() {
        this.m_queryF.requestFocus();
    }

    public void setLock(Object object) {
        this.m_lock = object;
    }

    public void setShowResultCount(boolean bl) {
        this.m_includeHitCount = bl;
        this.initUI();
        this.validate();
    }

    public void setShowBorder(boolean bl) {
        this.m_showBorder = bl;
        this.initUI();
        this.validate();
    }

    public void setShowCancel(boolean bl) {
        this.m_showCancel = bl;
        this.initUI();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchUpdate() {
        String string = this.m_queryF.getText();
        Object object = this.m_lock;
        synchronized (object) {
            this.m_searcher.search(string);
            if (this.m_searcher.getQuery().length() == 0) {
                this.m_resultL.setText(null);
            } else {
                int n = this.m_searcher.getTupleCount();
                this.m_resultL.setText(n + " match" + (n == 1 ? "" : "es"));
            }
        }
    }

    public void setQuery(String string) {
        Document document = this.m_queryF.getDocument();
        document.removeDocumentListener(this);
        this.m_queryF.setText(string);
        if (this.m_monitorKeys) {
            document.addDocumentListener(this);
        }
        this.searchUpdate();
    }

    public String getQuery() {
        return this.m_queryF.getText();
    }

    public void setCancelColor(Color color) {
        this.m_cancelColor = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.m_queryF != null) {
            this.m_queryF.setBackground(color);
        }
        if (this.m_resultL != null) {
            this.m_resultL.setBackground(color);
        }
        if (this.m_searchL != null) {
            this.m_searchL.setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.m_queryF != null) {
            this.m_queryF.setForeground(color);
            this.m_queryF.setCaretColor(color);
        }
        if (this.m_resultL != null) {
            this.m_resultL.setForeground(color);
        }
        if (this.m_searchL != null) {
            this.m_searchL.setForeground(color);
        }
        if (this.m_sbox != null && this.m_showBorder) {
            this.m_sbox.setBorder(BorderFactory.createLineBorder(color));
        }
    }

    @Override
    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        if (this.m_queryF != null) {
            this.m_queryF.setOpaque(bl);
        }
        if (this.m_resultL != null) {
            this.m_resultL.setOpaque(bl);
        }
        if (this.m_searchL != null) {
            this.m_searchL.setOpaque(bl);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.m_queryF != null) {
            this.m_queryF.setFont(font);
        }
        if (this.m_resultL != null) {
            this.m_resultL.setFont(font);
        }
        if (this.m_searchL != null) {
            this.m_searchL.setFont(font);
        }
    }

    public void setLabelText(String string) {
        this.m_searchL.setText(string);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.searchUpdate();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.searchUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.searchUpdate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_queryF) {
            this.searchUpdate();
        }
    }

    public class CancelButton
    extends JComponent
    implements MouseListener {
        private boolean hover = false;
        private int[] outline = new int[]{0, 0, 2, 0, 4, 2, 5, 2, 7, 0, 9, 0, 9, 2, 7, 4, 7, 5, 9, 7, 9, 9, 7, 9, 5, 7, 4, 7, 2, 9, 0, 9, 0, 7, 2, 5, 2, 4, 0, 2, 0, 0};
        private int[] fill = new int[]{1, 1, 8, 8, 1, 2, 7, 8, 2, 1, 8, 7, 7, 1, 1, 7, 8, 2, 2, 8, 1, 8, 8, 1};

        public CancelButton() {
            Dimension dimension = new Dimension(10, 10);
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension);
            this.setMaximumSize(dimension);
            this.setFocusable(false);
            this.addMouseListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            if (this.hover) {
                graphics.setColor(JSearchPanel.this.m_cancelColor);
                n = 0;
                while (n + 3 < this.fill.length) {
                    graphics.drawLine(this.fill[n], this.fill[n + 1], this.fill[n + 2], this.fill[n + 3]);
                    n += 4;
                }
            }
            graphics.setColor(JSearchPanel.this.getForeground());
            n = 0;
            while (n + 3 < this.outline.length) {
                graphics.drawLine(this.outline[n], this.outline[n + 1], this.outline[n + 2], this.outline[n + 3]);
                n += 2;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JSearchPanel.this.setQuery(null);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.hover = true;
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.hover = false;
            this.repaint();
        }
    }
}

