/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class JCustomTooltip
extends JToolTip {
    private boolean m_persist = false;
    private Listener m_lstnr = null;

    public JCustomTooltip(JComponent jComponent, JComponent jComponent2) {
        this(jComponent, jComponent2, false);
    }

    public JCustomTooltip(JComponent jComponent, JComponent jComponent2, boolean bl) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setComponent(jComponent);
        this.add(jComponent2);
        this.setPersistent(bl);
    }

    public boolean isPersistent() {
        return this.m_persist;
    }

    public void setPersistent(boolean bl) {
        if (bl == this.m_persist) {
            return;
        }
        if (bl) {
            this.m_lstnr = new Listener();
            this.addAncestorListener(this.m_lstnr);
        } else {
            this.removeAncestorListener(this.m_lstnr);
            this.m_lstnr = null;
        }
        this.m_persist = bl;
    }

    public void setContent(JComponent jComponent) {
        this.removeAll();
        this.add(jComponent);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getComponentCount() > 0) {
            Dimension dimension = this.getComponent(0).getPreferredSize();
            Insets insets = this.getInsets();
            return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        }
        return super.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.getComponentCount() > 0) {
            graphics.setColor(this.getBackground());
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            graphics.setColor(this.getComponent(0).getBackground());
            graphics.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        }
    }

    private class Listener
    extends MouseAdapter
    implements AncestorListener {
        private Point point = new Point();
        private boolean showing = false;
        private Popup popup;

        private Listener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (this.showing) {
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(JCustomTooltip.this.getParent());
            if (window == null || !window.isVisible()) {
                return;
            }
            window.getLocation(this.point);
            window.setVisible(false);
            JCustomTooltip.this.getParent().remove(JCustomTooltip.this);
            JComponent jComponent = JCustomTooltip.this.getComponent();
            jComponent.setToolTipText(null);
            jComponent.removeMouseMotionListener(ToolTipManager.sharedInstance());
            this.popup = PopupFactory.getSharedInstance().getPopup(jComponent, JCustomTooltip.this, this.point.x, this.point.y);
            Window window2 = SwingUtilities.getWindowAncestor(JCustomTooltip.this);
            window2.addMouseListener(this);
            window2.setFocusableWindowState(true);
            this.popup.show();
            this.showing = true;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.showing) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Component component = (Component)mouseEvent.getSource();
            if (n < 0 || n2 < 0 || n > component.getWidth() || n2 > component.getHeight()) {
                Window window = SwingUtilities.getWindowAncestor(JCustomTooltip.this);
                window.removeMouseListener(this);
                window.setFocusableWindowState(false);
                this.popup.hide();
                this.popup = null;
                JCustomTooltip.this.getComponent().setToolTipText("?");
                this.showing = false;
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

