/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.AbstractForce;
import prefuse.util.force.ForceItem;

public class CircularWallForce
extends AbstractForce {
    private static String[] pnames = new String[]{"GravitationalConstant"};
    public static final float DEFAULT_GRAV_CONSTANT = -0.1f;
    public static final float DEFAULT_MIN_GRAV_CONSTANT = -1.0f;
    public static final float DEFAULT_MAX_GRAV_CONSTANT = 1.0f;
    public static final int GRAVITATIONAL_CONST = 0;
    private float x;
    private float y;
    private float r;

    public CircularWallForce(float f, float f2, float f3, float f4) {
        this.params = new float[]{f};
        this.minValues = new float[]{-1.0f};
        this.maxValues = new float[]{1.0f};
        this.x = f2;
        this.y = f3;
        this.r = f4;
    }

    public CircularWallForce(float f, float f2, float f3) {
        this(-0.1f, f, f2, f3);
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    protected String[] getParameterNames() {
        return pnames;
    }

    @Override
    public void getForce(ForceItem forceItem) {
        float[] fArray = forceItem.location;
        float f = this.x - fArray[0];
        float f2 = this.y - fArray[1];
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        float f4 = this.r - f3;
        float f5 = f4 > 0.0f ? -1.0f : 1.0f;
        float f6 = f5 * this.params[0] * forceItem.mass / (f4 * f4);
        if ((double)f3 == 0.0) {
            f = ((float)Math.random() - 0.5f) / 50.0f;
            f2 = ((float)Math.random() - 0.5f) / 50.0f;
            f3 = (float)Math.sqrt(f * f + f2 * f2);
        }
        forceItem.force[0] = forceItem.force[0] + f6 * f / f3;
        forceItem.force[1] = forceItem.force[1] + f6 * f2 / f3;
    }
}

