/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.force;

import prefuse.util.force.Force;
import prefuse.util.force.ForceItem;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.Spring;

public abstract class AbstractForce
implements Force {
    protected float[] params;
    protected float[] minValues;
    protected float[] maxValues;

    @Override
    public void init(ForceSimulator forceSimulator) {
    }

    @Override
    public int getParameterCount() {
        return this.params == null ? 0 : this.params.length;
    }

    @Override
    public float getParameter(int n) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[n];
    }

    @Override
    public float getMinValue(int n) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.minValues[n];
    }

    @Override
    public float getMaxValue(int n) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.maxValues[n];
    }

    @Override
    public String getParameterName(int n) {
        String[] stringArray = this.getParameterNames();
        if (n < 0 || stringArray == null || n >= stringArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return stringArray[n];
    }

    @Override
    public void setParameter(int n, float f) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.params[n] = f;
    }

    @Override
    public void setMinValue(int n, float f) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.minValues[n] = f;
    }

    @Override
    public void setMaxValue(int n, float f) {
        if (n < 0 || this.params == null || n >= this.params.length) {
            throw new IndexOutOfBoundsException();
        }
        this.maxValues[n] = f;
    }

    protected abstract String[] getParameterNames();

    @Override
    public boolean isItemForce() {
        return false;
    }

    @Override
    public boolean isSpringForce() {
        return false;
    }

    @Override
    public void getForce(ForceItem forceItem) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }

    @Override
    public void getForce(Spring spring) {
        throw new UnsupportedOperationException("This class does not support this operation");
    }
}

