/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import prefuse.util.collections.PrimeFinder;

public abstract class AbstractHashMap {
    protected int distinct;
    protected int lowWaterMark;
    protected int highWaterMark;
    protected double minLoadFactor;
    protected double maxLoadFactor;
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;

    protected AbstractHashMap() {
    }

    protected int chooseGrowCapacity(int n, double d, double d2) {
        return this.nextPrime(Math.max(n + 1, (int)((double)(4 * n) / (3.0 * d + d2))));
    }

    protected int chooseHighWaterMark(int n, double d) {
        return Math.min(n - 2, (int)((double)n * d));
    }

    protected int chooseLowWaterMark(int n, double d) {
        return (int)((double)n * d);
    }

    protected int chooseMeanCapacity(int n, double d, double d2) {
        return this.nextPrime(Math.max(n + 1, (int)((double)(2 * n) / (d + d2))));
    }

    protected int chooseShrinkCapacity(int n, double d, double d2) {
        return this.nextPrime(Math.max(n + 1, (int)((double)(4 * n) / (d + 3.0 * d2))));
    }

    public abstract void clear();

    public void ensureCapacity(int n) {
    }

    public boolean isEmpty() {
        return this.distinct == 0;
    }

    protected int nextPrime(int n) {
        return PrimeFinder.nextPrime(n);
    }

    protected void setUp(int n, double d, double d2) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial Capacity must not be less than zero: " + n);
        }
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + d);
        }
        if (d2 <= 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("Illegal maxLoadFactor: " + d2);
        }
        if (d >= d2) {
            throw new IllegalArgumentException("Illegal minLoadFactor: " + d + " and maxLoadFactor: " + d2);
        }
    }

    public int size() {
        return this.distinct;
    }

    public void trimToSize() {
    }
}

