/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import prefuse.util.ArrayLib;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;

public class GraphicsLib {
    public static final int NO_INTERSECTION = 0;
    public static final int COINCIDENT = -1;
    public static final int PARALLEL = -2;

    public static int intersectLineLine(Line2D line2D, Line2D line2D2, Point2D point2D) {
        double d = line2D.getX1();
        double d2 = line2D.getY1();
        double d3 = line2D.getX2();
        double d4 = line2D.getY2();
        double d5 = line2D2.getX1();
        double d6 = line2D2.getY1();
        double d7 = line2D2.getX2();
        double d8 = line2D2.getY2();
        return GraphicsLib.intersectLineLine(d, d2, d3, d4, d5, d6, d7, d8, point2D);
    }

    public static int intersectLineLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, Point2D point2D) {
        double d9 = (d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5);
        double d10 = (d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5);
        double d11 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        if (d11 != 0.0) {
            double d12 = d9 / d11;
            double d13 = d10 / d11;
            if (0.0 <= d12 && d12 <= 1.0 && 0.0 <= d13 && d13 <= 1.0) {
                point2D.setLocation(d + d12 * (d3 - d), d2 + d12 * (d4 - d2));
                return 1;
            }
            return 0;
        }
        return d9 == 0.0 || d10 == 0.0 ? -1 : -2;
    }

    public static int intersectLineRectangle(Point2D point2D, Point2D point2D2, Rectangle2D rectangle2D, Point2D[] point2DArray) {
        int n;
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        double d5 = rectangle2D.getMaxX();
        double d6 = rectangle2D.getMaxY();
        double d7 = rectangle2D.getMinX();
        double d8 = rectangle2D.getMinY();
        if (point2DArray[0] == null) {
            point2DArray[0] = new Point2D.Double();
        }
        if (point2DArray[1] == null) {
            point2DArray[1] = new Point2D.Double();
        }
        if (GraphicsLib.intersectLineLine(d7, d8, d5, d8, d, d2, d3, d4, point2DArray[n = 0]) > 0) {
            ++n;
        }
        if (GraphicsLib.intersectLineLine(d5, d8, d5, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GraphicsLib.intersectLineLine(d5, d6, d7, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GraphicsLib.intersectLineLine(d7, d6, d7, d8, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        return n;
    }

    public static int intersectLineRectangle(Line2D line2D, Rectangle2D rectangle2D, Point2D[] point2DArray) {
        int n;
        double d = line2D.getX1();
        double d2 = line2D.getY1();
        double d3 = line2D.getX2();
        double d4 = line2D.getY2();
        double d5 = rectangle2D.getMaxX();
        double d6 = rectangle2D.getMaxY();
        double d7 = rectangle2D.getMinX();
        double d8 = rectangle2D.getMinY();
        if (point2DArray[0] == null) {
            point2DArray[0] = new Point2D.Double();
        }
        if (point2DArray[1] == null) {
            point2DArray[1] = new Point2D.Double();
        }
        if (GraphicsLib.intersectLineLine(d7, d8, d5, d8, d, d2, d3, d4, point2DArray[n = 0]) > 0) {
            ++n;
        }
        if (GraphicsLib.intersectLineLine(d5, d8, d5, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GraphicsLib.intersectLineLine(d5, d6, d7, d6, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        if (n == 2) {
            return n;
        }
        if (GraphicsLib.intersectLineLine(d7, d6, d7, d8, d, d2, d3, d4, point2DArray[n]) > 0) {
            ++n;
        }
        return n;
    }

    public static double[] convexHull(double[] dArray, int n) {
        if (n < 6) {
            throw new IllegalArgumentException("Input must have at least 3 points");
        }
        int n2 = n / 2 - 1;
        float[] fArray = new float[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n / 2];
        return GraphicsLib.convexHull(dArray, n, fArray, nArray, nArray2);
    }

    public static double[] convexHull(double[] dArray, int n, float[] fArray, int[] nArray, int[] nArray2) {
        int n2;
        int n3;
        int n4;
        int n5 = n / 2 - 1;
        if (n < 6) {
            throw new IllegalArgumentException("Input must have at least 3 points");
        }
        if (fArray.length < n5 || nArray.length < n5 || nArray2.length < n / 2) {
            throw new IllegalArgumentException("Pre-allocated data structure too small");
        }
        int n6 = 0;
        for (n4 = 2; n4 < n; n4 += 2) {
            if (dArray[n4 + 1] < dArray[n6 + 1]) {
                n6 = n4;
                continue;
            }
            if (dArray[n4 + 1] != dArray[n6 + 1]) continue;
            n6 = dArray[n4] < dArray[n6] ? n4 : n6;
        }
        int n7 = 0;
        for (n4 = 0; n4 < n; n4 += 2) {
            if (n4 == n6) continue;
            fArray[n7] = (float)Math.atan2(dArray[n4 + 1] - dArray[n6 + 1], dArray[n4] - dArray[n6]);
            nArray[n7++] = n4;
        }
        ArrayLib.sort(fArray, nArray, n5);
        float f = fArray[0];
        n7 = 0;
        int n8 = nArray[0];
        for (n3 = 1; n3 < n5; ++n3) {
            n2 = nArray[n3];
            if (f == fArray[n3]) {
                double d = dArray[n8] - dArray[n6];
                double d2 = dArray[n8 + 1] - dArray[n6 + 1];
                double d3 = d * d + d2 * d2;
                double d4 = dArray[n2] - dArray[n6];
                double d5 = dArray[n2 + 1] - dArray[n6 + 1];
                double d6 = d4 * d4 + d5 * d5;
                if (d3 >= d6) {
                    nArray[n3] = -1;
                    continue;
                }
                nArray[n7] = -1;
                f = fArray[n3];
                n7 = n3;
                n8 = n2;
                continue;
            }
            f = fArray[n3];
            n7 = n3;
            n8 = n2;
        }
        n3 = 0;
        nArray2[n3++] = n6;
        n2 = 0;
        int n9 = 0;
        while (n9 < 2) {
            if (nArray[n2] != -1) {
                nArray2[n3++] = nArray[n2];
                ++n9;
            }
            ++n2;
        }
        while (n2 < n5) {
            if (nArray[n2] != -1) {
                while (GraphicsLib.isNonLeft(n6, nArray2[n3 - 2], nArray2[n3 - 1], nArray[n2], dArray)) {
                    --n3;
                }
                nArray2[n3++] = nArray[n2];
            }
            ++n2;
        }
        double[] dArray2 = new double[2 * n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[2 * i] = dArray[nArray2[i]];
            dArray2[2 * i + 1] = dArray[nArray2[i] + 1];
        }
        return dArray2;
    }

    private static boolean isNonLeft(int n, int n2, int n3, int n4, double[] dArray) {
        double d;
        double d2 = Math.sqrt(Math.pow(dArray[n3 + 1] - dArray[n2 + 1], 2.0) + Math.pow(dArray[n3] - dArray[n2], 2.0));
        double d3 = Math.sqrt(Math.pow(dArray[n4 + 1] - dArray[n3 + 1], 2.0) + Math.pow(dArray[n4] - dArray[n3], 2.0));
        double d4 = Math.sqrt(Math.pow(dArray[n4 + 1] - dArray[n + 1], 2.0) + Math.pow(dArray[n4] - dArray[n], 2.0));
        double d5 = Math.sqrt(Math.pow(dArray[n2 + 1] - dArray[n + 1], 2.0) + Math.pow(dArray[n2] - dArray[n], 2.0));
        double d6 = Math.sqrt(Math.pow(dArray[n3 + 1] - dArray[n + 1], 2.0) + Math.pow(dArray[n3] - dArray[n], 2.0));
        double d7 = Math.acos((d3 * d3 + d6 * d6 - d4 * d4) / (2.0 * d3 * d6));
        double d8 = Math.PI - d7 - (d = Math.acos((d6 * d6 + d2 * d2 - d5 * d5) / (2.0 * d6 * d2)));
        return d8 <= 0.0;
    }

    public static float[] centroid(float[] fArray, int n) {
        float[] fArray2 = new float[]{0.0f, 0.0f};
        for (int i = 0; i < n; i += 2) {
            fArray2[0] = fArray2[0] + fArray[i];
            fArray2[1] = fArray2[1] + fArray[i + 1];
        }
        fArray2[0] = fArray2[0] / (float)(n / 2);
        fArray2[1] = fArray2[1] / (float)(n / 2);
        return fArray2;
    }

    public static void growPolygon(float[] fArray, int n, float f) {
        float[] fArray2 = GraphicsLib.centroid(fArray, n);
        for (int i = 0; i < n; i += 2) {
            float f2 = fArray[i] - fArray2[0];
            float f3 = fArray[i + 1] - fArray2[1];
            float f4 = (float)Math.sqrt(f2 * f2 + f3 * f3);
            int n2 = i;
            fArray[n2] = fArray[n2] + f * f2 / f4;
            int n3 = i + 1;
            fArray[n3] = fArray[n3] + f * f3 / f4;
        }
    }

    public static GeneralPath cardinalSpline(float[] fArray, float f, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0], fArray[1]);
        return GraphicsLib.cardinalSpline(generalPath, fArray, f, bl, 0.0f, 0.0f);
    }

    public static GeneralPath cardinalSpline(float[] fArray, int n, int n2, float f, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[n], fArray[n + 1]);
        return GraphicsLib.cardinalSpline(generalPath, fArray, n, n2, f, bl, 0.0f, 0.0f);
    }

    public static GeneralPath cardinalSpline(GeneralPath generalPath, float[] fArray, float f, boolean bl, float f2, float f3) {
        int n;
        for (n = 0; n < fArray.length && !Float.isNaN(fArray[n]); ++n) {
        }
        return GraphicsLib.cardinalSpline(generalPath, fArray, 0, n / 2, f, bl, f2, f3);
    }

    public static GeneralPath cardinalSpline(GeneralPath generalPath, float[] fArray, int n, int n2, float f, boolean bl, float f2, float f3) {
        float f4;
        float f5;
        int n3;
        float f6;
        float f7;
        int n4 = 2 * n2;
        int n5 = n + n4;
        if (n4 < 6) {
            throw new IllegalArgumentException("To create spline requires at least 3 points");
        }
        if (bl) {
            f7 = fArray[n + 2] - fArray[n5 - 2];
            f6 = fArray[n + 3] - fArray[n5 - 1];
        } else {
            f7 = fArray[n + 4] - fArray[n];
            f6 = fArray[n + 5] - fArray[n + 1];
        }
        for (n3 = n + 2; n3 < n5 - 2; n3 += 2) {
            f5 = f7;
            f4 = f6;
            f7 = fArray[n3 + 2] - fArray[n3 - 2];
            f6 = fArray[n3 + 3] - fArray[n3 - 1];
            generalPath.curveTo(f2 + fArray[n3 - 2] + f * f5, f3 + fArray[n3 - 1] + f * f4, f2 + fArray[n3] - f * f7, f3 + fArray[n3 + 1] - f * f6, f2 + fArray[n3], f3 + fArray[n3 + 1]);
        }
        if (bl) {
            f5 = f7;
            f4 = f6;
            f7 = fArray[n] - fArray[n3 - 2];
            f6 = fArray[n + 1] - fArray[n3 - 1];
            generalPath.curveTo(f2 + fArray[n3 - 2] + f * f5, f3 + fArray[n3 - 1] + f * f4, f2 + fArray[n3] - f * f7, f3 + fArray[n3 + 1] - f * f6, f2 + fArray[n3], f3 + fArray[n3 + 1]);
            f5 = f7;
            f4 = f6;
            f7 = fArray[n + 2] - fArray[n5 - 2];
            f6 = fArray[n + 3] - fArray[n5 - 1];
            generalPath.curveTo(f2 + fArray[n5 - 2] + f * f5, f3 + fArray[n5 - 1] + f * f4, f2 + fArray[0] - f * f7, f3 + fArray[1] - f * f6, f2 + fArray[0], f3 + fArray[1]);
            generalPath.closePath();
        } else {
            generalPath.curveTo(f2 + fArray[n3 - 2] + f * f7, f3 + fArray[n3 - 1] + f * f6, f2 + fArray[n3] - f * f7, f3 + fArray[n3 + 1] - f * f6, f2 + fArray[n3], f3 + fArray[n3 + 1]);
        }
        return generalPath;
    }

    public static GeneralPath stackSpline(GeneralPath generalPath, float[] fArray, float f, float f2, boolean bl, float f3, float f4) {
        int n;
        for (n = 0; n < fArray.length && !Float.isNaN(fArray[n]); ++n) {
        }
        return GraphicsLib.stackSpline(generalPath, fArray, 0, n / 2, f, f2, bl, f3, f4);
    }

    public static GeneralPath stackSpline(GeneralPath generalPath, float[] fArray, int n, int n2, float f, float f2, boolean bl, float f3, float f4) {
        float f5;
        float f6;
        int n3;
        float f7;
        float f8;
        int n4 = 2 * n2;
        int n5 = n + n4;
        if (n4 < 6) {
            throw new IllegalArgumentException("To create spline requires at least 3 points");
        }
        if (bl) {
            f8 = fArray[n + 2] - fArray[n5 - 2];
            f7 = fArray[n + 3] - fArray[n5 - 1];
        } else {
            f8 = fArray[n + 4] - fArray[n];
            f7 = fArray[n + 5] - fArray[n + 1];
        }
        for (n3 = n + 2; n3 < n5 - 2; n3 += 2) {
            f6 = f8;
            f5 = f7;
            f8 = fArray[n3 + 2] - fArray[n3 - 2];
            f7 = fArray[n3 + 3] - fArray[n3 - 1];
            if (Math.abs(fArray[n3] - fArray[n3 - 2]) < f || Math.abs(fArray[n3 + 1] - fArray[n3 - 1]) < f) {
                generalPath.lineTo(f3 + fArray[n3], f4 + fArray[n3 + 1]);
                continue;
            }
            generalPath.curveTo(f3 + fArray[n3 - 2] + f2 * f6, f4 + fArray[n3 - 1] + f2 * f5, f3 + fArray[n3] - f2 * f8, f4 + fArray[n3 + 1] - f2 * f7, f3 + fArray[n3], f4 + fArray[n3 + 1]);
        }
        f6 = f8;
        f5 = f7;
        f8 = fArray[n] - fArray[n3 - 2];
        f7 = fArray[n + 1] - fArray[n3 - 1];
        if (Math.abs(fArray[n3] - fArray[n3 - 2]) < f || Math.abs(fArray[n3 + 1] - fArray[n3 - 1]) < f) {
            generalPath.lineTo(f3 + fArray[n3], f4 + fArray[n3 + 1]);
        } else {
            generalPath.curveTo(f3 + fArray[n3 - 2] + f2 * f6, f4 + fArray[n3 - 1] + f2 * f5, f3 + fArray[n3] - f2 * f8, f4 + fArray[n3 + 1] - f2 * f7, f3 + fArray[n3], f4 + fArray[n3 + 1]);
        }
        if (bl) {
            if (Math.abs(fArray[n5 - 2] - fArray[0]) < f || Math.abs(fArray[n5 - 1] - fArray[1]) < f) {
                generalPath.lineTo(f3 + fArray[0], f4 + fArray[1]);
            } else {
                f6 = f8;
                f5 = f7;
                f8 = fArray[n + 2] - fArray[n5 - 2];
                f7 = fArray[n + 3] - fArray[n5 - 1];
                generalPath.curveTo(f3 + fArray[n5 - 2] + f2 * f6, f4 + fArray[n5 - 1] + f2 * f5, f3 + fArray[0] - f2 * f8, f4 + fArray[1] - f2 * f7, f3 + fArray[0], f4 + fArray[1]);
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    public static void expand(Rectangle2D rectangle2D, double d) {
        rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d, rectangle2D.getWidth() + 2.0 * d, rectangle2D.getHeight() + 2.0 * d);
    }

    public static void setBounds(VisualItem visualItem, Shape shape, BasicStroke basicStroke) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        if (shape instanceof RectangularShape) {
            RectangularShape rectangularShape = (RectangularShape)shape;
            d5 = rectangularShape.getX();
            d4 = rectangularShape.getY();
            d3 = rectangularShape.getWidth();
            d2 = rectangularShape.getHeight();
        } else if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            d5 = line2D.getX1();
            d4 = line2D.getY1();
            d3 = line2D.getX2();
            d2 = line2D.getY2();
            if (d3 < d5) {
                d = d5;
                d5 = d3;
                d3 = d - d5;
            } else {
                d3 -= d5;
            }
            if (d2 < d4) {
                d = d4;
                d4 = d2;
                d2 = d - d4;
            } else {
                d2 -= d4;
            }
        } else {
            Rectangle2D rectangle2D = shape.getBounds2D();
            d5 = rectangle2D.getX();
            d4 = rectangle2D.getY();
            d3 = rectangle2D.getWidth();
            d2 = rectangle2D.getHeight();
        }
        if (basicStroke != null) {
            double d6;
            d = basicStroke.getLineWidth();
            if (d6 > 1.0) {
                double d7 = d / 2.0;
                d5 -= d7;
                d4 -= d7;
                d3 += d;
                d2 += d;
            }
        }
        visualItem.setBounds(d5, d4, d3, d2);
    }

    public static void paint(Graphics2D graphics2D, VisualItem visualItem, Shape shape, BasicStroke basicStroke, int n) {
        AffineTransform affineTransform;
        double d;
        boolean bl;
        if (n == 0) {
            return;
        }
        Color color = ColorLib.getColor(visualItem.getStrokeColor());
        Color color2 = ColorLib.getColor(visualItem.getFillColor());
        boolean bl2 = (n == 1 || n == 3) && color.getAlpha() != 0;
        boolean bl3 = bl = (n == 2 || n == 3) && color2.getAlpha() != 0;
        if (!bl2 && !bl) {
            return;
        }
        Stroke stroke = null;
        if (bl2) {
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(basicStroke);
        }
        if ((d = Math.max((affineTransform = graphics2D.getTransform()).getScaleX(), affineTransform.getScaleY())) > 1.5) {
            if (bl) {
                graphics2D.setPaint(color2);
                graphics2D.fill(shape);
            }
            if (bl2) {
                graphics2D.setPaint(color);
                graphics2D.draw(shape);
            }
        } else if (shape instanceof RectangularShape) {
            RectangularShape rectangularShape = (RectangularShape)shape;
            double d2 = rectangularShape.getX();
            double d3 = rectangularShape.getWidth();
            double d4 = rectangularShape.getY();
            double d5 = rectangularShape.getHeight();
            int n2 = (int)d2;
            int n3 = (int)d4;
            int n4 = (int)(d3 + d2 - (double)n2);
            int n5 = (int)(d5 + d4 - (double)n3);
            if (shape instanceof Rectangle2D) {
                if (bl) {
                    graphics2D.setPaint(color2);
                    graphics2D.fillRect(n2, n3, n4, n5);
                }
                if (bl2) {
                    graphics2D.setPaint(color);
                    graphics2D.drawRect(n2, n3, n4, n5);
                }
            } else if (shape instanceof RoundRectangle2D) {
                RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
                int n6 = (int)roundRectangle2D.getArcWidth();
                int n7 = (int)roundRectangle2D.getArcHeight();
                if (bl) {
                    graphics2D.setPaint(color2);
                    graphics2D.fillRoundRect(n2, n3, n4, n5, n6, n7);
                }
                if (bl2) {
                    graphics2D.setPaint(color);
                    graphics2D.drawRoundRect(n2, n3, n4, n5, n6, n7);
                }
            } else if (shape instanceof Ellipse2D) {
                if (bl) {
                    graphics2D.setPaint(color2);
                    graphics2D.fillOval(n2, n3, n4, n5);
                }
                if (bl2) {
                    graphics2D.setPaint(color);
                    graphics2D.drawOval(n2, n3, n4, n5);
                }
            } else {
                if (bl) {
                    graphics2D.setPaint(color2);
                    graphics2D.fill(shape);
                }
                if (bl2) {
                    graphics2D.setPaint(color);
                    graphics2D.draw(shape);
                }
            }
        } else if (shape instanceof Line2D) {
            if (bl2) {
                Line2D line2D = (Line2D)shape;
                int n8 = (int)(line2D.getX1() + 0.5);
                int n9 = (int)(line2D.getY1() + 0.5);
                int n10 = (int)(line2D.getX2() + 0.5);
                int n11 = (int)(line2D.getY2() + 0.5);
                graphics2D.setPaint(color);
                graphics2D.drawLine(n8, n9, n10, n11);
            }
        } else {
            if (bl) {
                graphics2D.setPaint(color2);
                graphics2D.fill(shape);
            }
            if (bl2) {
                graphics2D.setPaint(color);
                graphics2D.draw(shape);
            }
        }
        if (bl2) {
            graphics2D.setStroke(stroke);
        }
    }
}

