/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import prefuse.data.Schema;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public class PolygonRenderer
extends AbstractShapeRenderer {
    public static final String POLYGON = "_polygon";
    public static final Schema POLYGON_SCHEMA = new Schema();
    private int m_polyType = 0;
    private float m_slack = 0.08f;
    private float m_epsilon = 0.1f;
    private boolean m_closed = true;
    private String m_polyfield = "_polygon";
    private GeneralPath m_path = new GeneralPath();

    public PolygonRenderer() {
        this(0);
    }

    public PolygonRenderer(int n) {
        this.m_polyType = n;
    }

    public int getPolyType() {
        return this.m_polyType;
    }

    public void setPolyType(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("Unknown edge type: " + n);
        }
        this.m_polyType = n;
    }

    public boolean isClosePath() {
        return this.m_closed;
    }

    public void setClosePath(boolean bl) {
        this.m_closed = bl;
    }

    public float getCurveSlack() {
        return this.m_slack;
    }

    public void setCurveSlack(float f) {
        this.m_slack = f;
    }

    @Override
    protected Shape getRawShape(VisualItem visualItem) {
        float[] fArray = (float[])visualItem.get(this.m_polyfield);
        if (fArray == null) {
            return null;
        }
        float f = (float)visualItem.getX();
        float f2 = (float)visualItem.getY();
        this.m_path.reset();
        this.m_path.moveTo(f + fArray[0], f2 + fArray[1]);
        if (this.m_polyType == 0) {
            for (int i = 2; i < fArray.length && !Float.isNaN(fArray[i]); i += 2) {
                this.m_path.lineTo(f + fArray[i], f2 + fArray[i + 1]);
            }
        } else {
            if (this.m_polyType == 1) {
                return GraphicsLib.cardinalSpline(this.m_path, fArray, this.m_slack, this.m_closed, f, f2);
            }
            if (this.m_polyType == 2) {
                return GraphicsLib.stackSpline(this.m_path, fArray, this.m_epsilon, this.m_slack, this.m_closed, f, f2);
            }
        }
        if (this.m_closed) {
            this.m_path.closePath();
        }
        return this.m_path;
    }

    static {
        POLYGON_SCHEMA.addColumn(POLYGON, float[].class);
    }
}

