/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.ImageFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.StringLib;
import prefuse.visual.VisualItem;

public class LabelRenderer
extends AbstractShapeRenderer {
    protected ImageFactory m_images = null;
    protected String m_delim = "\n";
    protected String m_labelName = "label";
    protected String m_imageName = null;
    protected int m_xAlign = 2;
    protected int m_yAlign = 2;
    protected int m_hTextAlign = 2;
    protected int m_vTextAlign = 2;
    protected int m_hImageAlign = 2;
    protected int m_vImageAlign = 2;
    protected int m_imagePos = 0;
    protected int m_horizBorder = 2;
    protected int m_vertBorder = 0;
    protected int m_imageMargin = 2;
    protected int m_arcWidth = 0;
    protected int m_arcHeight = 0;
    protected int m_maxTextWidth = -1;
    AffineTransform m_transform = new AffineTransform();
    protected RectangularShape m_bbox = new Rectangle2D.Double();
    protected Point2D m_pt = new Point2D.Double();
    protected Font m_font;
    protected String m_text;
    protected Dimension m_textDim = new Dimension();

    public LabelRenderer() {
    }

    public LabelRenderer(String string) {
        this.setTextField(string);
    }

    public LabelRenderer(String string, String string2) {
        this.setTextField(string);
        this.setImageField(string2);
    }

    public void setRoundedCorner(int n, int n2) {
        if (!(n != 0 && n2 != 0 || this.m_bbox instanceof Rectangle2D)) {
            this.m_bbox = new Rectangle2D.Double();
        } else {
            if (!(this.m_bbox instanceof RoundRectangle2D)) {
                this.m_bbox = new RoundRectangle2D.Double();
            }
            ((RoundRectangle2D)this.m_bbox).setRoundRect(0.0, 0.0, 10.0, 10.0, n, n2);
            this.m_arcWidth = n;
            this.m_arcHeight = n2;
        }
    }

    public String getTextField() {
        return this.m_labelName;
    }

    public void setTextField(String string) {
        this.m_labelName = string;
    }

    public void setMaxTextWidth(int n) {
        this.m_maxTextWidth = n;
    }

    protected String getText(VisualItem visualItem) {
        String string = null;
        if (visualItem.canGetString(this.m_labelName)) {
            return visualItem.getString(this.m_labelName);
        }
        return string;
    }

    public String getImageField() {
        return this.m_imageName;
    }

    public void setImageField(String string) {
        if (string != null) {
            this.m_images = new ImageFactory();
        }
        this.m_imageName = string;
    }

    public void setMaxImageDimensions(int n, int n2) {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        this.m_images.setMaxImageDimensions(n, n2);
    }

    protected String getImageLocation(VisualItem visualItem) {
        return visualItem.canGetString(this.m_imageName) ? visualItem.getString(this.m_imageName) : null;
    }

    protected Image getImage(VisualItem visualItem) {
        String string = this.getImageLocation(visualItem);
        return string == null ? null : this.m_images.getImage(string);
    }

    private String computeTextDimensions(VisualItem visualItem, String string, double d) {
        String string2;
        this.m_font = visualItem.getFont();
        if (d != 1.0) {
            this.m_font = FontLib.getFont(this.m_font.getName(), this.m_font.getStyle(), d * (double)this.m_font.getSize());
        }
        FontMetrics fontMetrics = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
        StringBuffer stringBuffer = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.indexOf(this.m_delim);
        this.m_textDim.width = 0;
        while (n4 >= 0) {
            string2 = string.substring(n3, n4);
            n2 = fontMetrics.stringWidth(string2);
            if (this.m_maxTextWidth > -1 && n2 > this.m_maxTextWidth) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.substring(0, n3));
                }
                stringBuffer.append(StringLib.abbreviate(string2, fontMetrics, this.m_maxTextWidth));
                stringBuffer.append(this.m_delim);
                n2 = this.m_maxTextWidth;
            } else if (stringBuffer != null) {
                stringBuffer.append(string2).append(this.m_delim);
            }
            this.m_textDim.width = Math.max(this.m_textDim.width, n2);
            n3 = n4 + 1;
            n4 = string.indexOf(this.m_delim, n3);
            ++n;
        }
        string2 = string.substring(n3);
        n2 = fontMetrics.stringWidth(string2);
        if (this.m_maxTextWidth > -1 && n2 > this.m_maxTextWidth) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.substring(0, n3));
            }
            stringBuffer.append(StringLib.abbreviate(string2, fontMetrics, this.m_maxTextWidth));
            n2 = this.m_maxTextWidth;
        } else if (stringBuffer != null) {
            stringBuffer.append(string2);
        }
        this.m_textDim.width = Math.max(this.m_textDim.width, n2);
        this.m_textDim.height = fontMetrics.getHeight() * n;
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    @Override
    protected Shape getRawShape(VisualItem visualItem) {
        this.m_text = this.getText(visualItem);
        Image image = this.getImage(visualItem);
        double d = visualItem.getSize();
        double d2 = 0.0;
        double d3 = 0.0;
        if (image != null) {
            d3 = image.getHeight(null);
            d2 = image.getWidth(null);
        }
        int n = 0;
        int n2 = 0;
        if (this.m_text != null) {
            this.m_text = this.computeTextDimensions(visualItem, this.m_text, d);
            n2 = this.m_textDim.height;
            n = this.m_textDim.width;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        switch (this.m_imagePos) {
            case 0: 
            case 1: {
                d4 = (double)n + d * (d2 + (double)(2 * this.m_horizBorder) + (double)(n > 0 && d2 > 0.0 ? this.m_imageMargin : 0));
                d5 = Math.max((double)n2, d * d3) + d * 2.0 * (double)this.m_vertBorder;
                break;
            }
            case 3: 
            case 4: {
                d4 = Math.max((double)n, d * d2) + d * 2.0 * (double)this.m_horizBorder;
                d5 = (double)n2 + d * (d3 + (double)(2 * this.m_vertBorder) + (double)(n2 > 0 && d3 > 0.0 ? this.m_imageMargin : 0));
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized image alignment setting.");
            }
        }
        LabelRenderer.getAlignedPoint(this.m_pt, visualItem, d4, d5, this.m_xAlign, this.m_yAlign);
        if (this.m_bbox instanceof RoundRectangle2D) {
            RoundRectangle2D roundRectangle2D = (RoundRectangle2D)this.m_bbox;
            roundRectangle2D.setRoundRect(this.m_pt.getX(), this.m_pt.getY(), d4, d5, d * (double)this.m_arcWidth, d * (double)this.m_arcHeight);
        } else {
            this.m_bbox.setFrame(this.m_pt.getX(), this.m_pt.getY(), d4, d5);
        }
        return this.m_bbox;
    }

    protected static void getAlignedPoint(Point2D point2D, VisualItem visualItem, double d, double d2, int n, int n2) {
        double d3 = visualItem.getX();
        double d4 = visualItem.getY();
        if (Double.isNaN(d3) || Double.isInfinite(d3)) {
            d3 = 0.0;
        }
        if (Double.isNaN(d4) || Double.isInfinite(d4)) {
            d4 = 0.0;
        }
        if (n == 2) {
            d3 -= d / 2.0;
        } else if (n == 1) {
            d3 -= d;
        }
        if (n2 == 2) {
            d4 -= d2 / 2.0;
        } else if (n2 == 3) {
            d4 -= d2;
        }
        point2D.setLocation(d3, d4);
    }

    @Override
    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        double d;
        double d2;
        RectangularShape rectangularShape = (RectangularShape)this.getShape(visualItem);
        if (rectangularShape == null) {
            return;
        }
        int n = this.getRenderType(visualItem);
        if (n == 2 || n == 3) {
            GraphicsLib.paint(graphics2D, visualItem, rectangularShape, this.getStroke(visualItem), 2);
        }
        String string = this.m_text;
        Image image = this.getImage(visualItem);
        if (string == null && image == null) {
            return;
        }
        double d3 = visualItem.getSize();
        boolean bl = 1.5 > Math.max(graphics2D.getTransform().getScaleX(), graphics2D.getTransform().getScaleY());
        double d4 = rectangularShape.getMinX() + d3 * (double)this.m_horizBorder;
        double d5 = rectangularShape.getMinY() + d3 * (double)this.m_vertBorder;
        if (image != null) {
            double d6 = d3 * (double)image.getWidth(null);
            d2 = d3 * (double)image.getHeight(null);
            d = d4;
            double d7 = d5;
            switch (this.m_imagePos) {
                case 0: {
                    d4 += d6 + d3 * (double)this.m_imageMargin;
                    break;
                }
                case 1: {
                    d = rectangularShape.getMaxX() - d3 * (double)this.m_horizBorder - d6;
                    break;
                }
                case 4: {
                    d5 += d2 + d3 * (double)this.m_imageMargin;
                    break;
                }
                case 3: {
                    d7 = rectangularShape.getMaxY() - d3 * (double)this.m_vertBorder - d2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized image alignment setting.");
                }
            }
            block6 : switch (this.m_imagePos) {
                case 0: 
                case 1: {
                    switch (this.m_vImageAlign) {
                        case 4: {
                            break;
                        }
                        case 3: {
                            d7 = rectangularShape.getMaxY() - d3 * (double)this.m_vertBorder - d2;
                            break;
                        }
                        case 2: {
                            d7 = rectangularShape.getCenterY() - d2 / 2.0;
                        }
                    }
                    break;
                }
                case 3: 
                case 4: {
                    switch (this.m_hImageAlign) {
                        case 0: {
                            break block6;
                        }
                        case 1: {
                            d = rectangularShape.getMaxX() - d3 * (double)this.m_horizBorder - d6;
                            break block6;
                        }
                        case 2: {
                            d = rectangularShape.getCenterX() - d6 / 2.0;
                        }
                    }
                }
            }
            if (bl && d3 == 1.0) {
                graphics2D.drawImage(image, (int)d, (int)d7, null);
            } else {
                this.m_transform.setTransform(d3, 0.0, 0.0, d3, d, d7);
                graphics2D.drawImage(image, this.m_transform, null);
            }
        }
        int n2 = visualItem.getTextColor();
        if (string != null && ColorLib.alpha(n2) > 0) {
            graphics2D.setPaint(ColorLib.getColor(n2));
            graphics2D.setFont(this.m_font);
            FontMetrics fontMetrics = DEFAULT_GRAPHICS.getFontMetrics(this.m_font);
            switch (this.m_imagePos) {
                case 3: 
                case 4: {
                    d2 = rectangularShape.getWidth() - 2.0 * d3 * (double)this.m_horizBorder;
                    break;
                }
                default: {
                    d2 = this.m_textDim.width;
                }
            }
            switch (this.m_imagePos) {
                case 0: 
                case 1: {
                    d = rectangularShape.getHeight() - 2.0 * d3 * (double)this.m_vertBorder;
                    break;
                }
                default: {
                    d = this.m_textDim.height;
                }
            }
            d5 += (double)fontMetrics.getAscent();
            switch (this.m_vTextAlign) {
                case 4: {
                    break;
                }
                case 3: {
                    d5 += d - (double)this.m_textDim.height;
                    break;
                }
                case 2: {
                    d5 += (d - (double)this.m_textDim.height) / 2.0;
                }
            }
            int n3 = fontMetrics.getHeight();
            int n4 = 0;
            int n5 = string.indexOf(this.m_delim);
            while (n5 >= 0) {
                this.drawString(graphics2D, fontMetrics, string.substring(n4, n5), bl, d4, d5, d2);
                n4 = n5 + 1;
                n5 = string.indexOf(this.m_delim, n4);
                d5 += (double)n3;
            }
            this.drawString(graphics2D, fontMetrics, string.substring(n4), bl, d4, d5, d2);
        }
        if (n == 1 || n == 3) {
            GraphicsLib.paint(graphics2D, visualItem, rectangularShape, this.getStroke(visualItem), 1);
        }
    }

    private final void drawString(Graphics2D graphics2D, FontMetrics fontMetrics, String string, boolean bl, double d, double d2, double d3) {
        double d4;
        switch (this.m_hTextAlign) {
            case 0: {
                d4 = d;
                break;
            }
            case 1: {
                d4 = d + d3 - (double)fontMetrics.stringWidth(string);
                break;
            }
            case 2: {
                d4 = d + (d3 - (double)fontMetrics.stringWidth(string)) / 2.0;
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized text alignment setting.");
            }
        }
        if (bl) {
            graphics2D.drawString(string, (int)d4, (int)d2);
        } else {
            graphics2D.drawString(string, (float)d4, (float)d2);
        }
    }

    public ImageFactory getImageFactory() {
        if (this.m_images == null) {
            this.m_images = new ImageFactory();
        }
        return this.m_images;
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.m_images = imageFactory;
    }

    public int getHorizontalTextAlignment() {
        return this.m_hTextAlign;
    }

    public void setHorizontalTextAlignment(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal horizontal text alignment value.");
        }
        this.m_hTextAlign = n;
    }

    public int getVerticalTextAlignment() {
        return this.m_vTextAlign;
    }

    public void setVerticalTextAlignment(int n) {
        if (n != 4 && n != 3 && n != 2) {
            throw new IllegalArgumentException("Illegal vertical text alignment value.");
        }
        this.m_vTextAlign = n;
    }

    public int getHorizontalImageAlignment() {
        return this.m_hImageAlign;
    }

    public void setHorizontalImageAlignment(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal horizontal text alignment value.");
        }
        this.m_hImageAlign = n;
    }

    public int getVerticalImageAlignment() {
        return this.m_vImageAlign;
    }

    public void setVerticalImageAlignment(int n) {
        if (n != 4 && n != 3 && n != 2) {
            throw new IllegalArgumentException("Illegal vertical text alignment value.");
        }
        this.m_vImageAlign = n;
    }

    public int getImagePosition() {
        return this.m_imagePos;
    }

    public void setImagePosition(int n) {
        if (n != 4 && n != 3 && n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal image position value.");
        }
        this.m_imagePos = n;
    }

    public int getHorizontalAlignment() {
        return this.m_xAlign;
    }

    public int getVerticalAlignment() {
        return this.m_yAlign;
    }

    public void setHorizontalAlignment(int n) {
        this.m_xAlign = n;
    }

    public void setVerticalAlignment(int n) {
        this.m_yAlign = n;
    }

    public int getHorizontalPadding() {
        return this.m_horizBorder;
    }

    public void setHorizontalPadding(int n) {
        this.m_horizBorder = n;
    }

    public int getVerticalPadding() {
        return this.m_vertBorder;
    }

    public void setVerticalPadding(int n) {
        this.m_vertBorder = n;
    }

    public int getImageTextPadding() {
        return this.m_imageMargin;
    }

    public void setImageTextPadding(int n) {
        this.m_imageMargin = n;
    }
}

