/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import prefuse.render.Renderer;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public abstract class AbstractShapeRenderer
implements Renderer {
    public static final int RENDER_TYPE_NONE = 0;
    public static final int RENDER_TYPE_DRAW = 1;
    public static final int RENDER_TYPE_FILL = 2;
    public static final int RENDER_TYPE_DRAW_AND_FILL = 3;
    private int m_renderType = 3;
    protected AffineTransform m_transform = new AffineTransform();
    protected boolean m_manageBounds = true;

    public void setManageBounds(boolean bl) {
        this.m_manageBounds = bl;
    }

    @Override
    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape != null) {
            this.drawShape(graphics2D, visualItem, shape);
        }
    }

    protected void drawShape(Graphics2D graphics2D, VisualItem visualItem, Shape shape) {
        GraphicsLib.paint(graphics2D, visualItem, shape, this.getStroke(visualItem), this.getRenderType(visualItem));
    }

    public Shape getShape(VisualItem visualItem) {
        AffineTransform affineTransform = this.getTransform(visualItem);
        Shape shape = this.getRawShape(visualItem);
        return affineTransform == null || shape == null ? shape : affineTransform.createTransformedShape(shape);
    }

    protected BasicStroke getStroke(VisualItem visualItem) {
        return visualItem.getStroke();
    }

    protected abstract Shape getRawShape(VisualItem var1);

    protected AffineTransform getTransform(VisualItem visualItem) {
        return null;
    }

    public int getRenderType(VisualItem visualItem) {
        return this.m_renderType;
    }

    public void setRenderType(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Unrecognized render type.");
        }
        this.m_renderType = n;
    }

    @Override
    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        if (visualItem.getBounds().contains(point2D)) {
            Shape shape = this.getShape(visualItem);
            return shape != null ? shape.contains(point2D) : false;
        }
        return false;
    }

    @Override
    public void setBounds(VisualItem visualItem) {
        if (!this.m_manageBounds) {
            return;
        }
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            visualItem.setBounds(visualItem.getX(), visualItem.getY(), 0.0, 0.0);
        } else {
            GraphicsLib.setBounds(visualItem, shape, this.getStroke(visualItem));
        }
    }
}

