/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import prefuse.data.CascadedTable;
import prefuse.data.Table;
import prefuse.data.column.IntColumn;
import prefuse.data.util.RowManager;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIntTreeMap;

public class FilteredRowManager
extends RowManager {
    protected IntColumn m_childToParent;
    protected IntIntSortedMap m_parentToChild;

    public FilteredRowManager(Table table) {
        super(table);
        this.m_childToParent = new IntColumn(table.getRowCount());
        this.m_parentToChild = new IntIntTreeMap(false);
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.m_parentToChild.clear();
        for (int i = 0; i < this.m_childToParent.getRowCount(); ++i) {
            this.m_childToParent.setInt(-1, i);
        }
    }

    public int addRow(int n) {
        int n2 = super.addRow();
        this.put(n2, n);
        return n2;
    }

    @Override
    public boolean releaseRow(int n) {
        if (super.releaseRow(n)) {
            this.remove(n);
            return true;
        }
        return false;
    }

    @Override
    public int getColumnRow(int n, int n2) {
        return ((CascadedTable)this.m_table).getParentTable().getColumnRow(this.getParentRow(n), n2);
    }

    @Override
    public int getTableRow(int n, int n2) {
        return this.getChildRow(n);
    }

    public int getParentRow(int n) {
        if (n >= this.m_childToParent.getRowCount()) {
            return -1;
        }
        return this.m_childToParent.getInt(n);
    }

    public int getChildRow(int n) {
        int n2 = this.m_parentToChild.get(n);
        return n2 == Integer.MIN_VALUE ? -1 : n2;
    }

    public void put(int n, int n2) {
        if (n >= this.m_childToParent.getRowCount()) {
            this.m_childToParent.setMaximumRow(n + 1);
        }
        this.m_childToParent.setInt(n2, n);
        this.m_parentToChild.put(n2, n);
    }

    public void remove(int n) {
        int n2 = this.m_childToParent.getInt(n);
        this.m_childToParent.setInt(-1, n);
        this.m_parentToChild.remove(n2);
    }
}

