/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;

public class FilterIterator
implements Iterator {
    private Predicate predicate;
    private Iterator tuples;
    private Tuple next;

    public FilterIterator(Iterator iterator, Predicate predicate) {
        this.predicate = predicate;
        this.tuples = iterator;
        this.next = this.advance();
    }

    private Tuple advance() {
        while (this.tuples.hasNext()) {
            Tuple tuple = (Tuple)this.tuples.next();
            if (!this.predicate.getBoolean(tuple)) continue;
            return tuple;
        }
        this.tuples = null;
        this.next = null;
        return null;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        Tuple tuple = this.next;
        this.next = this.advance();
        return tuple;
    }

    @Override
    public boolean hasNext() {
        return this.tuples != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

