/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.Iterator;
import java.util.LinkedHashSet;
import prefuse.data.Tuple;
import prefuse.data.event.EventConstants;
import prefuse.data.tuple.AbstractTupleSet;

public class DefaultTupleSet
extends AbstractTupleSet
implements EventConstants {
    protected LinkedHashSet m_tuples = new LinkedHashSet();

    @Override
    public int getTupleCount() {
        return this.m_tuples.size();
    }

    @Override
    public Tuple addTuple(Tuple tuple) {
        if ((tuple = this.addInternal(tuple)) != null) {
            this.fireTupleEvent(tuple, 1);
        }
        return tuple;
    }

    @Override
    public Tuple setTuple(Tuple tuple) {
        Tuple[] tupleArray;
        Tuple[] tupleArray2 = this.clearInternal();
        if ((tuple = this.addInternal(tuple)) == null) {
            tupleArray = null;
        } else {
            Tuple[] tupleArray3 = new Tuple[1];
            tupleArray = tupleArray3;
            tupleArray3[0] = tuple;
        }
        Tuple[] tupleArray4 = tupleArray;
        this.fireTupleEvent(tupleArray4, tupleArray2);
        return tuple;
    }

    protected final Tuple addInternal(Tuple tuple) {
        if (this.m_tuples.add(tuple)) {
            return tuple;
        }
        return null;
    }

    @Override
    public boolean containsTuple(Tuple tuple) {
        return this.m_tuples.contains(tuple);
    }

    @Override
    public boolean removeTuple(Tuple tuple) {
        boolean bl = this.removeInternal(tuple);
        if (bl) {
            this.fireTupleEvent(tuple, -1);
        }
        return bl;
    }

    protected final boolean removeInternal(Tuple tuple) {
        return this.m_tuples.remove(tuple);
    }

    @Override
    public void clear() {
        if (this.getTupleCount() > 0) {
            Tuple[] tupleArray = this.clearInternal();
            this.fireTupleEvent(null, tupleArray);
        }
    }

    public Tuple[] clearInternal() {
        Tuple[] tupleArray = new Tuple[this.getTupleCount()];
        Iterator iterator = this.tuples();
        int n = 0;
        while (iterator.hasNext()) {
            tupleArray[n] = (Tuple)iterator.next();
            ++n;
        }
        this.m_tuples.clear();
        return tupleArray;
    }

    @Override
    public Iterator tuples() {
        return this.m_tuples.iterator();
    }

    public Tuple[] toArray() {
        Tuple[] tupleArray = new Tuple[this.getTupleCount()];
        this.m_tuples.toArray(tupleArray);
        return tupleArray;
    }
}

