/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultBoundedRangeModel;
import prefuse.util.ui.ValuedRangeModel;

public class ObjectRangeModel
extends DefaultBoundedRangeModel
implements ValuedRangeModel {
    private Object[] m_objects;
    private Map m_ordinal;

    public ObjectRangeModel(Object[] objectArray) {
        this.setValueRange(objectArray);
    }

    public void setValueRange(Object[] objectArray) {
        int n;
        if (this.m_objects != null && objectArray.length == this.m_objects.length) {
            n = 1;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == this.m_objects[i]) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                return;
            }
        }
        this.m_objects = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.m_objects, 0, objectArray.length);
        if (this.m_ordinal == null) {
            this.m_ordinal = new HashMap();
        } else {
            this.m_ordinal.clear();
        }
        for (n = 0; n < objectArray.length; ++n) {
            this.m_ordinal.put(objectArray[n], new Integer(n));
        }
        this.setRangeProperties(0, objectArray.length - 1, 0, objectArray.length - 1, false);
    }

    public Object getObject(int n) {
        return this.m_objects[n];
    }

    public int getIndex(Object object) {
        Integer n = (Integer)this.m_ordinal.get(object);
        return n == null ? -1 : n;
    }

    @Override
    public Object getMinValue() {
        return this.m_objects[this.getMinimum()];
    }

    @Override
    public Object getMaxValue() {
        return this.m_objects[this.getMaximum()];
    }

    @Override
    public Object getLowValue() {
        return this.m_objects[this.getValue()];
    }

    @Override
    public Object getHighValue() {
        return this.m_objects[this.getValue() + this.getExtent()];
    }
}

