/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class DoubleParser
implements DataParser {
    private boolean m_blockExplicitFloats = true;

    @Override
    public Class getType() {
        return Double.TYPE;
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)object).doubleValue());
    }

    @Override
    public boolean canParse(String string) {
        try {
            if (this.m_blockExplicitFloats && string.endsWith("f")) {
                return false;
            }
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Object parse(String string) throws DataParseException {
        return new Double(DoubleParser.parseDouble(string));
    }

    public static double parseDouble(String string) throws DataParseException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

