/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.parser;

import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;

public class ByteParser
implements DataParser {
    @Override
    public Class getType() {
        return Byte.TYPE;
    }

    @Override
    public String format(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("This class can only format Objects of type Number.");
        }
        return String.valueOf(((Number)object).byteValue());
    }

    @Override
    public boolean canParse(String string) {
        try {
            Byte.parseByte(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public Object parse(String string) throws DataParseException {
        return new Byte(ByteParser.parseByte(string));
    }

    public static byte parseByte(String string) throws DataParseException {
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataParseException(numberFormatException);
        }
    }
}

