/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import prefuse.data.Table;
import prefuse.data.io.AbstractTableWriter;
import prefuse.data.io.DataIOException;
import prefuse.util.collections.IntIterator;

public class CSVTableWriter
extends AbstractTableWriter {
    private boolean m_printHeader;

    public CSVTableWriter() {
        this(true);
    }

    public CSVTableWriter(boolean bl) {
        this.m_printHeader = bl;
    }

    public boolean isPrintHeader() {
        return this.m_printHeader;
    }

    public void setPrintHeader(boolean bl) {
        this.m_printHeader = bl;
    }

    @Override
    public void writeTable(Table table, OutputStream outputStream) throws DataIOException {
        try {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(outputStream));
            if (this.m_printHeader) {
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        printStream.print(',');
                    }
                    printStream.print(this.makeCSVSafe(table.getColumnName(i)));
                }
                printStream.println();
            }
            IntIterator intIterator = table.rows();
            while (intIterator.hasNext()) {
                int n = intIterator.nextInt();
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (i > 0) {
                        printStream.print(',');
                    }
                    String string = table.getString(n, table.getColumnName(i));
                    printStream.print(this.makeCSVSafe(string));
                }
                printStream.println();
            }
            printStream.flush();
        }
        catch (Exception exception) {
            throw new DataIOException(exception);
        }
    }

    private String makeCSVSafe(String string) {
        int n = -1;
        n = string.indexOf(34);
        if (n >= 0 || string.indexOf(44) >= 0 || string.indexOf(10) >= 0 || Character.isWhitespace(string.charAt(0)) || Character.isWhitespace(string.charAt(string.length() - 1))) {
            if (n >= 0) {
                string = string.replaceAll("\"", "\"\"");
            }
            string = "\"" + string + "\"";
        }
        return string;
    }
}

