/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import prefuse.data.Graph;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphReader;
import prefuse.util.io.IOLib;

public abstract class AbstractGraphReader
implements GraphReader {
    @Override
    public Graph readGraph(String string) throws DataIOException {
        try {
            InputStream inputStream = IOLib.streamFromString(string);
            if (inputStream == null) {
                throw new DataIOException("Couldn't find " + string + ". Not a valid file, URL, or resource locator.");
            }
            return this.readGraph(inputStream);
        }
        catch (IOException iOException) {
            throw new DataIOException(iOException);
        }
    }

    @Override
    public Graph readGraph(URL uRL) throws DataIOException {
        try {
            return this.readGraph(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new DataIOException(iOException);
        }
    }

    @Override
    public Graph readGraph(File file) throws DataIOException {
        try {
            return this.readGraph(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DataIOException(fileNotFoundException);
        }
    }

    @Override
    public abstract Graph readGraph(InputStream var1) throws DataIOException;
}

