/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Tuple;
import prefuse.data.expression.DoubleFunction;

class LogFunction
extends DoubleFunction {
    public LogFunction() {
        super(2);
    }

    @Override
    public String getName() {
        return "LOG";
    }

    @Override
    public double getDouble(Tuple tuple) {
        int n = this.paramCount();
        if (n == 2) {
            double d = this.param(0).getDouble(tuple);
            double d2 = this.param(1).getDouble(tuple);
            return Math.log(d2) / Math.log(d);
        }
        if (n == 1) {
            return Math.log(this.param(0).getDouble(tuple));
        }
        this.missingParams();
        return Double.NaN;
    }
}

