/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.AbstractExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;
import prefuse.data.expression.Predicate;
import prefuse.util.TypeLib;

public class IfExpression
extends AbstractExpression {
    private Predicate m_test;
    private Expression m_then;
    private Expression m_else;

    public IfExpression(Predicate predicate, Expression expression, Expression expression2) {
        this.m_test = predicate;
        this.m_then = expression;
        this.m_else = expression2;
    }

    public Predicate getTestPredicate() {
        return this.m_test;
    }

    public Expression getThenExpression() {
        return this.m_then;
    }

    public Expression getElseExpression() {
        return this.m_else;
    }

    public void setTestPredicate(Predicate predicate) {
        this.m_test.removeExpressionListener(this);
        this.m_test = predicate;
        if (this.hasListeners()) {
            predicate.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public void setThenExpression(Expression expression) {
        this.m_then.removeExpressionListener(this);
        this.m_then = expression;
        if (this.hasListeners()) {
            expression.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    public void setElseExpression(Expression expression) {
        this.m_else.removeExpressionListener(this);
        this.m_else = expression;
        if (this.hasListeners()) {
            expression.addExpressionListener(this);
        }
        this.fireExpressionChange();
    }

    @Override
    public Class getType(Schema schema) {
        Class clazz = this.m_then.getType(schema);
        Class clazz2 = this.m_else.getType(schema);
        return TypeLib.getSharedType(clazz, clazz2);
    }

    @Override
    public Object get(Tuple tuple) {
        return (this.m_test.getBoolean(tuple) ? this.m_then : this.m_else).get(tuple);
    }

    @Override
    public boolean getBoolean(Tuple tuple) {
        return (this.m_test.getBoolean(tuple) ? this.m_then : this.m_else).getBoolean(tuple);
    }

    @Override
    public double getDouble(Tuple tuple) {
        return (this.m_test.getBoolean(tuple) ? this.m_then : this.m_else).getDouble(tuple);
    }

    @Override
    public float getFloat(Tuple tuple) {
        return (this.m_test.getBoolean(tuple) ? this.m_then : this.m_else).getFloat(tuple);
    }

    @Override
    public int getInt(Tuple tuple) {
        return (this.m_test.getBoolean(tuple) ? this.m_then : this.m_else).getInt(tuple);
    }

    @Override
    public long getLong(Tuple tuple) {
        return (this.m_test.getBoolean(tuple) ? this.m_then : this.m_else).getLong(tuple);
    }

    @Override
    public void visit(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visitExpression(this);
        expressionVisitor.down();
        this.m_test.visit(expressionVisitor);
        expressionVisitor.up();
        expressionVisitor.down();
        this.m_then.visit(expressionVisitor);
        expressionVisitor.up();
        expressionVisitor.down();
        this.m_else.visit(expressionVisitor);
        expressionVisitor.up();
    }

    @Override
    protected void addChildListeners() {
        this.m_test.addExpressionListener(this);
        this.m_then.addExpressionListener(this);
        this.m_else.addExpressionListener(this);
    }

    @Override
    protected void removeChildListeners() {
        this.m_test.removeExpressionListener(this);
        this.m_then.removeExpressionListener(this);
        this.m_else.removeExpressionListener(this);
    }

    public String toString() {
        return "IF " + this.m_test.toString() + " THEN " + this.m_then.toString() + " ELSE " + this.m_else.toString();
    }
}

