/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class DoubleColumn
extends AbstractColumn {
    private double[] m_values;
    private int m_size;

    public DoubleColumn() {
        this(0, 10, 0.0);
    }

    public DoubleColumn(int n) {
        this(n, n, 0.0);
    }

    public DoubleColumn(int n, int n2, double d) {
        super(Double.TYPE, new Double(d));
        if (n2 < n) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new double[n2];
        Arrays.fill(this.m_values, d);
        this.m_size = n;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int n) {
        if (n > this.m_values.length) {
            int n2 = Math.max(3 * this.m_values.length / 2 + 1, n);
            double[] dArray = new double[n2];
            System.arraycopy(this.m_values, 0, dArray, 0, this.m_size);
            Arrays.fill(dArray, this.m_size, n2, (Double)this.m_defaultValue);
            this.m_values = dArray;
        }
        this.m_size = n;
    }

    @Override
    public Object get(int n) {
        return new Double(this.getDouble(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setDouble(((Number)object).doubleValue(), n);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n);
        }
    }

    @Override
    public double getDouble(int n) throws DataTypeException {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_values[n];
    }

    @Override
    public void setDouble(double d, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n < 0 || n >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        double d2 = this.m_values[n];
        if (d2 == d) {
            return;
        }
        this.m_values[n] = d;
        this.fireColumnEvent(n, d2);
    }

    @Override
    public int getInt(int n) throws DataTypeException {
        return (int)this.getDouble(n);
    }

    @Override
    public void setInt(int n, int n2) throws DataTypeException {
        this.setDouble(n, n2);
    }

    @Override
    public long getLong(int n) throws DataTypeException {
        return (long)this.getDouble(n);
    }

    @Override
    public void setLong(long l, int n) throws DataTypeException {
        this.setDouble(l, n);
    }

    @Override
    public float getFloat(int n) throws DataTypeException {
        return (float)this.getDouble(n);
    }

    @Override
    public void setFloat(float f, int n) throws DataTypeException {
        this.setDouble(f, n);
    }
}

