/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import java.util.Date;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;
import prefuse.util.TimeLib;

public class DateColumn
extends AbstractColumn {
    private long[] m_values;
    private int m_size;

    public DateColumn() {
        this(Date.class, 0, 10, 0L);
    }

    public DateColumn(int n) {
        this(Date.class, n, n, 0L);
    }

    public DateColumn(Class clazz, int n) {
        this(clazz, n, n, 0L);
    }

    public DateColumn(Class clazz, int n, int n2, long l) {
        super(clazz, TimeLib.getDate(clazz, l));
        if (!Date.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Column type must be an instance or subclass of java.util.Date.");
        }
        if (n2 < n) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new long[n2];
        Arrays.fill(this.m_values, l);
        this.m_size = n;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int n) {
        if (n > this.m_values.length) {
            int n2 = Math.max(3 * this.m_values.length / 2 + 1, n);
            long[] lArray = new long[n2];
            System.arraycopy(this.m_values, 0, lArray, 0, this.m_size);
            Arrays.fill(lArray, this.m_size, n2, ((Date)this.m_defaultValue).getTime());
            this.m_values = lArray;
        }
        this.m_size = n;
    }

    @Override
    public boolean canSet(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
            return true;
        }
        return this.m_columnType.isAssignableFrom(clazz);
    }

    @Override
    public Object get(int n) {
        return TimeLib.getDate(this.m_columnType, this.getLong(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Date) {
            this.setLong(((Date)object).getTime(), n);
            return;
        } else if (object instanceof Number) {
            this.setLong(((Number)object).longValue(), n);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n);
        }
    }

    @Override
    public long getLong(int n) throws DataTypeException {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_values[n];
    }

    @Override
    public void setLong(long l, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n < 0 || n >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        long l2 = this.m_values[n];
        if (l2 == l) {
            return;
        }
        this.m_values[n] = l;
        this.fireColumnEvent(n, l2);
    }

    @Override
    public double getDouble(int n) throws DataTypeException {
        return this.getLong(n);
    }
}

