/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.BitSet;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class BooleanColumn
extends AbstractColumn {
    private BitSet m_bits;
    private int m_size;

    public BooleanColumn() {
        this(0, 10, false);
    }

    public BooleanColumn(int n) {
        this(n, n, false);
    }

    public BooleanColumn(int n, int n2, boolean bl) {
        super(Boolean.TYPE, new Boolean(bl));
        if (n2 < n) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_bits = new BitSet(n2);
        this.m_bits.set(0, n2, bl);
        this.m_size = n;
    }

    @Override
    public int getRowCount() {
        return this.m_size;
    }

    @Override
    public void setMaximumRow(int n) {
        if (n > this.m_size) {
            this.m_bits.set(this.m_size, n, (Boolean)this.m_defaultValue);
        }
        this.m_size = n;
    }

    @Override
    public Object get(int n) {
        return new Boolean(this.getBoolean(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Boolean) {
            this.setBoolean((Boolean)object, n);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n);
        }
    }

    @Override
    public boolean getBoolean(int n) throws DataTypeException {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_bits.get(n);
    }

    @Override
    public void setBoolean(boolean bl, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n < 0 || n >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        boolean bl2 = this.m_bits.get(n);
        if (bl2 == bl) {
            return;
        }
        this.m_bits.set(n, bl);
        this.fireColumnEvent(n, bl2);
    }
}

