/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.ArrayList;
import java.util.Iterator;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.column.ColumnMetadata;
import prefuse.data.event.ExpressionListener;
import prefuse.data.event.ProjectionListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TableTuple;
import prefuse.data.util.AcceptAllColumnProjection;
import prefuse.data.util.CascadedRowManager;
import prefuse.data.util.ColumnProjection;
import prefuse.util.collections.CompositeIterator;
import prefuse.util.collections.IntIterator;

public class CascadedTable
extends Table {
    protected Table m_parent;
    protected ArrayList m_pnames;
    protected ColumnProjection m_colFilter;
    protected Predicate m_rowFilter;
    protected Listener m_listener;

    public CascadedTable(Table table) {
        this(table, null, null);
    }

    public CascadedTable(Table table, Predicate predicate) {
        this(table, predicate, null);
    }

    public CascadedTable(Table table, ColumnProjection columnProjection) {
        this(table, null, columnProjection);
    }

    public CascadedTable(Table table, Predicate predicate, ColumnProjection columnProjection) {
        this(table, predicate, columnProjection, TableTuple.class);
    }

    protected CascadedTable(Table table, Predicate predicate, ColumnProjection columnProjection, Class clazz) {
        super(0, 0, clazz);
        this.m_parent = table;
        this.m_pnames = new ArrayList();
        this.m_rows = new CascadedRowManager(this);
        this.m_listener = new Listener();
        this.setColumnProjection(columnProjection);
        this.setRowFilter(predicate);
        this.m_parent.addTableListener(this.m_listener);
    }

    protected CascadedTable() {
        this(TableTuple.class);
    }

    protected CascadedTable(Class clazz) {
        super(0, 0, clazz);
        this.m_pnames = new ArrayList();
    }

    protected void filterColumns() {
        if (this.m_parent == null) {
            return;
        }
        for (int i = 0; i < this.m_pnames.size(); ++i) {
            String string = (String)this.m_pnames.get(i);
            Column column = this.m_parent.getColumn(i);
            boolean bl = this.m_names.contains(string);
            if (this.m_colFilter.include(column, string) && !bl) continue;
            this.m_pnames.remove(i--);
            if (!bl) {
                ((Table.ColumnEntry)this.m_entries.get(string)).dispose();
                this.m_entries.remove(string);
            }
            this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), i, -1);
        }
        this.m_pnames.clear();
        Iterator iterator = this.m_parent.getColumnNames();
        int n = 0;
        int n2 = this.m_columns.size();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Column column = this.m_parent.getColumn(n);
            if (this.m_colFilter.include(column, string) && !this.m_names.contains(string)) {
                this.m_pnames.add(string);
                Table.ColumnEntry columnEntry = (Table.ColumnEntry)this.m_entries.get(string);
                if (columnEntry == null) {
                    columnEntry = new Table.ColumnEntry(n2++, column, new ColumnMetadata(this, string));
                    this.m_entries.put(string, columnEntry);
                    this.fireTableEvent(this.m_rows.getMinimumRow(), this.m_rows.getMaximumRow(), n, 1);
                } else {
                    columnEntry.colnum = n2++;
                }
                this.m_lastCol = this.m_columns.size() - 1;
            }
            ++n;
        }
    }

    public void filterRows() {
        if (this.m_parent == null) {
            return;
        }
        CascadedRowManager cascadedRowManager = (CascadedRowManager)this.m_rows;
        IntIterator intIterator = this.m_rows.rows();
        while (intIterator.hasNext()) {
            int n = intIterator.nextInt();
            if (this.m_rowFilter.getBoolean(this.m_parent.getTuple(cascadedRowManager.getParentRow(n)))) continue;
            this.removeCascadedRow(n);
        }
        Iterator iterator = this.m_parent.tuples(this.m_rowFilter);
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            int n = tuple.getRow();
            if (cascadedRowManager.getChildRow(n) != -1) continue;
            this.addCascadedRow(n);
        }
    }

    public ColumnProjection getColumnProjection() {
        return this.m_colFilter;
    }

    public void setColumnProjection(ColumnProjection columnProjection) {
        if (this.m_colFilter != null) {
            this.m_colFilter.removeProjectionListener(this.m_listener);
        }
        this.m_colFilter = columnProjection == null ? new AcceptAllColumnProjection() : columnProjection;
        this.m_colFilter.addProjectionListener(this.m_listener);
        this.filterColumns();
    }

    public Predicate getRowFilter() {
        return this.m_rowFilter;
    }

    public void setRowFilter(Predicate predicate) {
        if (this.m_rowFilter != null) {
            this.m_rowFilter.removeExpressionListener(this.m_listener);
        }
        Predicate predicate2 = this.m_rowFilter = predicate == null ? BooleanLiteral.TRUE : predicate;
        if (this.m_rowFilter != BooleanLiteral.TRUE) {
            this.m_rowFilter.addExpressionListener(this.m_listener);
        }
        this.filterRows();
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size() + this.m_pnames.size();
    }

    public int getLocalColumnCount() {
        return this.m_columns.size();
    }

    public Table getParentTable() {
        return this.m_parent;
    }

    public int getParentRow(int n) {
        return ((CascadedRowManager)this.m_rows).getParentRow(n);
    }

    public int getChildRow(int n) {
        return ((CascadedRowManager)this.m_rows).getChildRow(n);
    }

    @Override
    public int addRow() {
        if (this.m_parent != null) {
            throw new IllegalStateException("Add row not supported for CascadedTable.");
        }
        return super.addRow();
    }

    @Override
    public void addRows(int n) {
        if (this.m_parent != null) {
            throw new IllegalStateException("Add rows not supported for CascadedTable.");
        }
        super.addRows(n);
    }

    @Override
    public boolean removeRow(int n) {
        if (this.m_parent != null) {
            throw new IllegalStateException("Remove row not supported for CascadedTable.");
        }
        return super.removeRow(n);
    }

    protected int addCascadedRow(int n) {
        int n2 = this.m_rows.addRow();
        ((CascadedRowManager)this.m_rows).put(n2, n);
        this.updateRowCount();
        this.fireTableEvent(n2, n2, -1, 1);
        return n2;
    }

    protected boolean removeCascadedRow(int n) {
        boolean bl = super.removeRow(n);
        if (bl) {
            ((CascadedRowManager)this.m_rows).remove(n);
        }
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        int n2 = this.m_names.size();
        if (n >= n2) {
            return (String)this.m_pnames.get(n - n2);
        }
        return (String)this.m_names.get(n);
    }

    @Override
    public int getColumnNumber(Column column) {
        int n = this.m_columns.indexOf(column);
        if (n == -1 && this.m_parent != null) {
            n = this.m_parent.getColumnNumber(column);
            if (n == -1) {
                return n;
            }
            String string = this.m_parent.getColumnName(n);
            if ((n = this.m_pnames.indexOf(string)) != -1) {
                n += this.m_columns.size();
            }
        }
        return n;
    }

    @Override
    public Column getColumn(int n) {
        this.m_lastCol = n;
        int n2 = this.m_names.size();
        if (n >= n2 && this.m_parent != null) {
            return this.m_parent.getColumn((String)this.m_pnames.get(n - n2));
        }
        return (Column)this.m_columns.get(n);
    }

    @Override
    protected boolean hasColumn(String string) {
        int n = this.getColumnNumber(string);
        return n >= 0 && n < this.getLocalColumnCount();
    }

    @Override
    protected Iterator getColumnNames() {
        if (this.m_parent == null) {
            return this.m_names.iterator();
        }
        return new CompositeIterator(this.m_names.iterator(), this.m_pnames.iterator());
    }

    @Override
    protected void invalidateSchema() {
        super.invalidateSchema();
        this.filterColumns();
    }

    private class Listener
    implements TableListener,
    ProjectionListener,
    ExpressionListener {
        private Listener() {
        }

        @Override
        public void tableChanged(Table table, int n, int n2, int n3, int n4) {
            if (table != CascadedTable.this.m_parent) {
                return;
            }
            CascadedRowManager cascadedRowManager = (CascadedRowManager)CascadedTable.this.m_rows;
            switch (n4) {
                case 0: {
                    if (n3 == -1) break;
                    int n5 = -1;
                    for (int i = n; i <= n2; ++i) {
                        n5 = cascadedRowManager.getChildRow(i);
                        if (n5 != -1) {
                            if (CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(i))) {
                                int n6 = CascadedTable.this.getColumnNumber(CascadedTable.this.m_parent.getColumnName(n3));
                                if (n6 < CascadedTable.this.getLocalColumnCount()) continue;
                                CascadedTable.this.fireTableEvent(n5, n5, n6, 0);
                                continue;
                            }
                            CascadedTable.this.removeCascadedRow(n5);
                            continue;
                        }
                        if (!CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(i)) || (n5 = cascadedRowManager.getChildRow(i)) >= 0) continue;
                        CascadedTable.this.addCascadedRow(i);
                    }
                    break;
                }
                case -1: {
                    if (n3 == -1) {
                        int n7 = -1;
                        for (int i = n; i <= n2; ++i) {
                            n7 = cascadedRowManager.getChildRow(i);
                            if (n7 == -1) continue;
                            CascadedTable.this.removeCascadedRow(n7);
                        }
                        break;
                    }
                    CascadedTable.this.filterColumns();
                    break;
                }
                case 1: {
                    if (n3 == -1) {
                        for (int i = n; i <= n2; ++i) {
                            if (!CascadedTable.this.m_rowFilter.getBoolean(CascadedTable.this.m_parent.getTuple(i)) || cascadedRowManager.getChildRow(i) >= 0) continue;
                            CascadedTable.this.addCascadedRow(i);
                        }
                        break;
                    }
                    CascadedTable.this.filterColumns();
                }
            }
        }

        @Override
        public void projectionChanged(ColumnProjection columnProjection) {
            if (columnProjection == CascadedTable.this.m_colFilter) {
                CascadedTable.this.filterColumns();
            }
        }

        @Override
        public void expressionChanged(Expression expression) {
            if (expression == CascadedTable.this.m_rowFilter) {
                CascadedTable.this.filterRows();
            }
        }
    }
}

