/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.controls.AbstractZoomControl;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class ZoomControl
extends AbstractZoomControl {
    private int yLast;
    private Point2D down = new Point2D.Float();
    private int button = 4;

    public ZoomControl() {
    }

    public ZoomControl(int n) {
        this.button = n;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.button)) {
            Display display = (Display)mouseEvent.getComponent();
            if (display.isTranformInProgress()) {
                this.yLast = -1;
                System.err.println("can't move");
                return;
            }
            display.setCursor(Cursor.getPredefinedCursor(8));
            display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.down);
            this.yLast = mouseEvent.getY();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.button)) {
            Display display = (Display)mouseEvent.getComponent();
            if (display.isTranformInProgress() || this.yLast == -1) {
                this.yLast = -1;
                return;
            }
            int n = mouseEvent.getY();
            int n2 = n - this.yLast;
            double d = 1.0 + (double)n2 / 100.0;
            int n3 = this.zoom(display, this.down, d, true);
            int n4 = 8;
            if (n3 == 3) {
                n4 = 3;
            }
            display.setCursor(Cursor.getPredefinedCursor(n4));
            this.yLast = n;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.button)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_zoomOverItem) {
            this.mousePressed(mouseEvent);
        }
    }

    @Override
    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_zoomOverItem) {
            this.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_zoomOverItem) {
            this.mouseReleased(mouseEvent);
        }
    }
}

