/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.VisualItem;

public class ToolTipControl
extends ControlAdapter {
    private String[] label;
    private StringBuffer sbuf;

    public ToolTipControl(String string) {
        this(new String[]{string});
    }

    public ToolTipControl(String[] stringArray) {
        this.label = stringArray;
        if (stringArray.length > 1) {
            this.sbuf = new StringBuffer();
        }
    }

    @Override
    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getSource();
        if (this.label.length == 1) {
            if (visualItem.canGetString(this.label[0])) {
                display.setToolTipText(visualItem.getString(this.label[0]));
            }
        } else {
            this.sbuf.delete(0, this.sbuf.length());
            for (int i = 0; i < this.label.length; ++i) {
                if (!visualItem.canGetString(this.label[i])) continue;
                if (this.sbuf.length() > 0) {
                    this.sbuf.append("; ");
                }
                this.sbuf.append(visualItem.getString(this.label[i]));
            }
            display.setToolTipText(this.sbuf.toString());
        }
    }

    @Override
    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getSource();
        display.setToolTipText(null);
    }
}

