/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.TreeNodeIterator;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class SquarifiedTreeMapLayout
extends TreeLayout {
    public static final String AREA = "_area";
    public static final Schema AREA_SCHEMA = new Schema();
    private static Comparator s_cmp;
    private ArrayList m_kids = new ArrayList();
    private ArrayList m_row = new ArrayList();
    private Rectangle2D m_r = new Rectangle2D.Double();
    private double m_frame;

    public SquarifiedTreeMapLayout(String string) {
        this(string, 0.0);
    }

    public SquarifiedTreeMapLayout(String string, double d) {
        super(string);
        this.setFrameWidth(d);
    }

    public void setFrameWidth(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Frame value must be greater than or equal to 0.");
        }
        this.m_frame = d;
    }

    public double getFrameWidth() {
        return this.m_frame;
    }

    @Override
    public void run(double d) {
        NodeItem nodeItem = this.getLayoutRoot();
        Rectangle2D rectangle2D = this.getLayoutBounds();
        this.m_r.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - 1.0, rectangle2D.getHeight() - 1.0);
        this.computeAreas(nodeItem);
        this.setX(nodeItem, null, 0.0);
        this.setY(nodeItem, null, 0.0);
        nodeItem.setBounds(0.0, 0.0, this.m_r.getWidth(), this.m_r.getHeight());
        this.updateArea(nodeItem, this.m_r);
        this.layout(nodeItem, this.m_r);
    }

    private void computeAreas(NodeItem nodeItem) {
        double d;
        Object object;
        int n = 0;
        Graph graph = (Graph)this.m_vis.getGroup(this.m_group);
        TupleSet tupleSet = graph.getNodes();
        tupleSet.addColumns(AREA_SCHEMA);
        TreeNodeIterator treeNodeIterator = new TreeNodeIterator(nodeItem);
        while (treeNodeIterator.hasNext()) {
            object = (NodeItem)treeNodeIterator.next();
            object.setDouble(AREA, 0.0);
        }
        treeNodeIterator = new TreeNodeIterator(nodeItem, false);
        while (treeNodeIterator.hasNext()) {
            object = (NodeItem)treeNodeIterator.next();
            d = 0.0;
            if (object.getChildCount() == 0) {
                d = object.getSize();
                ++n;
            } else if (object.isExpanded()) {
                for (NodeItem nodeItem2 = (NodeItem)object.getFirstChild(); nodeItem2 != null; nodeItem2 = (NodeItem)nodeItem2.getNextSibling()) {
                    d += nodeItem2.getDouble(AREA);
                    ++n;
                }
            }
            object.setDouble(AREA, d);
        }
        object = this.getLayoutBounds();
        d = (((RectangularShape)object).getWidth() - 1.0) * (((RectangularShape)object).getHeight() - 1.0);
        double d2 = d / nodeItem.getDouble(AREA);
        treeNodeIterator = new TreeNodeIterator(nodeItem);
        while (treeNodeIterator.hasNext()) {
            NodeItem nodeItem3 = (NodeItem)treeNodeIterator.next();
            nodeItem3.setDouble(AREA, nodeItem3.getDouble(AREA) * d2);
        }
    }

    private void layout(NodeItem nodeItem, Rectangle2D rectangle2D) {
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            this.m_kids.add(iterator.next());
        }
        Collections.sort(this.m_kids, s_cmp);
        double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
        this.squarify(this.m_kids, this.m_row, d, rectangle2D);
        this.m_kids.clear();
        iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            if (nodeItem2.getChildCount() <= 0 || !(nodeItem2.getDouble(AREA) > 0.0)) continue;
            this.updateArea(nodeItem2, rectangle2D);
            this.layout(nodeItem2, rectangle2D);
        }
    }

    private void updateArea(NodeItem nodeItem, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = nodeItem.getBounds();
        if (this.m_frame == 0.0) {
            rectangle2D.setRect(rectangle2D2);
            return;
        }
        double d = 2.0 * this.m_frame * (rectangle2D2.getWidth() + rectangle2D2.getHeight() - 2.0 * this.m_frame);
        double d2 = nodeItem.getDouble(AREA) - d;
        double d3 = 0.0;
        Iterator iterator = nodeItem.children();
        while (iterator.hasNext()) {
            d3 += ((NodeItem)iterator.next()).getDouble(AREA);
        }
        double d4 = d2 / d3;
        iterator = nodeItem.children();
        while (iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            nodeItem2.setDouble(AREA, nodeItem2.getDouble(AREA) * d4);
        }
        rectangle2D.setRect(rectangle2D2.getX() + this.m_frame, rectangle2D2.getY() + this.m_frame, rectangle2D2.getWidth() - 2.0 * this.m_frame, rectangle2D2.getHeight() - 2.0 * this.m_frame);
    }

    private void squarify(List list, List list2, double d, Rectangle2D rectangle2D) {
        int n;
        double d2 = Double.MAX_VALUE;
        while ((n = list.size()) > 0) {
            VisualItem visualItem = (VisualItem)list.get(n - 1);
            double d3 = visualItem.getDouble(AREA);
            if (d3 <= 0.0) {
                list.remove(n - 1);
                continue;
            }
            list2.add(visualItem);
            double d4 = this.worst(list2, d);
            if (d4 <= d2) {
                list.remove(n - 1);
                d2 = d4;
                continue;
            }
            list2.remove(list2.size() - 1);
            rectangle2D = this.layoutRow(list2, d, rectangle2D);
            d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
            list2.clear();
            d2 = Double.MAX_VALUE;
        }
        if (list2.size() > 0) {
            rectangle2D = this.layoutRow(list2, d, rectangle2D);
            list2.clear();
        }
    }

    private double worst(List list, double d) {
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d5 = ((VisualItem)iterator.next()).getDouble(AREA);
            d3 = Math.min(d3, d5);
            d2 = Math.max(d2, d5);
            d4 += d5;
        }
        d4 *= d4;
        d *= d;
        return Math.max(d * d2 / d4, d4 / (d * d3));
    }

    private Rectangle2D layoutRow(List list, double d, Rectangle2D rectangle2D) {
        double d2 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            d2 += ((VisualItem)iterator.next()).getDouble(AREA);
        }
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY();
        double d5 = 0.0;
        double d6 = d == 0.0 ? 0.0 : d2 / d;
        boolean bl = d == rectangle2D.getWidth();
        for (NodeItem nodeItem : list) {
            NodeItem nodeItem2 = (NodeItem)nodeItem.getParent();
            if (bl) {
                this.setX(nodeItem, nodeItem2, d3 + d5);
                this.setY(nodeItem, nodeItem2, d4);
            } else {
                this.setX(nodeItem, nodeItem2, d3);
                this.setY(nodeItem, nodeItem2, d4 + d5);
            }
            double d7 = nodeItem.getDouble(AREA) / d6;
            if (bl) {
                this.setNodeDimensions(nodeItem, d7, d6);
                d5 += d7;
                continue;
            }
            this.setNodeDimensions(nodeItem, d6, d7);
            d5 += d7;
        }
        if (bl) {
            rectangle2D.setRect(d3, d4 + d6, rectangle2D.getWidth(), rectangle2D.getHeight() - d6);
        } else {
            rectangle2D.setRect(d3 + d6, d4, rectangle2D.getWidth() - d6, rectangle2D.getHeight());
        }
        return rectangle2D;
    }

    private void setNodeDimensions(NodeItem nodeItem, double d, double d2) {
        nodeItem.setBounds(nodeItem.getX(), nodeItem.getY(), d, d2);
    }

    static {
        AREA_SCHEMA.addColumn(AREA, Double.TYPE);
        s_cmp = new Comparator(){

            public int compare(Object object, Object object2) {
                double d;
                double d2 = ((VisualItem)object).getDouble(SquarifiedTreeMapLayout.AREA);
                return d2 > (d = ((VisualItem)object2).getDouble(SquarifiedTreeMapLayout.AREA)) ? 1 : (d2 < d ? -1 : 0);
            }
        };
    }
}

