/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.graph.TreeLayout;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ArrayLib;
import prefuse.visual.NodeItem;

public class RadialTreeLayout
extends TreeLayout {
    public static final int DEFAULT_RADIUS = 50;
    private static final int MARGIN = 30;
    protected int m_maxDepth = 0;
    protected double m_radiusInc = 50.0;
    protected double m_theta1 = 0.0;
    protected double m_theta2 = this.m_theta1 + Math.PI * 2;
    protected boolean m_setTheta = false;
    protected boolean m_autoScale = true;
    protected Point2D m_origin;
    protected NodeItem m_prevRoot = null;
    public static final String PARAMS = "_radialTreeLayoutParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public RadialTreeLayout(String string) {
        super(string);
    }

    public RadialTreeLayout(String string, int n) {
        this(string);
        this.m_radiusInc = n;
        this.m_autoScale = false;
    }

    public double getRadiusIncrement() {
        return this.m_radiusInc;
    }

    public void setRadiusIncrement(double d) {
        this.m_radiusInc = d;
    }

    public boolean getAutoScale() {
        return this.m_autoScale;
    }

    public void setAutoScale(boolean bl) {
        this.m_autoScale = bl;
    }

    public void setAngularBounds(double d, double d2) {
        this.m_theta1 = d;
        this.m_theta2 = d + d2;
        this.m_setTheta = true;
    }

    @Override
    public void run(double d) {
        Graph graph = (Graph)this.m_vis.getGroup(this.m_group);
        this.initSchema(graph.getNodes());
        this.m_origin = this.getLayoutAnchor();
        NodeItem nodeItem = this.getLayoutRoot();
        Params params = (Params)nodeItem.get(PARAMS);
        this.m_maxDepth = 0;
        this.calcAngularWidth(nodeItem, 0);
        if (this.m_autoScale) {
            this.setScale(this.getLayoutBounds());
        }
        if (!this.m_setTheta) {
            this.calcAngularBounds(nodeItem);
        }
        if (this.m_maxDepth > 0) {
            this.layout(nodeItem, this.m_radiusInc, this.m_theta1, this.m_theta2);
        }
        this.setX(nodeItem, null, this.m_origin.getX());
        this.setY(nodeItem, null, this.m_origin.getY());
        params.angle = this.m_theta2 - this.m_theta1;
    }

    protected void setScale(Rectangle2D rectangle2D) {
        double d = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
        if (this.m_maxDepth > 0) {
            this.m_radiusInc = (d - 30.0) / (double)this.m_maxDepth;
        }
    }

    private void calcAngularBounds(NodeItem nodeItem) {
        Node node;
        NodeItem nodeItem2;
        if (this.m_prevRoot == null || !this.m_prevRoot.isValid() || nodeItem == this.m_prevRoot) {
            this.m_prevRoot = nodeItem;
            return;
        }
        NodeItem nodeItem3 = this.m_prevRoot;
        while ((nodeItem2 = (NodeItem)nodeItem3.getParent()) != nodeItem) {
            if (nodeItem2 == null) {
                this.m_prevRoot = nodeItem;
                return;
            }
            nodeItem3 = nodeItem2;
        }
        double d = 0.0;
        Iterator iterator = this.sortedChildren(nodeItem);
        while (iterator.hasNext() && (node = (Node)iterator.next()) != nodeItem3) {
            d += ((Params)node.get((String)PARAMS)).width;
        }
        double d2 = ((Params)nodeItem.get((String)PARAMS)).width;
        double d3 = ((Params)nodeItem3.get((String)PARAMS)).width;
        d = Math.PI * -2 * (d + d3 / 2.0) / d2;
        this.m_theta1 = d + Math.atan2(nodeItem3.getY() - nodeItem.getY(), nodeItem3.getX() - nodeItem.getX());
        this.m_theta2 = this.m_theta1 + Math.PI * 2;
        this.m_prevRoot = nodeItem;
    }

    private double calcAngularWidth(NodeItem nodeItem, int n) {
        double d;
        if (n > this.m_maxDepth) {
            this.m_maxDepth = n;
        }
        double d2 = 0.0;
        Rectangle2D rectangle2D = nodeItem.getBounds();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d = n == 0 ? 0.0 : Math.sqrt(d3 * d3 + d4 * d4) / (double)n;
        if (nodeItem.isExpanded() && nodeItem.getChildCount() > 0) {
            Iterator iterator = nodeItem.children();
            while (iterator.hasNext()) {
                NodeItem nodeItem2 = (NodeItem)iterator.next();
                d2 += this.calcAngularWidth(nodeItem2, n + 1);
            }
            d2 = Math.max(d, d2);
        } else {
            d2 = d;
        }
        ((Params)nodeItem.get((String)PARAMS)).width = d2;
        return d2;
    }

    private static final double normalize(double d) {
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    private Iterator sortedChildren(final NodeItem nodeItem) {
        int n;
        double d = 0.0;
        NodeItem nodeItem2 = (NodeItem)nodeItem.getParent();
        if (nodeItem2 != null) {
            d = RadialTreeLayout.normalize(Math.atan2(nodeItem2.getY() - nodeItem.getY(), nodeItem2.getX() - nodeItem.getX()));
        }
        if ((n = nodeItem.getChildCount()) == 0) {
            return null;
        }
        NodeItem nodeItem3 = (NodeItem)nodeItem.getFirstChild();
        if (!nodeItem3.isStartVisible()) {
            return nodeItem.children();
        }
        double[] dArray = new double[n];
        final int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            dArray[n2] = RadialTreeLayout.normalize(-d + Math.atan2(nodeItem3.getY() - nodeItem.getY(), nodeItem3.getX() - nodeItem.getX()));
            ++n2;
            nodeItem3 = (NodeItem)nodeItem3.getNextSibling();
        }
        ArrayLib.sort(dArray, nArray);
        return new Iterator(){
            int cur = 0;

            public Object next() {
                return nodeItem.getChild(nArray[this.cur++]);
            }

            @Override
            public boolean hasNext() {
                return this.cur < nArray.length;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void layout(NodeItem nodeItem, double d, double d2, double d3) {
        double d4 = d3 - d2;
        double d5 = d4 / 2.0;
        double d6 = ((Params)nodeItem.get((String)PARAMS)).width;
        double d7 = 0.0;
        Iterator iterator = this.sortedChildren(nodeItem);
        while (iterator != null && iterator.hasNext()) {
            NodeItem nodeItem2 = (NodeItem)iterator.next();
            Params params = (Params)nodeItem2.get(PARAMS);
            double d8 = params.width / d6;
            if (nodeItem2.isExpanded() && nodeItem2.getChildCount() > 0) {
                this.layout(nodeItem2, d + this.m_radiusInc, d2 + d7 * d4, d2 + (d7 + d8) * d4);
            }
            this.setPolarLocation(nodeItem2, nodeItem, d, d2 + d7 * d4 + d8 * d5);
            params.angle = d8 * d4;
            d7 += d8;
        }
    }

    protected void setPolarLocation(NodeItem nodeItem, NodeItem nodeItem2, double d, double d2) {
        this.setX(nodeItem, nodeItem2, this.m_origin.getX() + d * Math.cos(d2));
        this.setY(nodeItem, nodeItem2, this.m_origin.getY() + d * Math.sin(d2));
    }

    protected void initSchema(TupleSet tupleSet) {
        tupleSet.addColumns(PARAMS_SCHEMA);
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class, new Params());
    }

    public static class Params
    implements Cloneable {
        double width;
        double angle;

        public Object clone() {
            Params params = new Params();
            params.width = this.width;
            params.angle = this.angle;
            return params;
        }
    }
}

