/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Node;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class GridLayout
extends Layout {
    protected int rows;
    protected int cols;
    protected boolean analyze = false;

    public GridLayout(String string) {
        super(string);
        this.analyze = true;
    }

    public GridLayout(String string, int n, int n2) {
        super(string);
        this.rows = n;
        this.cols = n2;
        this.analyze = false;
    }

    @Override
    public void run(double d) {
        Object object;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMinY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        int n = this.rows;
        Object object2 = this.cols;
        if (this.analyze) {
            object = GridLayout.analyzeGraphGrid(tupleSet);
            n = object[0];
            object2 = object[1];
        }
        object = tupleSet.tuples();
        for (int i = 0; object.hasNext() && i < n * object2; ++i) {
            VisualItem visualItem = (VisualItem)object.next();
            visualItem.setVisible(true);
            double d6 = d2 + d4 * ((double)(i % object2) / (double)(object2 - 1));
            double d7 = d3 + d5 * ((double)(i / object2) / (double)(n - 1));
            this.setX(visualItem, null, d6);
            this.setY(visualItem, null, d7);
        }
        while (object.hasNext()) {
            VisualItem visualItem = (VisualItem)object.next();
            visualItem.setVisible(false);
        }
    }

    public static int[] analyzeGraphGrid(TupleSet tupleSet) {
        Node node;
        Iterator iterator = tupleSet.tuples();
        iterator.next();
        int n = 2;
        while (iterator.hasNext() && (node = (Node)iterator.next()).getDegree() != 2) {
            ++n;
        }
        int n2 = tupleSet.getTupleCount() / n;
        return new int[]{n2, n};
    }

    public int getNumCols() {
        return this.cols;
    }

    public void setNumCols(int n) {
        this.cols = n;
    }

    public int getNumRows() {
        return this.rows;
    }

    public void setNumRows(int n) {
        this.rows = n;
    }
}

