/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.expression.Predicate;
import prefuse.data.query.NumberRangeModel;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.MathLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;

public class AxisLayout
extends Layout {
    private String m_field;
    private int m_scale = 0;
    private int m_axis = 0;
    private int m_type = -1;
    private boolean m_modelSet = false;
    private ValuedRangeModel m_model = null;
    private Predicate m_filter = null;
    private double m_min;
    private double m_range;
    private double[] m_dist = new double[2];

    public AxisLayout(String string, String string2) {
        super(string);
        this.m_field = string2;
    }

    public AxisLayout(String string, String string2, int n) {
        this(string, string2);
        this.setAxis(n);
    }

    public AxisLayout(String string, String string2, int n, Predicate predicate) {
        this(string, string2, n);
        this.setFilter(predicate);
    }

    public void setDataField(String string) {
        this.m_field = string;
        if (!this.m_modelSet) {
            this.m_model = null;
        }
    }

    public String getDataField() {
        return this.m_field;
    }

    public void setRangeModel(ValuedRangeModel valuedRangeModel) {
        this.m_model = valuedRangeModel;
        this.m_modelSet = valuedRangeModel != null;
    }

    public ValuedRangeModel getRangeModel() {
        return this.m_model;
    }

    public void setFilter(Predicate predicate) {
        this.m_filter = predicate;
    }

    public Predicate getFilter() {
        return this.m_filter;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Unrecognized scale value: " + n);
        }
        this.m_scale = n;
    }

    public int getAxis() {
        return this.m_axis;
    }

    public void setAxis(int n) {
        if (n < 0 || n >= 2) {
            throw new IllegalArgumentException("Unrecognized axis value: " + n);
        }
        this.m_axis = n;
    }

    public int getDataType() {
        return this.m_type;
    }

    public void setDataType(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("Unrecognized data type value: " + n);
        }
        this.m_type = n;
    }

    @Override
    public void run(double d) {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        this.setMinMax();
        switch (this.getDataType(tupleSet)) {
            case 2: {
                this.numericalLayout(tupleSet);
                break;
            }
            default: {
                this.ordinalLayout(tupleSet);
            }
        }
    }

    protected int getDataType(TupleSet tupleSet) {
        if (this.m_type == -1) {
            boolean bl = true;
            if (tupleSet instanceof Table) {
                bl = ((Table)tupleSet).canGetDouble(this.m_field);
            } else {
                Iterator iterator = tupleSet.tuples();
                while (iterator.hasNext()) {
                    if (((Tuple)iterator.next()).canGetDouble(this.m_field)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                return 2;
            }
            return 1;
        }
        return this.m_type;
    }

    private void setMinMax() {
        Rectangle2D rectangle2D = this.getLayoutBounds();
        if (this.m_axis == 0) {
            this.m_min = rectangle2D.getMinX();
            this.m_range = rectangle2D.getMaxX() - this.m_min;
        } else {
            this.m_min = rectangle2D.getMaxY();
            this.m_range = rectangle2D.getMinY() - this.m_min;
        }
    }

    protected void set(VisualItem visualItem, double d) {
        double d2 = this.m_min + d * this.m_range;
        if (this.m_axis == 0) {
            this.setX(visualItem, null, d2);
        } else {
            this.setY(visualItem, null, d2);
        }
    }

    protected void numericalLayout(TupleSet tupleSet) {
        double d;
        if (!this.m_modelSet) {
            this.m_dist[0] = DataLib.min(tupleSet, this.m_field).getDouble(this.m_field);
            this.m_dist[1] = DataLib.max(tupleSet, this.m_field).getDouble(this.m_field);
            double d2 = this.m_dist[0];
            d = this.m_dist[1];
            if (this.m_model == null) {
                this.m_model = new NumberRangeModel(d2, d, d2, d);
            } else {
                ((NumberRangeModel)this.m_model).setValueRange(d2, d, d2, d);
            }
        } else {
            this.m_dist[0] = ((Number)this.m_model.getLowValue()).doubleValue();
            this.m_dist[1] = ((Number)this.m_model.getHighValue()).doubleValue();
        }
        Iterator iterator = this.m_vis.items(this.m_group, this.m_filter);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            d = visualItem.getDouble(this.m_field);
            double d3 = MathLib.interp(this.m_scale, d, this.m_dist);
            this.set(visualItem, d3);
        }
    }

    protected void ordinalLayout(TupleSet tupleSet) {
        Object[] objectArray;
        if (!this.m_modelSet) {
            objectArray = DataLib.ordinalArray(tupleSet, this.m_field);
            if (this.m_model == null) {
                this.m_model = new ObjectRangeModel(objectArray);
            } else {
                ((ObjectRangeModel)this.m_model).setValueRange(objectArray);
            }
        }
        objectArray = (Object[])this.m_model;
        int n = objectArray.getValue();
        int n2 = n + objectArray.getExtent();
        double d = n2 - n;
        Iterator iterator = this.m_vis.items(this.m_group, this.m_filter);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            int n3 = objectArray.getIndex(visualItem.get(this.m_field)) - n;
            this.set(visualItem, (double)n3 / d);
        }
    }
}

