/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.logging.Logger;
import prefuse.action.layout.AxisLayout;
import prefuse.action.layout.Layout;
import prefuse.data.Schema;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.MathLib;
import prefuse.util.PrefuseLib;
import prefuse.util.ui.ValuedRangeModel;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;

public class AxisLabelLayout
extends Layout {
    public static final String FRAC = "frac";
    public static final String LABEL = "_label";
    public static final String VALUE = "_value";
    private AxisLayout m_layout;
    private ValuedRangeModel m_model;
    private double m_lo;
    private double m_hi;
    private double m_prevlo;
    private double m_prevhi;
    private NumberFormat m_nf = NumberFormat.getInstance();
    private int m_axis;
    private boolean m_asc = true;
    private int m_scale = 0;
    private double m_spacing;

    public AxisLabelLayout(String string, int n, ValuedRangeModel valuedRangeModel) {
        this(string, n, valuedRangeModel, null);
    }

    public AxisLabelLayout(String string, int n, ValuedRangeModel valuedRangeModel, Rectangle2D rectangle2D) {
        super(string);
        if (rectangle2D != null) {
            this.setLayoutBounds(rectangle2D);
        }
        this.m_model = valuedRangeModel;
        this.m_axis = n;
        this.m_spacing = 50.0;
    }

    public AxisLabelLayout(String string, AxisLayout axisLayout) {
        this(string, axisLayout, null, 50.0);
    }

    public AxisLabelLayout(String string, AxisLayout axisLayout, Rectangle2D rectangle2D) {
        this(string, axisLayout, rectangle2D, 50.0);
    }

    public AxisLabelLayout(String string, AxisLayout axisLayout, Rectangle2D rectangle2D, double d) {
        super(string);
        if (rectangle2D != null) {
            this.setLayoutBounds(rectangle2D);
        }
        this.m_layout = axisLayout;
        this.m_model = axisLayout.getRangeModel();
        this.m_axis = axisLayout.getAxis();
        this.m_scale = axisLayout.getScale();
        this.m_spacing = d;
    }

    public NumberFormat getNumberFormat() {
        return this.m_nf;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.m_nf = numberFormat;
    }

    public double getSpacing() {
        return this.m_spacing;
    }

    public void setSpacing(double d) {
        this.m_spacing = d;
    }

    public int getScale() {
        return this.m_scale;
    }

    public void setScale(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Unrecognized scale type: " + n);
        }
        this.m_scale = n;
    }

    public boolean isAscending() {
        return this.m_asc;
    }

    public void setAscending(boolean bl) {
        this.m_asc = bl;
    }

    public void setRangeModel(ValuedRangeModel valuedRangeModel) {
        this.m_model = valuedRangeModel;
    }

    @Override
    public void run(double d) {
        if (this.m_model == null && this.m_layout != null) {
            this.m_model = this.m_layout.getRangeModel();
        }
        if (this.m_model == null) {
            Logger.getLogger(this.getClass().getName()).warning("Axis labels missing a range model.");
            return;
        }
        VisualTable visualTable = this.getTable();
        Double d2 = (Double)visualTable.getClientProperty(FRAC);
        double d3 = d2 == null ? 1.0 : d2;
        this.m_prevlo += d3 * (this.m_lo - this.m_prevlo);
        this.m_prevhi += d3 * (this.m_hi - this.m_prevhi);
        if (this.m_model instanceof ObjectRangeModel) {
            this.m_lo = this.m_model.getValue();
            this.m_hi = this.m_lo + (double)this.m_model.getExtent();
            this.ordinalLayout(visualTable);
        } else {
            this.m_lo = ((Number)this.m_model.getLowValue()).doubleValue();
            this.m_hi = ((Number)this.m_model.getHighValue()).doubleValue();
            switch (this.m_scale) {
                case 1: {
                    this.logLayout(visualTable);
                    break;
                }
                case 2: {
                    this.sqrtLayout(visualTable);
                    break;
                }
                default: {
                    this.linearLayout(visualTable);
                }
            }
        }
        this.garbageCollect(visualTable);
    }

    protected void linearLayout(VisualTable visualTable) {
        double d;
        Object object;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d2 = this.getBreadth(rectangle2D);
        double d3 = this.m_hi - this.m_lo;
        double d4 = this.m_prevhi - this.m_prevlo;
        double d5 = 0.0;
        d5 = this.m_lo >= 0.0 ? Math.pow(10.0, Math.floor(MathLib.log10(this.m_lo))) : -Math.pow(10.0, 1.0 + Math.floor(MathLib.log10(-this.m_lo)));
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            this.reset((VisualItem)object);
            d = object.getDouble(VALUE);
            double d6 = d3 == 0.0 ? 0.0 : (d - this.m_lo) / d3 * d2;
            this.set((VisualItem)object, d6, rectangle2D);
        }
        object = visualTable.index(VALUE);
        d = this.getLinearStep(d3, d3 == 0.0 ? 0.0 : d2 / d3);
        if (d == 0.0) {
            d = 1.0;
        }
        for (double d7 = d5; d7 <= this.m_hi; d7 += d) {
            double d8;
            VisualItem visualItem;
            double d9 = (d7 - this.m_lo) / d3 * d2;
            if (d9 < -0.5) continue;
            int n = object.get(d7);
            if (n >= 0) {
                visualItem = visualTable.getItem(n);
                visualItem.setVisible(true);
                visualItem.setEndVisible(true);
                continue;
            }
            visualItem = visualTable.addItem();
            visualItem.set(LABEL, (Object)this.m_nf.format(d7));
            visualItem.setDouble(VALUE, d7);
            double d10 = d8 = d4 == 0.0 ? 0.0 : (d7 - this.m_prevlo) / d4;
            if (d8 <= 0.0 || d8 >= 1.0) {
                visualItem.setStartVisible(true);
            }
            this.set(visualItem, d8 * d2, rectangle2D);
            this.set(visualItem, d9, rectangle2D);
        }
    }

    protected void sqrtLayout(VisualTable visualTable) {
        double d;
        Object object;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d2 = this.getBreadth(rectangle2D);
        double d3 = this.m_hi - this.m_lo;
        double d4 = MathLib.safeSqrt(this.m_prevlo);
        double d5 = MathLib.safeSqrt(this.m_prevhi) - d4;
        double d6 = Math.pow(10.0, Math.floor(MathLib.safeLog10(this.m_lo)));
        double d7 = MathLib.safeSqrt(this.m_lo);
        double d8 = MathLib.safeSqrt(this.m_hi) - d7;
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            this.reset((VisualItem)object);
            d = object.getDouble(VALUE);
            double d9 = d3 == 0.0 ? 0.0 : (MathLib.safeSqrt(d) - d7) / d8 * d2;
            this.set((VisualItem)object, d9, rectangle2D);
        }
        object = visualTable.index(VALUE);
        d = this.getLinearStep(d3, d2 / d3);
        if (d == 0.0) {
            d = 1.0;
        }
        for (double d10 = d6; d10 <= this.m_hi; d10 += d) {
            double d11;
            VisualItem visualItem;
            double d12 = (MathLib.safeSqrt(d10) - d7) / d8 * d2;
            if (d12 < -0.5) continue;
            int n = object.get(d10);
            if (n >= 0) {
                visualItem = visualTable.getItem(n);
                visualItem.setVisible(true);
                visualItem.setEndVisible(true);
                continue;
            }
            visualItem = visualTable.addItem();
            visualItem.set(LABEL, (Object)this.m_nf.format(d10));
            visualItem.setDouble(VALUE, d10);
            double d13 = d11 = d5 == 0.0 ? 0.0 : (MathLib.safeSqrt(d10) - d4) / d5;
            if (d11 <= 0.0 || d11 >= 1.0) {
                visualItem.setStartVisible(true);
            }
            this.set(visualItem, d11 * d2, rectangle2D);
            this.set(visualItem, d12, rectangle2D);
        }
    }

    protected void logLayout(VisualTable visualTable) {
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d = this.getBreadth(rectangle2D);
        visualTable.clear();
        double d2 = MathLib.safeLog10(this.m_lo);
        double d3 = MathLib.safeLog10(this.m_hi);
        double d4 = d3 - d2;
        double d5 = MathLib.log10(d3 - d2);
        int n = (int)Math.floor(d5);
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.ceil(d3);
        double d6 = Math.pow(10.0, n2);
        double d7 = Math.pow(10.0, n3);
        double d8 = d6 * Math.pow(10.0, n);
        double d9 = d6;
        double d10 = 0.0;
        while (d9 <= d7) {
            double d11 = MathLib.safeLog10(d9);
            if (d10 != 0.0 && Math.abs(d11 - (double)Math.round(d11)) < 1.0E-4) {
                d10 = 0.0;
                d8 = 10.0 * d8;
            }
            if (!((d11 = (d11 - d2) / d4 * d) < -0.5)) {
                VisualItem visualItem = visualTable.addItem();
                this.set(visualItem, d11, rectangle2D);
                String string = d10 == 0.0 ? this.m_nf.format(d9) : null;
                visualItem.set(LABEL, (Object)string);
                visualItem.setDouble(VALUE, d9);
            }
            d9 += d8;
            d10 += 1.0;
        }
    }

    protected double getBreadth(Rectangle2D rectangle2D) {
        switch (this.m_axis) {
            case 0: {
                return rectangle2D.getWidth();
            }
        }
        return rectangle2D.getHeight();
    }

    protected double adjust(double d) {
        switch (this.m_scale) {
            case 1: {
                return Math.pow(10.0, d);
            }
            case 2: {
                return d * d;
            }
        }
        return d;
    }

    protected double getLinearStep(double d, double d2) {
        double d3 = Math.log(d) / Math.log(10.0);
        double d4 = Math.pow(10.0, Math.floor(d3));
        double d5 = d4 * d2 / this.m_spacing;
        if (d5 > 20.0) {
            d4 /= 20.0;
        } else if (d5 > 10.0) {
            d4 /= 10.0;
        } else if (d5 > 5.0) {
            d4 /= 5.0;
        } else if (d5 > 4.0) {
            d4 /= 4.0;
        } else if (d5 > 2.0) {
            d4 /= 2.0;
        } else if (d5 < 1.0) {
            d4 *= 2.0;
        }
        return d4;
    }

    protected void ordinalLayout(VisualTable visualTable) {
        Object object;
        ObjectRangeModel objectRangeModel = (ObjectRangeModel)this.m_model;
        double d = this.m_hi - this.m_lo;
        double d2 = this.m_prevhi - this.m_prevlo;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        double d3 = this.getBreadth(rectangle2D);
        double d4 = d3 / d;
        int n = this.getOrdinalStep(d, d4);
        if (n <= 0) {
            n = 1;
        }
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            this.reset((VisualItem)object);
            double d5 = object.getDouble(VALUE);
            double d6 = d == 0.0 ? 0.0 : (d5 - this.m_lo) / d * d3;
            this.set((VisualItem)object, d6, rectangle2D);
        }
        object = visualTable.index(VALUE);
        int n2 = (int)this.m_lo;
        while ((double)n2 <= this.m_hi) {
            VisualItem visualItem;
            int n3 = object.get((double)n2);
            if (n3 >= 0) {
                visualItem = visualTable.getItem(n3);
                visualItem.set(VisualItem.LABEL, (Object)objectRangeModel.getObject(n2).toString());
                visualItem.setVisible(true);
                visualItem.setEndVisible(true);
            } else {
                double d7;
                visualItem = visualTable.addItem();
                visualItem.set(VisualItem.LABEL, (Object)objectRangeModel.getObject(n2).toString());
                visualItem.setDouble(VisualItem.VALUE, (double)n2);
                double d8 = d7 = d2 == 0.0 ? 0.0 : ((double)n2 - this.m_prevlo) / d2;
                if (d7 <= 0.0 || d7 >= 1.0) {
                    visualItem.setStartVisible(true);
                }
                this.set(visualItem, d7 * d3, rectangle2D);
                this.set(visualItem, ((double)n2 - this.m_lo) * d3 / d, rectangle2D);
            }
            n2 += n;
        }
    }

    protected int getOrdinalStep(double d, double d2) {
        return d2 >= this.m_spacing ? 1 : (int)Math.ceil(this.m_spacing / d2);
    }

    protected void set(VisualItem visualItem, double d, Rectangle2D rectangle2D) {
        switch (this.m_axis) {
            case 0: {
                d = this.m_asc ? d + rectangle2D.getMinX() : rectangle2D.getMaxX() - d;
                PrefuseLib.updateDouble(visualItem, VisualItem.X, d);
                PrefuseLib.updateDouble(visualItem, VisualItem.Y, rectangle2D.getMinY());
                PrefuseLib.updateDouble(visualItem, VisualItem.X2, d);
                PrefuseLib.updateDouble(visualItem, VisualItem.Y2, rectangle2D.getMaxY());
                break;
            }
            case 1: {
                d = this.m_asc ? rectangle2D.getMaxY() - d - 1.0 : d + rectangle2D.getMinY();
                PrefuseLib.updateDouble(visualItem, VisualItem.X, rectangle2D.getMinX());
                PrefuseLib.updateDouble(visualItem, VisualItem.Y, d);
                PrefuseLib.updateDouble(visualItem, VisualItem.X2, rectangle2D.getMaxX());
                PrefuseLib.updateDouble(visualItem, VisualItem.Y2, d);
            }
        }
    }

    protected void reset(VisualItem visualItem) {
        visualItem.setVisible(false);
        visualItem.setEndVisible(false);
        visualItem.setStartStrokeColor(visualItem.getStrokeColor());
        visualItem.revertToDefault(VisualItem.STROKECOLOR);
        visualItem.revertToDefault(VisualItem.ENDSTROKECOLOR);
        visualItem.setStartTextColor(visualItem.getTextColor());
        visualItem.revertToDefault(VisualItem.TEXTCOLOR);
        visualItem.revertToDefault(VisualItem.ENDTEXTCOLOR);
        visualItem.setStartFillColor(visualItem.getFillColor());
        visualItem.revertToDefault(VisualItem.FILLCOLOR);
        visualItem.revertToDefault(VisualItem.ENDFILLCOLOR);
    }

    protected void garbageCollect(VisualTable visualTable) {
        Iterator iterator = visualTable.tuples();
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            if (visualItem.isStartVisible() || visualItem.isEndVisible()) continue;
            visualTable.removeTuple(visualItem);
        }
    }

    protected VisualTable getTable() {
        TupleSet tupleSet = this.m_vis.getGroup(this.m_group);
        if (tupleSet == null) {
            Schema schema = PrefuseLib.getAxisLabelSchema();
            VisualTable visualTable = this.m_vis.addTable(this.m_group, schema);
            visualTable.index(VALUE);
            return visualTable;
        }
        if (tupleSet instanceof VisualTable) {
            return (VisualTable)tupleSet;
        }
        throw new IllegalStateException("Group already exists, not being used for labels");
    }
}

