/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.visual.VisualItem;

public abstract class Distortion
extends Layout {
    private Point2D m_tmp = new Point2D.Double();
    protected boolean m_distortSize = true;
    protected boolean m_distortX = true;
    protected boolean m_distortY = true;

    public Distortion() {
    }

    public Distortion(String string) {
        super(string);
    }

    public void setSizeDistorted(boolean bl) {
        this.m_distortSize = bl;
    }

    public boolean isSizeDistorted() {
        return this.m_distortSize;
    }

    @Override
    public void run(double d) {
        Rectangle2D rectangle2D = this.getLayoutBounds();
        Point2D point2D = this.correct(this.m_anchor, rectangle2D);
        Iterator iterator = this.getVisualization().visibleItems(this.m_group);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            if (visualItem.isFixed()) continue;
            visualItem.setX(visualItem.getEndX());
            visualItem.setY(visualItem.getEndY());
            visualItem.setSize(visualItem.getEndSize());
            if (point2D == null) continue;
            Rectangle2D rectangle2D2 = visualItem.getBounds();
            double d2 = visualItem.getX();
            double d3 = visualItem.getY();
            if (this.m_distortX) {
                d2 = this.distortX(d2, point2D, rectangle2D);
                visualItem.setX(d2);
            }
            if (this.m_distortY) {
                d3 = this.distortY(d3, point2D, rectangle2D);
                visualItem.setY(d3);
            }
            if (!this.m_distortSize) continue;
            double d4 = this.distortSize(rectangle2D2, d2, d3, point2D, rectangle2D);
            visualItem.setSize(d4 * visualItem.getSize());
        }
    }

    protected Point2D correct(Point2D point2D, Rectangle2D rectangle2D) {
        if (point2D == null) {
            return point2D;
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = rectangle2D.getMinX();
        double d4 = rectangle2D.getMinY();
        double d5 = rectangle2D.getMaxX();
        double d6 = rectangle2D.getMaxY();
        double d7 = d < d3 ? d3 : (d = d > d5 ? d5 : d);
        d2 = d2 < d4 ? d4 : (d2 > d6 ? d6 : d2);
        this.m_tmp.setLocation(d, d2);
        return this.m_tmp;
    }

    protected abstract double distortX(double var1, Point2D var3, Rectangle2D var4);

    protected abstract double distortY(double var1, Point2D var3, Rectangle2D var4);

    protected abstract double distortSize(Rectangle2D var1, double var2, double var4, Point2D var6, Rectangle2D var7);
}

