/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.visual.VisualItem;

public class SizeAction
extends EncoderAction {
    protected double m_defaultSize = 1.0;

    public SizeAction() {
    }

    public SizeAction(String string) {
        super(string);
    }

    public SizeAction(String string, double d) {
        super(string);
        this.m_defaultSize = d;
    }

    public double getDefaultSize() {
        return this.m_defaultSize;
    }

    public void setDefaultSize(double d) {
        this.m_defaultSize = d;
    }

    public void add(Predicate predicate, double d) {
        super.add(predicate, new Double(d));
    }

    public void add(String string, double d) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        this.add(predicate, d);
    }

    public void add(Predicate predicate, SizeAction sizeAction) {
        super.add(predicate, sizeAction);
    }

    public void add(String string, SizeAction sizeAction) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        super.add(predicate, sizeAction);
    }

    @Override
    public void process(VisualItem visualItem, double d) {
        double d2 = this.getSize(visualItem);
        double d3 = visualItem.getSize();
        visualItem.setStartSize(d3);
        visualItem.setEndSize(d2);
        visualItem.setSize(d2);
    }

    public double getSize(VisualItem visualItem) {
        Object object = this.lookup(visualItem);
        if (object != null) {
            if (object instanceof SizeAction) {
                return ((SizeAction)object).getSize(visualItem);
            }
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.m_defaultSize;
    }
}

