/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.awt.Font;
import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;

public class FontAction
extends EncoderAction {
    protected Font defaultFont = FontLib.getFont("SansSerif", 0, 10);

    public FontAction() {
    }

    public FontAction(String string) {
        super(string);
    }

    public FontAction(String string, Font font) {
        super(string);
        this.defaultFont = font;
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void add(Predicate predicate, Font font) {
        super.add(predicate, font);
    }

    public void add(String string, Font font) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        super.add(predicate, font);
    }

    public void add(Predicate predicate, FontAction fontAction) {
        super.add(predicate, fontAction);
    }

    public void add(String string, FontAction fontAction) {
        Predicate predicate = (Predicate)ExpressionParser.parse(string);
        super.add(predicate, fontAction);
    }

    @Override
    public void process(VisualItem visualItem, double d) {
        Font font = this.getFont(visualItem);
        Font font2 = visualItem.getFont();
        visualItem.setStartFont(font2);
        visualItem.setEndFont(font);
        visualItem.setFont(font);
    }

    public Font getFont(VisualItem visualItem) {
        Object object = this.lookup(visualItem);
        if (object != null) {
            if (object instanceof FontAction) {
                return ((FontAction)object).getFont(visualItem);
            }
            if (object instanceof Font) {
                return (Font)object;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.defaultFont;
    }
}

