/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import prefuse.action.ItemAction;
import prefuse.util.ColorLib;
import prefuse.util.PrefuseLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.visual.VisualItem;

public class ColorAnimator
extends ItemAction {
    private static final String[] DEFAULTS = new String[]{VisualItem.STROKECOLOR, VisualItem.FILLCOLOR, VisualItem.TEXTCOLOR};
    private CopyOnWriteArrayList m_colorFields;

    public ColorAnimator() {
        this.setColorFields(DEFAULTS);
    }

    public ColorAnimator(String string) {
        super(string);
        this.setColorFields(DEFAULTS);
    }

    public ColorAnimator(String string, String string2) {
        super(string);
        this.setColorFields(new String[]{string2});
    }

    public ColorAnimator(String string, String[] stringArray) {
        super(string);
        this.setColorFields(stringArray);
    }

    public void setColorFields(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        if (this.m_colorFields == null) {
            this.m_colorFields = new CopyOnWriteArrayList();
        } else {
            this.m_colorFields.clear();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_colorFields.add(stringArray[i]);
            this.m_colorFields.add(PrefuseLib.getStartField(stringArray[i]));
            this.m_colorFields.add(PrefuseLib.getEndField(stringArray[i]));
        }
    }

    @Override
    public void process(VisualItem visualItem, double d) {
        if (this.m_colorFields == null) {
            return;
        }
        Object[] objectArray = this.m_colorFields.getArray();
        for (int i = 0; i < objectArray.length; i += 3) {
            String string = (String)objectArray[i];
            String string2 = (String)objectArray[i + 1];
            String string3 = (String)objectArray[i + 2];
            int n = visualItem.getInt(string2);
            int n2 = visualItem.getInt(string3);
            int n3 = ColorLib.interp(n, n2, d);
            visualItem.setInt(string, n3);
        }
    }
}

