/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.ui.panels;

import bbk.dng.actions.SearchPanelActions;
import com.jgoodies.forms.factories.Borders;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;

public class GraphStylePanel
extends JPanel {
    private JButton graphRenderButton;
    private JSlider edgeLengthSlider;
    private JSlider connectivityFilterSlider;
    private JLabel progNameLabel;
    private JLabel plotOptionsLabel;
    private ButtonGroup nodeDisplayButtonGroup;
    private JRadioButton domainsOnlyRadioButton;
    private JRadioButton addSequencesRadioButton;
    private JRadioButton addStructuresRadioButton;
    private JRadioButton addEnzymesRadioButton;
    private JLabel navigationLabel;

    public GraphStylePanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.graphRenderButton = new JButton();
        JLabel label1 = new JLabel();
        this.edgeLengthSlider = new JSlider(0, 1, 100, 20);
        JLabel label2 = new JLabel();
        this.connectivityFilterSlider = new JSlider(0, 0, 20, 20);
        JPanel panel1 = new JPanel();
        JCheckBox checkBox1 = new JCheckBox();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        JLabel label3 = new JLabel();
        JComboBox comboBox1 = new JComboBox();
        this.progNameLabel = new JLabel();
        this.plotOptionsLabel = new JLabel();
        this.nodeDisplayButtonGroup = new ButtonGroup();
        this.domainsOnlyRadioButton = new JRadioButton();
        this.addSequencesRadioButton = new JRadioButton();
        this.addStructuresRadioButton = new JRadioButton();
        this.addEnzymesRadioButton = new JRadioButton();
        this.navigationLabel = new JLabel();
        this.setBorder(Borders.TABBED_DIALOG_BORDER);
        this.setLayout(new GridBagLayout());
        ((GridBagLayout)this.getLayout()).columnWidths = new int[]{300, 0};
        ((GridBagLayout)this.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)this.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.progNameLabel.setName("progNameLabel");
        this.progNameLabel.setFont(new Font("Serif", 1, 16));
        this.progNameLabel.setText("ArchSchema");
        this.add((Component)this.progNameLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 19, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.plotOptionsLabel.setName("plotOptionsLabel");
        this.plotOptionsLabel.setFont(new Font("Serif", 1, 14));
        this.plotOptionsLabel.setText("Plot options");
        this.add((Component)this.plotOptionsLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        int domainType = SearchPanelActions.getInstance().getDomainType();
        this.nodeDisplayButtonGroup.add(this.domainsOnlyRadioButton);
        this.nodeDisplayButtonGroup.add(this.addSequencesRadioButton);
        this.nodeDisplayButtonGroup.add(this.addStructuresRadioButton);
        this.nodeDisplayButtonGroup.add(this.addEnzymesRadioButton);
        this.domainsOnlyRadioButton.setName("domainsOnlyRadioButton");
        if (domainType == 0) {
            this.domainsOnlyRadioButton.setText("Pfam domain architectures only");
        } else {
            this.domainsOnlyRadioButton.setText("CATH domain architectures only");
        }
        this.domainsOnlyRadioButton.setSelected(true);
        this.addSequencesRadioButton.setName("addSequencesRadioButton");
        this.addSequencesRadioButton.setText("Add UniProt sequences");
        this.addStructuresRadioButton.setName("addStructuresRadioButton");
        this.addStructuresRadioButton.setText("Add PDB structures");
        this.addEnzymesRadioButton.setName("addEnzymesRadioButton");
        this.addEnzymesRadioButton.setText("Add enzyme classes");
        this.add((Component)this.domainsOnlyRadioButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.addSequencesRadioButton, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.addStructuresRadioButton, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.addEnzymesRadioButton, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 20, 0), 0, 0));
        label1.setText("Adjust lengths of edges between nodes:");
        label1.setLabelFor(this.edgeLengthSlider);
        this.edgeLengthSlider.setValue(20);
        Dimension d = this.edgeLengthSlider.getPreferredSize();
        d.width = 280;
        this.edgeLengthSlider.setPreferredSize(d);
        this.edgeLengthSlider.setMinimumSize(new Dimension(280, d.height));
        this.add((Component)label1, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.edgeLengthSlider, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 20, 0), 0, 0));
        label2.setText("Prune outer nodes in graph:");
        label2.setLabelFor(this.connectivityFilterSlider);
        this.connectivityFilterSlider.setValue(20);
        d = this.connectivityFilterSlider.getPreferredSize();
        d.width = 280;
        this.connectivityFilterSlider.setPreferredSize(d);
        this.connectivityFilterSlider.setMinimumSize(new Dimension(280, d.height));
        this.add((Component)label2, new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.connectivityFilterSlider, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 20, 0), 0, 0));
        this.graphRenderButton.setText("Freeze Graph");
        this.add((Component)this.graphRenderButton, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        JLabel help = new JLabel();
        help.setText("<html><body><B>Navigation</B><p>&middot; <B>Pan</B> around the plot by left-click-dragging on graph background.<BR>&middot; <B>Zoom</B> in and out by right-click-dragging on graph background.<BR>&middot; <B>Move nodes</B> by left-click-dragging them.<BR>&middot; <B>Recentre graph</B> by single right-click on graph background.<BR>&middot; <B>Recentre on parent sequence</B> by single middle-click on graph background.<BR>&middot; <B>Show domain info</B> by single left-click on architecture node.<BR>&middot; <B>Reset data panel</B> by double left-click on graph background.<BR></body></html>");
        this.add((Component)help, new GridBagConstraints(0, 12, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 5, 20, 0), 0, 0));
    }

    public JButton getGraphRenderButton() {
        return this.graphRenderButton;
    }

    public JSlider getEdgeLengthSlider() {
        return this.edgeLengthSlider;
    }

    public JSlider getConnectivityFilterSlider() {
        return this.connectivityFilterSlider;
    }

    public void setDomainsOnlyRadioButton(int domainType) {
        if (domainType == 0) {
            this.domainsOnlyRadioButton.setText("Pfam domain architectures only");
        } else {
            this.domainsOnlyRadioButton.setText("CATH domain architectures only");
        }
    }

    public JRadioButton getDomainsOnlyRadioButton() {
        return this.domainsOnlyRadioButton;
    }

    public JRadioButton getAddSequencesRadioButton() {
        return this.addSequencesRadioButton;
    }

    public JRadioButton getAddStructuresRadioButton() {
        return this.addStructuresRadioButton;
    }

    public JRadioButton getAddEnzymesRadioButton() {
        return this.addEnzymesRadioButton;
    }
}

