/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.graph;

import bbk.dng.actions.GraphStylePanelActions;
import bbk.dng.graph.CountdownPainter;
import bbk.dng.ui.panels.AppFrame;
import prefuse.action.layout.graph.ForceDirectedLayout;

public class RenderingCountdown
implements Runnable {
    private static boolean running = false;
    private static boolean restart = false;
    private static int countdownSteps = 10;
    private CountdownPainter dsp;
    private ForceDirectedLayout f;
    private AppFrame appFrame;

    public RenderingCountdown(AppFrame appFrame) {
        this.appFrame = appFrame;
        this.f = (ForceDirectedLayout)appFrame.getGraphPanel().getActionLayout().get(1);
    }

    public void run() {
        if (!running) {
            running = true;
            this.dsp = new CountdownPainter();
            this.appFrame.getGraphPanel().getVisualization().getDisplay(0).addPaintListener(this.dsp);
            this.f.getForceSimulator().setSpeedLimit(1.0f);
            try {
                for (int i = 0; i < countdownSteps; ++i) {
                    this.dsp.count = countdownSteps - i;
                    Thread.sleep(1000L);
                    this.f.getForceSimulator().setSpeedLimit(this.f.getForceSimulator().getSpeedLimit() - 1.0f / (float)countdownSteps);
                    if (restart) {
                        this.f.getForceSimulator().setSpeedLimit(1.0f);
                        i = 0;
                        restart = false;
                    }
                    if (!GraphStylePanelActions.getInstance().getGraphRenderingStatus().equals("stopped")) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stop();
        } else {
            restart = true;
        }
    }

    public void stop() {
        if (running) {
            this.f.getForceSimulator().setSpeedLimit(1.0f);
            if (!GraphStylePanelActions.getInstance().getGraphRenderingStatus().equals("stopped")) {
                GraphStylePanelActions.getInstance().toggleGraphAction(this.appFrame);
            }
            this.appFrame.getGraphPanel().getVisualization().getDisplay(0).removePaintListener(this.dsp);
            running = false;
        }
    }
}

