/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.graph;

import bbk.dng.graph.ArchitectureImageRenderer;
import bbk.dng.graph.CustomizedForceDirectedLayout;
import bbk.dng.utils.CollectionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.filter.GraphDistanceFilter;
import prefuse.controls.DragControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.ToolTipControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.force.DragForce;
import prefuse.util.force.ForceSimulator;
import prefuse.util.force.NBodyForce;
import prefuse.util.force.RungeKuttaIntegrator;
import prefuse.util.force.SpringForce;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphPanel
extends JPanel {
    public static final String GRAPH = "graph";
    public static final String NODES = "graph.nodes";
    public static final String EDGES = "graph.edges";
    public static final String AGGR = "aggregates";
    public static final int GRAPH_NHOPS = 20;
    private static String fontFamily = null;
    private boolean startScreen = true;
    public static final String[] PREFERRED_FONT_NAME = new String[]{"Times New Roman", "Helvetica", "Georgia", "Bookman Old Style", "Arial"};
    public static final int ARCH_NODE = 0;
    public static final int SATELLITE_NODE = 1;
    public static final String[] NODE_DESC = new String[]{"Architecture", "Satellite"};
    private ActionList layout;
    private Visualization m_vis = new Visualization();
    private GraphDistanceFilter filter;

    public ActionList getActionLayout() {
        return this.layout;
    }

    public GraphDistanceFilter getFilter() {
        return this.filter;
    }

    public GraphPanel(boolean useCATH) {
        super(new BorderLayout());
        this.m_vis.setInteractive(EDGES, null, false);
        this.m_vis.setValue(NODES, null, VisualItem.SHAPE, 1);
        LabelRenderer tr = new LabelRenderer("name");
        String domainSeparator = "\\.";
        DefaultRendererFactory rf = new DefaultRendererFactory(new ArchitectureImageRenderer(new HashMap<String, Integer>(), domainSeparator, useCATH));
        Predicate p0 = ExpressionParser.predicate("name==sequences");
        rf.add(p0, (Renderer)tr);
        this.m_vis.setRendererFactory(rf);
        ColorAction nStroke = new ColorAction(NODES, VisualItem.STROKECOLOR);
        nStroke.setDefaultColor(ColorLib.gray(100));
        nStroke.add("_hover", ColorLib.gray(50));
        ColorAction nFill = new ColorAction(NODES, VisualItem.FILLCOLOR);
        nFill.setDefaultColor(ColorLib.gray(255));
        nFill.add("_hover", ColorLib.gray(200));
        ColorAction nEdges = new ColorAction(EDGES, VisualItem.STROKECOLOR);
        nEdges.setDefaultColor(ColorLib.gray(100));
        ColorAction aStroke = new ColorAction(AGGR, VisualItem.STROKECOLOR);
        aStroke.setDefaultColor(ColorLib.gray(200));
        aStroke.add("_hover", ColorLib.rgb(255, 100, 100));
        TupleSet focusGroup = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                for (Tuple aRem : rem) {
                    ((VisualItem)aRem).setFixed(false);
                }
                for (Tuple anAdd : add) {
                    ((VisualItem)anAdd).setFixed(false);
                    ((VisualItem)anAdd).setFixed(true);
                }
                if (ts.getTupleCount() == 0) {
                    ts.addTuple(rem[0]);
                    ((VisualItem)rem[0]).setFixed(false);
                }
                GraphPanel.this.m_vis.runAfter("draw", "layout");
            }
        });
        int hops = 20;
        this.filter = new GraphDistanceFilter(GRAPH, hops);
        ActionList colors = new ActionList();
        colors.add(this.filter);
        colors.add(nStroke);
        colors.add(nEdges);
        colors.add(aStroke);
        colors.add(new ColorAction(NODES, VisualItem.TEXTCOLOR, ColorLib.gray(0)));
        ForceSimulator fsim = new ForceSimulator(new RungeKuttaIntegrator());
        float gravConstant = -1.0f;
        float minDistance = -1.0f;
        float theta = 0.9f;
        float drag = 0.004f;
        float springCoeff = 1.0E-4f;
        float defaultLength = 150.0f;
        fsim.addForce(new NBodyForce(gravConstant, minDistance, theta));
        fsim.addForce(new DragForce(drag));
        fsim.addForce(new SpringForce(springCoeff, defaultLength));
        CustomizedForceDirectedLayout fdl = new CustomizedForceDirectedLayout(GRAPH, fsim, false);
        this.layout = new ActionList(-1L);
        this.layout.add(colors);
        this.layout.add(fdl);
        this.layout.add(new RepaintAction());
        this.m_vis.putAction("layout", this.layout);
        Display display = new Display(this.m_vis);
        display.setDamageRedraw(false);
        display.setSize(500, 500);
        display.pan(250.0, 250.0);
        display.setForeground(Color.GRAY);
        display.setBackground(Color.WHITE);
        display.setHighQuality(true);
        display.addControlListener(new ZoomControl());
        display.addControlListener(new ZoomToFitControl());
        display.addControlListener(new PanControl());
        display.addControlListener(new NeighborHighlightControl());
        display.addControlListener(new DragControl());
        display.addControlListener(new ToolTipControl("label"));
        display.setItemSorter(new ItemSorter(){

            public int score(VisualItem item) {
                String type = item.getString("type");
                if (type == null || !type.equals("architecture")) {
                    return 10;
                }
                return 20;
            }
        });
        this.m_vis.run("layout");
        this.add(display);
    }

    public Visualization getVisualization() {
        return this.m_vis;
    }

    public void panToParent(Visualization vis) {
        TupleSet t = this.getVisualization().getGroup(NODES);
        Iterator i = t.tuples();
        while (i.hasNext()) {
            Tuple tup = (Tuple)i.next();
            if (!tup.getBoolean("parent")) continue;
            VisualItem parent = vis.getVisualItem(NODES, tup);
            Display display = vis.getDisplay(0);
            display.panToAbs(new Point((int)parent.getX(), (int)parent.getY()));
            display.repaint();
        }
    }

    public void zoomToFit(Visualization vis) {
        Display display = vis.getDisplay(0);
        Rectangle2D bounds = display.getItemBounds();
        double margin = 50 + (int)(1.0 / display.getScale());
        GraphicsLib.expand(bounds, margin);
        DisplayLib.fitViewToBounds(display, bounds, 1000L);
        display.repaint();
    }

    public void setDomainColours(Map<String, Integer> domainColour, String domainSeparator, boolean useCATH) {
        DefaultRendererFactory rf = new DefaultRendererFactory(new ArchitectureImageRenderer(domainColour, domainSeparator, useCATH));
        LabelRenderer tr = new LabelRenderer("name");
        tr.setRoundedCorner(5, 5);
        tr.setHorizontalPadding(4);
        Predicate p0 = ExpressionParser.predicate("name==sequences");
        rf.add(p0, (Renderer)tr);
        this.m_vis.setRendererFactory(rf);
    }

    public void clearGraph() {
        Visualization v = this.getVisualization();
        v.getGroup(Visualization.FOCUS_ITEMS).clear();
        v.removeGroup(GRAPH);
        v.repaint();
    }

    public synchronized void tracePathToParent(Visualization vis, VisualItem item, String architecture, boolean useCATH) {
        String parentArchitecture = this.findParent(vis);
        boolean isParent = this.checkIfParent(item);
        boolean allOn = false;
        Map<Integer, VisualItem> nodeMap = this.getGraphNodesMap(vis);
        boolean[] selectedNode = this.getNodesInPath(vis, nodeMap, architecture, parentArchitecture, isParent);
        selectedNode = this.flagSatellites(vis, nodeMap, selectedNode);
        this.switchNodesOnOff(vis, nodeMap, selectedNode);
        this.switchEdgesOnOff(vis, nodeMap, selectedNode);
        Display display = vis.getDisplay(0);
        display.repaint();
    }

    public Map<Integer, VisualItem> getGraphNodesMap(Visualization vis) {
        TupleSet ts = vis.getGroup(NODES);
        Map<Integer, VisualItem> nodeMap = CollectionUtils.newMap();
        Iterator iter = ts.tuples();
        while (iter.hasNext()) {
            Tuple tup = (Tuple)iter.next();
            VisualItem node = vis.getVisualItem(NODES, tup);
            int row = node.getRow();
            nodeMap.put(row, node);
        }
        return nodeMap;
    }

    private void switchNodesOnOff(Visualization vis, Map<Integer, VisualItem> nodeMap, boolean[] selectedNode) {
        for (int i = 0; i < nodeMap.size(); ++i) {
            VisualItem node = nodeMap.get(i);
            if (selectedNode[i]) {
                node.setVisible(true);
                continue;
            }
            node.setVisible(false);
        }
    }

    private String findParent(Visualization vis) {
        boolean done = false;
        String parentArchitecture = "";
        TupleSet ts = vis.getGroup(NODES);
        Iterator iter = ts.tuples();
        while (iter.hasNext() && !done) {
            Tuple tup = (Tuple)iter.next();
            VisualItem node = vis.getVisualItem(NODES, tup);
            if (!this.checkIfParent(node)) continue;
            parentArchitecture = node.getString("name");
            done = true;
        }
        return parentArchitecture;
    }

    private boolean checkIfParent(VisualItem item) {
        boolean isParent = false;
        if (item.getSourceTuple().getBoolean("parent")) {
            isParent = true;
        }
        return isParent;
    }

    private boolean[] getNodesInPath(Visualization vis, Map<Integer, VisualItem> nodeMap, String startArchitecture, String endArchitecture, boolean parent) {
        int i;
        boolean done = false;
        int nNodes = nodeMap.size();
        boolean[] used = new boolean[nNodes];
        boolean[] nodeSelected = new boolean[nNodes];
        for (i = 0; i < nodeMap.size(); ++i) {
            nodeSelected[i] = false;
        }
        if (parent) {
            for (i = 0; i < nodeMap.size(); ++i) {
                nodeSelected[i] = true;
            }
            return nodeSelected;
        }
        Set<List> paths = CollectionUtils.newSet();
        int startNode = this.getNodeNumber(nodeMap, startArchitecture);
        int endNode = this.getNodeNumber(nodeMap, endArchitecture);
        List nodeList = CollectionUtils.newList();
        nodeList.add(startNode);
        paths.add(nodeList);
        while (!done) {
            Set<List> addPaths = CollectionUtils.newSet();
            Set<List> removePaths = CollectionUtils.newSet();
            for (List pathNodes : paths) {
                for (int i2 = 0; i2 < nNodes; ++i2) {
                    used[i2] = false;
                }
                int lastNode = -1;
                Iterator jter = pathNodes.iterator();
                while (jter.hasNext()) {
                    int iNode = (Integer)jter.next();
                    used[iNode] = true;
                    lastNode = iNode;
                }
                TupleSet ts = vis.getGroup(EDGES);
                Iterator kter = ts.tuples();
                while (kter.hasNext()) {
                    Tuple tup = (Tuple)kter.next();
                    VisualItem edge = vis.getVisualItem(EDGES, tup);
                    Table t = edge.getTable();
                    int row = edge.getRow();
                    int iNode1 = t.getInt(row, "source");
                    int iNode2 = t.getInt(row, "target");
                    int otherNode = -1;
                    if (iNode1 == lastNode) {
                        otherNode = iNode2;
                    }
                    if (iNode2 == lastNode) {
                        otherNode = iNode1;
                    }
                    if (otherNode <= -1 || used[otherNode]) continue;
                    List newPath = CollectionUtils.newList();
                    Iterator lter = pathNodes.iterator();
                    while (lter.hasNext()) {
                        int iNode = (Integer)lter.next();
                        newPath.add(iNode);
                    }
                    newPath.add(otherNode);
                    if (otherNode == endNode) {
                        Iterator mter = newPath.iterator();
                        while (mter.hasNext()) {
                            int iNode = (Integer)mter.next();
                            nodeSelected[iNode] = true;
                        }
                        continue;
                    }
                    addPaths.add(newPath);
                }
                removePaths.add(pathNodes);
            }
            for (List pathNodes : removePaths) {
                paths.remove(pathNodes);
            }
            if (addPaths.size() == 0) {
                done = true;
                continue;
            }
            for (List pathNodes : addPaths) {
                paths.add(pathNodes);
            }
        }
        return nodeSelected;
    }

    private int getNodeNumber(Map<Integer, VisualItem> nodeMap, String architecture) {
        int nodeNumber = -1;
        for (int i = 0; i < nodeMap.size() && nodeNumber == -1; ++i) {
            VisualItem node = nodeMap.get(i);
            if (!node.getString("name").equals(architecture)) continue;
            nodeNumber = i;
        }
        return nodeNumber;
    }

    private boolean[] flagSatellites(Visualization vis, Map<Integer, VisualItem> nodeMap, boolean[] selectedNode) {
        TupleSet ts = vis.getGroup(EDGES);
        Iterator kter = ts.tuples();
        while (kter.hasNext()) {
            VisualItem node;
            Tuple tup = (Tuple)kter.next();
            VisualItem edge = vis.getVisualItem(EDGES, tup);
            Table t = edge.getTable();
            int row = edge.getRow();
            int iNode1 = t.getInt(row, "source");
            int iNode2 = t.getInt(row, "target");
            int otherNode = -1;
            if (selectedNode[iNode1]) {
                otherNode = iNode2;
            } else if (selectedNode[iNode2]) {
                otherNode = iNode1;
            }
            if (otherNode <= -1 || !(node = nodeMap.get(otherNode)).getSourceTuple().getString("name").equals(node.getSourceTuple().getString("sequences"))) continue;
            selectedNode[otherNode] = true;
        }
        return selectedNode;
    }

    private void switchEdgesOnOff(Visualization vis, Map<Integer, VisualItem> nodeMap, boolean[] selectedNode) {
        TupleSet ts = vis.getGroup(EDGES);
        Iterator kter = ts.tuples();
        while (kter.hasNext()) {
            Tuple tup = (Tuple)kter.next();
            VisualItem edge = vis.getVisualItem(EDGES, tup);
            Table t = edge.getTable();
            int row = edge.getRow();
            int iNode1 = t.getInt(row, "source");
            int iNode2 = t.getInt(row, "target");
            if (selectedNode[iNode1] && selectedNode[iNode2]) {
                edge.setVisible(true);
                continue;
            }
            edge.setVisible(false);
        }
    }
}

