/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.graph;

import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.util.force.ForceSimulator;
import prefuse.visual.EdgeItem;
import prefuse.visual.VisualItem;

public class CustomizedForceDirectedLayout
extends ForceDirectedLayout {
    public static final int DEFAULT_FORCE_FACTOR = 20;
    public static final int SEQS_FORCE_FACTOR = 40;
    public static final int STRUCS_FORCE_FACTOR = 20;
    public static final int ENZYME_FORCE_FACTOR = 50;
    public static final int MAX_FORCE_FACTOR = 100;
    private int factor = 20;
    private int nParentDomains = 1;
    private double dFactor = 1.0;

    public CustomizedForceDirectedLayout(String group, ForceSimulator fsim, boolean enforceBounds) {
        super(group, fsim, enforceBounds, false);
    }

    protected float getSpringLength(EdgeItem e) {
        float i;
        if (!e.getString("name").equals("sequence")) {
            double dist = Double.parseDouble(e.getString("name"));
            i = (int)Math.round(Math.sqrt(dist) * (double)this.factor * this.dFactor);
        } else {
            i = this.nParentDomains * this.factor / 2;
        }
        return i;
    }

    protected float getMassValue(VisualItem n) {
        return 1.0f;
    }

    protected float getSpringCoefficient(EdgeItem e) {
        return -1.0f;
    }

    public void setFactor(int factor) {
        this.factor = factor;
    }

    public void setnParentDomains(int nParentDomains) {
        this.nParentDomains = nParentDomains;
        this.dFactor = Math.sqrt(nParentDomains);
    }
}

