/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.graph;

import bbk.dng.Constants;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import prefuse.render.ShapeRenderer;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArchitectureImageRenderer
extends ShapeRenderer {
    Map<String, Integer> domainColours;
    String domainSeparator;
    private boolean useCATH = false;

    public ArchitectureImageRenderer(Map<String, Integer> domainColours, String domainSeparator, boolean useCATH) {
        this.domainColours = domainColours;
        this.domainSeparator = domainSeparator;
        this.useCATH = useCATH;
    }

    @Override
    protected Shape getRawShape(VisualItem item) {
        int aType = 1;
        if (item.getSourceTuple().getBoolean("parent")) {
            aType = 0;
        }
        String[] arches = item.getSourceTuple().getString("name").split(this.domainSeparator);
        int archCount = arches.length;
        double boxWidth = 2.0 * Constants.xMargin[aType] + Constants.recWidth[aType] * (double)archCount + Constants.gap[aType] * (double)(archCount - 1);
        double x = item.getX() - boxWidth / 2.0;
        double y = item.getY();
        double height = Constants.pfamAHeight[aType];
        String coverage = item.getSourceTuple().getString("3D_coverage");
        if (coverage != null && !coverage.equals("NONE")) {
            height += Constants.extraForCoverage[aType];
        }
        return new Rectangle((int)x, (int)(y - height / 2.0 - Constants.yMargin[aType]), (int)boxWidth, (int)(height + 2.0 * Constants.yMargin[aType]));
    }

    @Override
    public void render(Graphics2D g, VisualItem item) {
        String[] arches = item.getSourceTuple().getString("name").split(this.domainSeparator);
        int archCount = arches.length;
        int aType = 1;
        if (item.getSourceTuple().getBoolean("parent")) {
            aType = 0;
        }
        g.setPaint(Color.black);
        double boxWidth = 2.0 * Constants.xMargin[aType] + Constants.recWidth[aType] * (double)archCount + Constants.gap[aType] * (double)(archCount - 1);
        double x = item.getX() - boxWidth / 2.0;
        double y = item.getY();
        double height = Constants.pfamAHeight[aType];
        double yMid = y;
        String coverage = item.getSourceTuple().getString("3D_coverage");
        if (!coverage.equals("NONE")) {
            yMid = y - Constants.extraForCoverage[aType] / 2.0;
            height += Constants.extraForCoverage[aType];
        }
        item.setBounds(x, y - height / 2.0 - Constants.yMargin[aType], boxWidth, height + 2.0 * Constants.yMargin[aType]);
        if (aType == 0) {
            Color colour = Constants.getColourFromIntRGB(Constants.PARENT_COL[0], Constants.PARENT_COL[1], Constants.PARENT_COL[2]);
            g.setPaint(colour);
        } else {
            g.setPaint(Color.white);
        }
        g.fill(new Rectangle2D.Double(x, y - height / 2.0 - Constants.yMargin[aType], boxWidth, height + 2.0 * Constants.yMargin[aType]));
        g.setPaint(Color.black);
        g.draw(new Rectangle2D.Double(x, y - height / 2.0 - Constants.yMargin[aType], boxWidth, height + 2.0 * Constants.yMargin[aType]));
        g.draw(new Line2D.Double(x, yMid, x + boxWidth, yMid));
        for (int i = 0; i < archCount; ++i) {
            Color c = new Color(this.domainColours.get(arches[i]));
            double domHeight = Constants.pfamAHeight[aType];
            double domWidth = Constants.recWidth[aType];
            double shift = 0.0;
            if (arches[i].substring(0, 2).equals("PB")) {
                domHeight = Constants.pfamBHeight[aType];
            }
            if (this.useCATH) {
                if (arches[i].substring(0, 2).equals("PF")) {
                    domHeight = Constants.pfamAHeight[aType + 2];
                } else if (arches[i].charAt(0) == 'p') {
                    domWidth = Constants.splitCATHWidth[aType];
                    shift = (Constants.recWidth[aType] - domWidth) / 2.0;
                }
            }
            g.setPaint(c);
            g.fill(new Rectangle2D.Double(x + Constants.xMargin[aType] + shift, yMid - domHeight / 2.0, domWidth, domHeight));
            g.setPaint(Color.black);
            g.draw(new Rectangle2D.Double(x + Constants.xMargin[aType] + shift, yMid - domHeight / 2.0, domWidth, domHeight));
            if (!coverage.equals("NONE")) {
                double yPos = yMid + Constants.pfamAHeight[aType] / 2.0 + Constants.extraForCoverage[aType] / 2.0;
                double xStart = x + Constants.xMargin[aType];
                double xEnd = x + Constants.xMargin[aType] + Constants.recWidth[aType];
                int spos = 2 * i;
                if (spos < coverage.length()) {
                    char ch = coverage.charAt(spos);
                    if (ch == 'A' && i > 0 && coverage.charAt(spos - 1) == '-') {
                        xStart = x + Constants.xMargin[aType] - Constants.gap[aType];
                    }
                    if (ch == 'P') {
                        xStart = x + Constants.xMargin[aType] + Constants.recWidth[aType] / 3.0;
                        xEnd = x + Constants.xMargin[aType] + 2.0 * Constants.recWidth[aType] / 3.0;
                    }
                    if (ch != '.' && ch != 'F') {
                        Color colour = Constants.getColourFromIntRGB(Constants.SHADOW_COL[0], Constants.SHADOW_COL[1], Constants.SHADOW_COL[2]);
                        g.setPaint(colour);
                        g.fill(new Rectangle2D.Double(xStart + 1.0, yPos + 2.0, xEnd - xStart, 1.0));
                        g.fill(new Rectangle2D.Double(xEnd, yPos + 1.0, 1.0, 2.0));
                        colour = Constants.getColourFromIntRGB(Constants.COVERAGE_COL[0], Constants.COVERAGE_COL[1], Constants.COVERAGE_COL[2]);
                        g.setPaint(colour);
                        g.fill(new Rectangle2D.Double(xStart, yPos, xEnd - xStart, 2.0));
                    }
                }
            }
            x += Constants.recWidth[aType] + Constants.gap[aType];
        }
    }
}

