/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.graph;

import bbk.dng.utils.CollectionUtils;
import com.mallardsoft.tuple.Pair;
import com.mallardsoft.tuple.Tuple;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import prefuse.data.Graph;
import prefuse.data.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectureGraphBuilder {
    private int parentNodeId = 0;

    public Graph initialiseGraph(Map<String, List<String>> architectures, String parentArchitecture, Map<String, List<String>> archPDBListPair, Map<String, String> archCoveragePair, Map<String, List<String>> archEnzymeListPair, Set<Map<String, String>> archSet) {
        Graph g = new Graph();
        g.addColumn("name", String.class);
        g.addColumn("label", String.class);
        g.addColumn("type", String.class);
        g.addColumn("sequences", String.class);
        g.addColumn("parent", Boolean.TYPE);
        g.addColumn("pdb_codes", String.class);
        g.addColumn("3D_coverage", String.class);
        g.addColumn("enzymes", String.class);
        g.addColumn("nseqs", Integer.TYPE);
        g.addColumn("arch_id", Integer.TYPE);
        Table t = g.getNodeTable();
        for (String a : architectures.keySet()) {
            int nodeId = t.addRow();
            t.setString(nodeId, "name", a);
            t.setString(nodeId, "label", a);
            t.setString(nodeId, "type", "architecture");
            t.setString(nodeId, "sequences", CollectionUtils.join(architectures.get(a), ','));
            if (a.equals(parentArchitecture)) {
                t.setBoolean(nodeId, "parent", true);
                this.parentNodeId = nodeId;
            } else {
                t.setBoolean(nodeId, "parent", false);
            }
            t.setString(nodeId, "pdb_codes", CollectionUtils.join(archPDBListPair.get(a), ':'));
            t.setString(nodeId, "3D_coverage", archCoveragePair.get(a));
            if (archEnzymeListPair.get(a) != null) {
                t.setString(nodeId, "enzymes", CollectionUtils.join(archEnzymeListPair.get(a), ':'));
            }
            boolean done = false;
            Iterator<Map<String, String>> iArch = archSet.iterator();
            while (iArch.hasNext() && !done) {
                Map<String, String> archDetails = iArch.next();
                String architecture = archDetails.get("architecture");
                if (!architecture.equals(a)) continue;
                t.setString(nodeId, "arch_id", archDetails.get("arch_id"));
                t.setString(nodeId, "nseqs", archDetails.get("nseqs"));
                done = true;
            }
        }
        return g;
    }

    public Graph addEdges(Graph g, Map<Pair<String, String>, Integer> connectionsList, String parentArchitecture) {
        Table graphTable = g.getNodeTable();
        Table edgeTable = g.getEdgeTable();
        Map<String, Integer> architectureNodeId = CollectionUtils.newMap();
        for (int i = 0; i < graphTable.getRowCount(); ++i) {
            String architecture = graphTable.getString(i, "name");
            architectureNodeId.put(architecture, i);
        }
        for (Pair<String, String> nodePair : connectionsList.keySet()) {
            int row = edgeTable.addRow();
            String architecture1 = Tuple.get1(nodePair);
            String architecture2 = (String)Tuple.get2(nodePair);
            int dist = connectionsList.get(nodePair);
            Pair toConnect = Tuple.from(architectureNodeId.get(architecture1), architectureNodeId.get(architecture2));
            edgeTable.setInt(row, "source", (int)((Integer)Tuple.get1(toConnect)));
            edgeTable.setInt(row, "target", (int)((Integer)Tuple.get2(toConnect)));
            edgeTable.setString(row, "name", Integer.toString(dist));
        }
        return g;
    }

    public int getParentNodeId() {
        return this.parentNodeId;
    }
}

