/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.data.index;

import bbk.dng.utils.CollectionUtils;
import com.mallardsoft.tuple.Pair;
import com.mallardsoft.tuple.Tuple;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwissPfamSearcher {
    public static final int RUN_STATUS = 0;
    public static final int UNKNOWN = -9;
    public static final int ERROR_MESSAGE = -1;
    public static final int RUN_SUCCESSFUL = 0;
    public static final int ERR_TYPE = 1;
    public static final int ERR_MESSAGE = 2;
    public static final int RESULT_NSEQS = 1;
    public static final int RESULT_ARCHITECTURES = 2;
    public static final int RESULT_NCOLLAPSED = 3;
    public static final int RESULT_NFILTERED = 4;
    public static final int RESULT_NDOMAINS = 5;
    public static final int RESULT_NPFAM = 6;
    public static final int RESULT_NSPECIES = 7;
    public static final int RESULT_PARENT_SEQUENCE = 8;
    public static final int RESULT_HITS = 9;
    public static final int RESULT_EC_NUMBERS = 10;
    public static final int RESULT_SPECIES = 11;
    public static final int RESULT_PFAM = 12;
    public static final int RESULT_ENZYME_NAMES = 13;
    public static final int RESULT_ARCHINDEX = 14;
    public static final int RESULT_CONNECTIONS_MATRIX = 15;
    public static final int RESULT_MAX_ARCHITECTURES = 16;
    public static final int NSUMMARY_DATA = 7;
    private String remotePath;

    public SwissPfamSearcher(String remotePath) {
        this.remotePath = remotePath;
    }

    public SwissPfamSearcher() {
    }

    public Vector<Object> pfamDomainSearch(String userId, String pfamId, boolean initialSearch, Vector<Object> filterCriteria, boolean useCATH, int maxArchitectures, boolean reviewedOnly, boolean useSSG) throws Exception {
        String method = "pfamDomainSearch";
        Vector<Object> o = this.runSearch(method, userId, null, pfamId, initialSearch, filterCriteria, useCATH, maxArchitectures, reviewedOnly, useSSG);
        return o;
    }

    public Vector<Object> uniprotSequenceSearch(String userId, String seqId, String pfamId, boolean initialSearch, Vector<Object> filterCriteria, boolean useCATH, int maxArchitectures, boolean reviewedOnly, boolean useSSG) throws Exception {
        String method = "uniprotSequenceSearch";
        Vector<Object> o = this.runSearch(method, userId, seqId, pfamId, initialSearch, filterCriteria, useCATH, maxArchitectures, reviewedOnly, useSSG);
        return o;
    }

    public List<String> getPDBList(String pdbCodes) {
        List<String> pdbList = CollectionUtils.newList();
        if (pdbCodes != null && pdbCodes.length() != 0) {
            for (String code : pdbCodes.split(" ")) {
                if (code.length() > 8) {
                    code = code.substring(0, 8) + "...";
                }
                pdbList.add(code);
            }
        }
        return pdbList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<Object> callArchIndex(String request) {
        Set enzSet;
        Set archSet;
        Map speciesMap;
        Map enzymeMap;
        Map domainMap;
        Map<Pair<String, String>, Integer> connectionsList;
        Map archIndex;
        Vector<Object> v;
        String parentSeqId;
        int[] summaryData;
        int maxArch;
        BufferedReader inputStream;
        block56: {
            boolean done = false;
            boolean haveError = false;
            inputStream = null;
            InputStreamReader fileStream = null;
            int iarch = 0;
            int jarch = 0;
            int line = 0;
            maxArch = 150;
            int nArch = 0;
            int nlines = 0;
            int nEnzymes = 0;
            summaryData = new int[7];
            for (int i = 0; i < 7; ++i) {
                summaryData[i] = 0;
            }
            String nSeqs = "0";
            LineType lType = LineType.NOT_RECOGNIZED;
            String[] errorMessage = new String[2];
            String architecture = null;
            parentSeqId = null;
            v = new Vector<Object>();
            archIndex = CollectionUtils.newMap();
            connectionsList = CollectionUtils.newMap();
            domainMap = CollectionUtils.newMap();
            enzymeMap = CollectionUtils.newMap();
            speciesMap = CollectionUtils.newMap();
            archSet = CollectionUtils.newSet();
            enzSet = CollectionUtils.newSet();
            if (request.substring(0, 7).equals("http://") || request.substring(0, 8).equals("https://")) {
                try {
                    URL url = new URL(request);
                    System.out.println("REQUEST URL: " + request);
                    try {
                        fileStream = new InputStreamReader(url.openStream());
                    }
                    catch (IOException ex) {
                        System.out.println("*** ERROR. Failed to open file stream: " + url);
                        errorMessage[0] = "Connection error";
                        errorMessage[1] = "Unable to connect to EBI to perform search";
                        haveError = true;
                    }
                }
                catch (MalformedURLException ex) {
                    System.out.println("*** ERROR. Malformed URL: " + request);
                    errorMessage[0] = "URL error";
                    errorMessage[1] = "Invalid URL request: " + request;
                    haveError = true;
                }
            } else {
                try {
                    fileStream = new FileReader(request);
                }
                catch (FileNotFoundException ex) {
                    System.out.println("*** ERROR. File not found: " + request);
                    errorMessage[0] = "File error";
                    errorMessage[1] = "Unable to open file: " + request;
                    haveError = true;
                }
            }
            if (haveError) {
                v.add(-1);
                v.add(errorMessage[0]);
                v.add(errorMessage[1]);
                return v;
            }
            inputStream = new BufferedReader(fileStream);
            try {
                String inputLine;
                block29: while ((inputLine = inputStream.readLine()) != null && !done) {
                    ++nlines;
                    if (inputLine.charAt(0) == ':') {
                        lType = this.getLineType(inputLine);
                        line = 0;
                        continue;
                    }
                    ++line;
                    switch (lType) {
                        case ERROR_MESSAGE: {
                            int i = 0;
                            String[] ex = inputLine.split("\\t");
                            int n = ex.length;
                            for (int j = 0; j < n; ++j) {
                                String err;
                                errorMessage[i] = err = ex[j];
                                ++i;
                            }
                            done = true;
                            haveError = true;
                            continue block29;
                        }
                        case RUN_SUMMARY: {
                            int number = Integer.parseInt(inputLine.trim());
                            if (line == 1 && number == 0) {
                                haveError = true;
                                errorMessage[0] = "No match";
                                errorMessage[0] = "No sequences match the selection criteria!";
                                done = true;
                                continue block29;
                            }
                            if (line - 1 >= 7) continue block29;
                            summaryData[line - 1] = number;
                            continue block29;
                        }
                        case PARENT_SEQUENCE: {
                            int i = 0;
                            for (String field2 : inputLine.split("\\t")) {
                                if (i == 1) {
                                    parentSeqId = field2;
                                }
                                ++i;
                            }
                            continue block29;
                        }
                        case ARCHITECTURE_RECORD: {
                            String[] afield = new String[3];
                            int i = 0;
                            String[] stringArray = inputLine.split("\\t");
                            int err = stringArray.length;
                            for (int field2 = 0; field2 < err; ++field2) {
                                String f;
                                afield[i] = f = stringArray[field2];
                                ++i;
                            }
                            architecture = afield[0];
                            nSeqs = afield[1];
                            Map archdata = CollectionUtils.mapOf("id", nArch, "architecture", architecture, "nseqs", nSeqs, "dist", afield[2]);
                            archIndex.put(nArch, archdata);
                            ++nArch;
                            lType = LineType.HIT_RECORD;
                            continue block29;
                        }
                        case HIT_RECORD: {
                            String[] field = new String[7];
                            int i = 0;
                            String[] field2 = inputLine.split("\\t");
                            int f = field2.length;
                            for (int j = 0; j < f; ++j) {
                                String f2;
                                field[i] = f2 = field2[j];
                                ++i;
                            }
                            int ipos = field[1].indexOf(95);
                            String speciesId = field[1].substring(ipos + 1);
                            String nArchString = "" + nArch;
                            String nSeqsString = "" + nSeqs;
                            Map hit = CollectionUtils.mapOf("uniprot_acc", field[0], "uniprot_id", field[1], "architecture", architecture, "species_id", speciesId, "protein_name", field[2], "seq_len", field[3], "pdb_codes", field[4], "3D_coverage", field[5], "arch_id", nArchString, "nseqs", nSeqsString);
                            archSet.add(hit);
                            continue block29;
                        }
                        case EC_RECORD: {
                            String[] efield = new String[3];
                            int i = 0;
                            String[] stringArray = inputLine.split("\\t");
                            int n = stringArray.length;
                            for (int j = 0; j < n; ++j) {
                                String f;
                                efield[i] = f = stringArray[j];
                                ++i;
                            }
                            Map ecNo = CollectionUtils.mapOf("id", efield[0], "nseqs", efield[1], "architecture", architecture);
                            enzSet.add(ecNo);
                            continue block29;
                        }
                        case SPECIES_RECORD: {
                            String[] sfield = new String[3];
                            int i = 0;
                            String[] stringArray = inputLine.split("\\t");
                            int f = stringArray.length;
                            for (int j = 0; j < f; ++j) {
                                String f3;
                                sfield[i] = f3 = stringArray[j];
                                ++i;
                            }
                            Map species = CollectionUtils.mapOf("id", sfield[0], "organism", sfield[1], "nseqs", sfield[2]);
                            speciesMap.put(sfield[0], species);
                            continue block29;
                        }
                        case PFAM_RECORD: {
                            String[] pfield = new String[4];
                            int i = 0;
                            String[] stringArray = inputLine.split("\\t");
                            int f3 = stringArray.length;
                            for (int j = 0; j < f3; ++j) {
                                String f;
                                pfield[i] = f = stringArray[j];
                                ++i;
                            }
                            Map pfam = CollectionUtils.mapOf("id", pfield[0], "description", pfield[1], "short_name", pfield[2], "nseqs", pfield[3]);
                            domainMap.put(pfield[0], pfam);
                            continue block29;
                        }
                        case EC_NAME_RECORD: {
                            String[] nfield = new String[5];
                            int i = 0;
                            String[] stringArray = inputLine.split("\\t");
                            int f = stringArray.length;
                            for (int j = 0; j < f; ++j) {
                                String f4;
                                nfield[i] = f4 = stringArray[j];
                                ++i;
                            }
                            Map enzyme = CollectionUtils.mapOf("id", nfield[0], "description", nfield[1], "narch", nfield[2], "nseqs", nfield[3]);
                            enzymeMap.put(nEnzymes, enzyme);
                            ++nEnzymes;
                            continue block29;
                        }
                        case CONNECTIONS_RECORD: {
                            if (line == 1) {
                                iarch = 0;
                                jarch = 1;
                            }
                            String[] cfield = new String[3];
                            int i = 0;
                            String[] stringArray = inputLine.split("\\t");
                            int f4 = stringArray.length;
                            for (int j = 0; j < f4; ++j) {
                                String f;
                                cfield[i] = f = stringArray[j];
                                ++i;
                            }
                            iarch = Integer.parseInt(cfield[0]);
                            jarch = Integer.parseInt(cfield[1]);
                            int dist = Integer.parseInt(cfield[2]);
                            String architecture1 = (String)((Map)archIndex.get(iarch)).get("architecture");
                            String architecture2 = (String)((Map)archIndex.get(jarch)).get("architecture");
                            Pair<String, String> edge = Tuple.from(architecture1, architecture2);
                            connectionsList.put(edge, dist);
                            continue block29;
                        }
                        case MAX_ARCH_RECORD: {
                            maxArch = Integer.parseInt(inputLine.trim());
                            continue block29;
                        }
                    }
                }
            }
            catch (IOException ex) {
                System.out.println("*** ERROR. File read error: " + request);
                Vector<Object> vector = null;
                Object var52_92 = null;
                if (haveError) {
                    v.add(-1);
                    v.add(errorMessage[0]);
                    v.add(errorMessage[1]);
                    return v;
                }
                v.add(0);
                for (int i = 0; i < 7; ++i) {
                    v.add(summaryData[i]);
                }
                v.add(parentSeqId);
                v.add(archSet);
                v.add(enzSet);
                v.add(speciesMap);
                v.add(domainMap);
                v.add(enzymeMap);
                v.add(archIndex);
                v.add(connectionsList);
                v.add(maxArch);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex2) {
                        System.out.println("*** ERROR. Unable to close input stream");
                    }
                }
                return vector;
            }
            try {
                Object var52_93 = null;
                if (!haveError) break block56;
                v.add(-1);
            }
            catch (Throwable throwable) {
                Object var52_94 = null;
                if (haveError) {
                    v.add(-1);
                    v.add(errorMessage[0]);
                    v.add(errorMessage[1]);
                    return v;
                }
                v.add(0);
                for (int i = 0; i < 7; ++i) {
                    v.add(summaryData[i]);
                }
                v.add(parentSeqId);
                v.add(archSet);
                v.add(enzSet);
                v.add(speciesMap);
                v.add(domainMap);
                v.add(enzymeMap);
                v.add(archIndex);
                v.add(connectionsList);
                v.add(maxArch);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex2) {
                        System.out.println("*** ERROR. Unable to close input stream");
                    }
                }
                throw throwable;
            }
            v.add(errorMessage[0]);
            v.add(errorMessage[1]);
            return v;
        }
        v.add(0);
        for (int i = 0; i < 7; ++i) {
            v.add(summaryData[i]);
        }
        v.add(parentSeqId);
        v.add(archSet);
        v.add(enzSet);
        v.add(speciesMap);
        v.add(domainMap);
        v.add(enzymeMap);
        v.add(archIndex);
        v.add(connectionsList);
        v.add(maxArch);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException ex2) {
                System.out.println("*** ERROR. Unable to close input stream");
            }
        }
        return v;
    }

    private LineType getLineType(String inputLine) {
        LineType lType = LineType.NOT_RECOGNIZED;
        if (inputLine.substring(1).equals("ERROR")) {
            lType = LineType.ERROR_MESSAGE;
        } else if (inputLine.substring(1).equals("SUMMARY")) {
            lType = LineType.RUN_SUMMARY;
        } else if (inputLine.substring(1).equals("PARENT")) {
            lType = LineType.PARENT_SEQUENCE;
        } else if (inputLine.substring(1).equals("HITS")) {
            lType = LineType.HIT_RECORD;
        } else if (inputLine.substring(1).equals("A")) {
            lType = LineType.ARCHITECTURE_RECORD;
        } else if (inputLine.substring(1).equals("E")) {
            lType = LineType.EC_RECORD;
        } else if (inputLine.substring(1).equals("PFAM")) {
            lType = LineType.PFAM_RECORD;
        } else if (inputLine.substring(1).equals("EC_NAME")) {
            lType = LineType.EC_NAME_RECORD;
        } else if (inputLine.substring(1).equals("SPECIES")) {
            lType = LineType.SPECIES_RECORD;
        } else if (inputLine.substring(1).equals("CONNECTIONS")) {
            lType = LineType.CONNECTIONS_RECORD;
        } else if (inputLine.substring(1).equals("MAX_ARCH")) {
            lType = LineType.MAX_ARCH_RECORD;
        }
        return lType;
    }

    private Vector<Object> runSearch(String method, String userId, String seqId, String pfamId, boolean initialSearch, Vector<Object> filterCriteria, boolean useCATH, int maxArchitectures, boolean reviewedOnly, boolean useSSG) throws Exception {
        boolean pdbOnly = false;
        List domainList = CollectionUtils.newList();
        String pfamDomainOperator = "OR";
        String organism = "ALL";
        char splitChar = '.';
        if (useCATH) {
            splitChar = '_';
        }
        if (filterCriteria != null) {
            pfamDomainOperator = (String)filterCriteria.get(0);
            domainList = (List)filterCriteria.get(1);
            organism = (String)filterCriteria.get(2);
            pdbOnly = (Boolean)filterCriteria.get(3);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.remotePath);
        if (this.remotePath.substring(0, 7).equals("http://") || this.remotePath.substring(0, 8).equals("https://")) {
            if (userId != null) {
                sb.append("userId=" + userId + "&");
            }
            if (seqId != null) {
                sb.append("seqId=" + seqId + "&");
            }
            if (pfamId != null) {
                sb.append("pfamId=" + pfamId + "&");
            }
            if (domainList != null && !domainList.isEmpty()) {
                sb.append("domains=").append(CollectionUtils.join(domainList, splitChar)).append("&");
            }
            if (filterCriteria != null) {
                sb.append("domainOperator=").append(pfamDomainOperator).append("&");
                sb.append("organism=").append(URLEncoder.encode(organism, "UTF-8")).append("&");
                sb.append("pdbOnly=").append(pdbOnly);
            }
            if (useCATH) {
                sb.append("&cath=TRUE");
            }
            if (useSSG) {
                sb.append("&ssg=TRUE");
            }
            if (reviewedOnly) {
                sb.append("&rev=TRUE");
            }
            if (maxArchitectures > 0) {
                sb.append("&maxa=" + maxArchitectures);
            }
        }
        Vector<Object> v = this.callArchIndex(sb.toString());
        return v;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineType {
        ERROR_MESSAGE,
        RUN_SUMMARY,
        PARENT_SEQUENCE,
        ARCHITECTURE_RECORD,
        HIT_RECORD,
        EC_RECORD,
        EC_NAME_RECORD,
        PFAM_RECORD,
        SPECIES_RECORD,
        CONNECTIONS_RECORD,
        MAX_ARCH_RECORD,
        NOT_RECOGNIZED;

    }
}

