/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.actions;

import bbk.dng.Constants;
import bbk.dng.actions.PostScript;
import bbk.dng.actions.Scale;
import bbk.dng.actions.SearchPanelActions;
import bbk.dng.graph.GraphPanel;
import bbk.dng.ui.panels.AppFrame;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import prefuse.Visualization;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WritePSFile {
    private static final int X = 0;
    private static final int Y = 1;
    private boolean ok = true;

    public WritePSFile(String fileName, AppFrame appFrame, boolean useCATH, boolean landscape) throws IOException {
        Color bgColour = Color.white;
        int page = 0;
        int npages = 1;
        float[] offset = new float[2];
        PrintStream out = null;
        PostScript psFile = null;
        String domainSeparator = !useCATH ? "\\." : "\\_";
        Visualization vis = appFrame.getGraphPanel().getVisualization();
        Rectangle2D bounds = vis.getBounds("graph");
        Scale scale = new Scale(this, bounds, landscape, 20.0f);
        float scaleFactor = scale.getScaleFactor();
        for (int i = 0; i < 2; ++i) {
            offset[i] = scale.getOffset(i);
        }
        try {
            out = new PrintStream(fileName);
            Date today = new Date();
            psFile = new PostScript(out);
            String title = "PostScript output";
            psFile.writeMainHeaders(title, "ArchSchema", "1.1", today.toString(), npages);
            psFile.writePageHeaders(++page, npages, bgColour);
            if (landscape) {
                psFile.writeLandscape();
            }
            Map<Integer, VisualItem> nodeMap = appFrame.getGraphPanel().getGraphNodesMap(vis);
            this.plotGraphEdges(psFile, vis, scale, nodeMap);
            this.plotGraphNodes(psFile, vis, scale, 1, useCATH, domainSeparator);
            this.plotGraphNodes(psFile, vis, scale, 0, useCATH, domainSeparator);
            Object var20_21 = null;
            if (out != null) {
                this.ok = true;
                psFile.writeEndPage();
                psFile.writeClosingLines();
                out.close();
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            if (out != null) {
                this.ok = true;
                psFile.writeEndPage();
                psFile.writeClosingLines();
                out.close();
            }
            throw throwable;
        }
    }

    public boolean getOK() {
        return this.ok;
    }

    private void plotGraphEdges(PostScript psFile, Visualization vis, Scale scale, Map<Integer, VisualItem> nodeMap) {
        Color colour = Color.BLACK;
        psFile.psComment("GRAPH EDGES");
        float plotWidth = scale.getScaleFactor() * 1.0f;
        TupleSet ts = vis.getGroup("graph.edges");
        Iterator iter = ts.tuples();
        while (iter.hasNext()) {
            Tuple tup = (Tuple)iter.next();
            VisualItem edge = vis.getVisualItem("graph.edges", tup);
            Table t = edge.getTable();
            int row = edge.getRow();
            VisualItem node1 = nodeMap.get(t.getInt(row, "source"));
            VisualItem node2 = nodeMap.get(t.getInt(row, "target"));
            if (!node1.isVisible() || !node2.isVisible()) continue;
            float[] coords1 = new float[2];
            float[] coords2 = new float[2];
            coords1[0] = (float)node1.getX();
            coords1[1] = (float)node1.getY();
            coords2[0] = (float)node2.getX();
            coords2[1] = (float)node2.getY();
            float[] psCoords1 = this.calcPlotCoords(scale, coords1);
            float[] psCoords2 = this.calcPlotCoords(scale, coords2);
            psFile.psDrawLine(psCoords1[0], psCoords1[1], psCoords2[0], psCoords2[1], plotWidth, colour);
        }
    }

    public float[] calcPlotCoords(Scale scale, float[] coords) {
        float[] psCoords = new float[]{scale.getScaleFactor() * (scale.getOffset(0) + coords[0]), scale.getScaleFactor() * (scale.getOffset(1) + coords[1])};
        psCoords[1] = (float)scale.getPlotHeight() - psCoords[1];
        return psCoords;
    }

    private void plotGraphNodes(PostScript psFile, Visualization vis, Scale scale, int plotNodeType, boolean useCATH, String domainSeparator) {
        Color colour = Color.BLACK;
        float textSize = scale.getScaleFactor() * 10.0f;
        int nVisible = 0;
        int nInVisible = 0;
        psFile.psComment("GRAPH NODES: " + GraphPanel.NODE_DESC[plotNodeType] + " nodes");
        float lineWidth = scale.getScaleFactor() * 1.5f;
        TupleSet ts = vis.getGroup("graph.nodes");
        Iterator iter = ts.tuples();
        while (iter.hasNext()) {
            Tuple tup = (Tuple)iter.next();
            VisualItem node = vis.getVisualItem("graph.nodes", tup);
            boolean parent = false;
            double x = node.getX();
            double y = node.getY();
            double width = node.getBounds().getWidth();
            double height = node.getBounds().getHeight();
            int nodeType = 0;
            int aType = 1;
            if (!node.getSourceTuple().getString("name").equals(node.getSourceTuple().getString("sequences"))) {
                nodeType = 0;
                if (node.getSourceTuple().getBoolean("parent")) {
                    aType = 0;
                    parent = true;
                }
            } else {
                nodeType = 1;
            }
            if (!node.isVisible()) {
                ++nInVisible;
                System.out.println("Invisible node: " + node.getSourceTuple().getString("name"));
            } else {
                ++nVisible;
            }
            if (nodeType != plotNodeType || !node.isVisible()) continue;
            float[] coords1 = new float[2];
            float[] coords2 = new float[2];
            coords1[0] = (float)(x - width / 2.0);
            coords1[1] = (float)(y - height / 2.0);
            coords2[0] = (float)(x + width / 2.0);
            coords2[1] = (float)(y + height / 2.0);
            int fillColour = node.getFillColor();
            Color fColour = ColorLib.getColor(fillColour);
            if (nodeType == 0) {
                fColour = Color.white;
                if (aType == 0) {
                    fColour = Constants.getColourFromIntRGB(Constants.PARENT_COL[0], Constants.PARENT_COL[1], Constants.PARENT_COL[2]);
                }
            }
            float[] psCoords1 = this.calcPlotCoords(scale, coords1);
            float[] psCoords2 = this.calcPlotCoords(scale, coords2);
            psFile.psUnboundedBox(psCoords1[0], psCoords1[1], psCoords1[0], psCoords2[1], psCoords2[0], psCoords2[1], psCoords2[0], psCoords1[1], fColour);
            psFile.psDrawLine(psCoords1[0], psCoords1[1], psCoords1[0], psCoords2[1], lineWidth, colour);
            psFile.psDrawLine(psCoords1[0], psCoords2[1], psCoords2[0], psCoords2[1], lineWidth, colour);
            psFile.psDrawLine(psCoords2[0], psCoords2[1], psCoords2[0], psCoords1[1], lineWidth, colour);
            psFile.psDrawLine(psCoords2[0], psCoords1[1], psCoords1[0], psCoords1[1], lineWidth, colour);
            if (nodeType == 1) {
                coords1[0] = (float)x;
                coords1[1] = (float)y;
                psCoords1 = this.calcPlotCoords(scale, coords1);
                psFile.psCentredText(psCoords1[0], psCoords1[1], textSize, Color.black, node.getSourceTuple().getString("name"));
                continue;
            }
            this.plotDomains(psFile, scale, node, parent, aType, psCoords1, psCoords2, useCATH, domainSeparator);
        }
        System.out.println("Number of visible nodes    = " + nVisible);
        System.out.println("Number of invisible nodes  = " + nInVisible);
        System.out.println("TOTAL                      = " + (nVisible + nInVisible));
    }

    private void plotDomains(PostScript psFile, Scale scale, VisualItem node, boolean parent, int aType, float[] psCorner1, float[] psCorner2, boolean useCATH, String domainSeparator) {
        Color colour = Color.BLACK;
        float[] coords1 = new float[2];
        float[] coords2 = new float[2];
        Map<String, Integer> domainColour = SearchPanelActions.getInstance().getDomainColour();
        Color coverageColour = Constants.getColourFromIntRGB(Constants.COVERAGE_COL[0], Constants.COVERAGE_COL[1], Constants.COVERAGE_COL[2]);
        Color shadeColour = Constants.getColourFromIntRGB(Constants.SHADOW_COL[0], Constants.SHADOW_COL[1], Constants.SHADOW_COL[2]);
        float psX = (psCorner1[0] + psCorner2[0]) / 2.0f;
        float psY = (psCorner1[1] + psCorner2[1]) / 2.0f;
        float lineWidth = scale.getScaleFactor() * 1.5f;
        float psWidth = psCorner2[0] - psCorner1[0];
        float psHeight = psCorner2[1] - psCorner1[1];
        String[] arches = node.getSourceTuple().getString("name").split(domainSeparator);
        int archCount = arches.length;
        coords1[0] = (float)(node.getX() - node.getBounds().getWidth() / 2.0);
        coords1[1] = (float)node.getY();
        String coverage = node.getSourceTuple().getString("3D_coverage");
        if (!coverage.equals("NONE")) {
            coords1[1] = (float)((double)coords1[1] - Constants.extraForCoverage[aType] / 2.0);
        }
        float[] psCoords1 = this.calcPlotCoords(scale, coords1);
        psFile.psDrawLine(psCorner1[0], psCoords1[1], psCorner2[0], psCoords1[1], lineWidth, colour);
        float x = coords1[0];
        float y = coords1[1];
        for (int i = 0; i < archCount; ++i) {
            Color domCol = new Color(domainColour.get(arches[i]));
            double domHeight = Constants.pfamAHeight[aType];
            double domWidth = Constants.recWidth[aType];
            double shift = 0.0;
            if (arches[i].substring(0, 2).equals("PB")) {
                domHeight = Constants.pfamBHeight[aType];
            }
            if (useCATH) {
                if (arches[i].substring(0, 2).equals("PF")) {
                    domHeight = Constants.pfamAHeight[aType + 2];
                } else if (arches[i].charAt(0) == 'p') {
                    domWidth = Constants.splitCATHWidth[aType];
                    shift = (Constants.recWidth[aType] - domWidth) / 2.0;
                }
            }
            coords1[0] = (float)((double)x + Constants.xMargin[aType] + shift);
            coords1[1] = (float)((double)y - domHeight / 2.0);
            coords2[0] = (float)((double)coords1[0] + domWidth);
            coords2[1] = (float)((double)coords1[1] + domHeight);
            psCoords1 = this.calcPlotCoords(scale, coords1);
            float[] psCoords2 = this.calcPlotCoords(scale, coords2);
            psFile.psUnboundedBox(psCoords1[0], psCoords1[1], psCoords1[0], psCoords2[1], psCoords2[0], psCoords2[1], psCoords2[0], psCoords1[1], domCol);
            psFile.psDrawLine(psCoords1[0], psCoords1[1], psCoords1[0], psCoords2[1], lineWidth, colour);
            psFile.psDrawLine(psCoords1[0], psCoords2[1], psCoords2[0], psCoords2[1], lineWidth, colour);
            psFile.psDrawLine(psCoords2[0], psCoords2[1], psCoords2[0], psCoords1[1], lineWidth, colour);
            psFile.psDrawLine(psCoords2[0], psCoords1[1], psCoords1[0], psCoords1[1], lineWidth, colour);
            if (!coverage.equals("NONE")) {
                double yPos = (double)y + Constants.pfamAHeight[aType] / 2.0 + Constants.extraForCoverage[aType] / 2.0;
                double xStart = (double)x + Constants.xMargin[aType];
                double xEnd = (double)x + Constants.xMargin[aType] + Constants.recWidth[aType];
                int spos = 2 * i;
                if (spos < coverage.length()) {
                    char ch = coverage.charAt(spos);
                    if (ch == 'A' && i > 0 && coverage.charAt(spos - 1) == '-') {
                        xStart = (double)x + Constants.xMargin[aType] - Constants.gap[aType];
                    }
                    if (ch == 'P') {
                        xStart = (double)x + Constants.xMargin[aType] + Constants.recWidth[aType] / 3.0;
                        xEnd = (double)x + Constants.xMargin[aType] + 2.0 * Constants.recWidth[aType] / 3.0;
                    }
                    if (ch != '.' && ch != 'F') {
                        coords1[0] = (float)(xStart + 1.0);
                        coords1[1] = (float)(yPos + 1.0);
                        coords2[0] = (float)(xEnd + 1.0);
                        coords2[1] = (float)(yPos + 3.0);
                        psCoords1 = this.calcPlotCoords(scale, coords1);
                        psCoords2 = this.calcPlotCoords(scale, coords2);
                        psFile.psUnboundedBox(psCoords1[0], psCoords1[1], psCoords1[0], psCoords2[1], psCoords2[0], psCoords2[1], psCoords2[0], psCoords1[1], shadeColour);
                        coords1[0] = (float)xStart;
                        coords1[1] = (float)yPos;
                        coords2[0] = (float)xEnd;
                        coords2[1] = (float)(yPos + 2.0);
                        psCoords1 = this.calcPlotCoords(scale, coords1);
                        psCoords2 = this.calcPlotCoords(scale, coords2);
                        psFile.psUnboundedBox(psCoords1[0], psCoords1[1], psCoords1[0], psCoords2[1], psCoords2[0], psCoords2[1], psCoords2[0], psCoords1[1], coverageColour);
                    }
                }
            }
            x = (float)((double)x + (Constants.recWidth[aType] + Constants.gap[aType]));
        }
    }
}

