/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.actions;

import bbk.dng.Constants;
import bbk.dng.Main;
import bbk.dng.actions.GraphStylePanelActions;
import bbk.dng.actions.WritePSFile;
import bbk.dng.data.index.SwissPfamSearcher;
import bbk.dng.graph.ArchitectureGraphBuilder;
import bbk.dng.graph.CustomizedForceDirectedLayout;
import bbk.dng.graph.RenderingCountdown;
import bbk.dng.ui.panels.AppFrame;
import bbk.dng.utils.CollectionUtils;
import bbk.dng.utils.NameValue;
import bbk.dng.utils.SwingUtils;
import com.mallardsoft.tuple.Pair;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import prefuse.Visualization;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPanelActions {
    public static final int PFAM = 0;
    public static final int CATH = 1;
    private static SearchPanelActions instance;
    private int domainType;
    private boolean useCATH;
    private boolean useSSG;
    private boolean offLine;
    private boolean addEnzymes;
    private String domainSeparator = "\\.";
    private String parentArchitecture;
    private String parentSequence = null;
    private String parentName = null;
    private int nParentDomains = 0;
    private String parentPDBCodes;
    private String parentCoverage;
    private String masterText;
    private String enzymesText;
    private Map<String, List<String>> archSeqListPair = null;
    private Map<String, List<String>> archPDBListPair = null;
    private Map<String, List<String>> archEnzymeListPair = null;
    private Map<String, String> archCoveragePair = null;
    private Map<Integer, Map<String, String>> archIndex = null;
    private Map<Pair<String, String>, Integer> connectionsList = null;
    private Set<Map<String, String>> architectures = null;
    private Set<Map<String, String>> enzSet = null;
    public static URL imgURL;
    Map<String, Integer> domainColour = null;
    private static boolean newSearch;
    public static Vector seqSearchResults;
    public static String[] domainCatDesc;
    public static final String[] specialOrganisms;
    public static final String[] domainTypeDesc;
    public static final String[] pfamCatDesc;
    public static final String[] cathCatDesc;
    public static final String[] enzymeClass;

    private SearchPanelActions() {
    }

    public static SearchPanelActions getInstance() {
        return instance == null ? (instance = new SearchPanelActions()) : instance;
    }

    public boolean sequenceSearchAction(AppFrame appFrame, SwissPfamSearcher searcher, String seqId, String pfamId, boolean newSearch, String userId, boolean useCATH, boolean useSSG, boolean offLine, boolean addEnzymes) throws Exception {
        String proteinName;
        boolean nDomains = false;
        seqSearchResults = null;
        this.useCATH = useCATH;
        this.useSSG = useSSG;
        this.offLine = offLine;
        this.addEnzymes = addEnzymes;
        if (seqId == null && pfamId == null && ((seqId = appFrame.getInputPanel().getSequenceTextField().getText().toUpperCase()) == null || seqId.length() == 0)) {
            pfamId = appFrame.getInputPanel().getPfamIdTextField().getText().toUpperCase();
        }
        int maxArchitectures = appFrame.getInputPanel().getMaxArchitectures();
        boolean reviewedOnly = appFrame.getInputPanel().getReviewedUniProtOnlyRadioButton().isSelected();
        if (seqId != null) {
            appFrame.getInputPanel().getSequenceTextField().setText(seqId);
        }
        if (pfamId != null) {
            appFrame.getInputPanel().getPfamIdTextField().setText(pfamId);
        }
        if (!(seqId != null && seqId.length() != 0 || pfamId != null && pfamId.length() != 0)) {
            return false;
        }
        Vector<Object> filterCriteria = new Vector();
        filterCriteria = null;
        if (!newSearch && appFrame.getGraphCriteriaPanel().isVisible()) {
            filterCriteria = this.getUserFilterCriteria(appFrame);
        }
        appFrame.setCursor(Cursor.getPredefinedCursor(3));
        String searchMade = "NONE";
        if (pfamId != null && pfamId.length() > 0) {
            seqSearchResults = searcher.pfamDomainSearch(userId, pfamId, true, filterCriteria, useCATH, maxArchitectures, reviewedOnly, useSSG);
            searchMade = "Pfam";
        } else {
            seqSearchResults = searcher.uniprotSequenceSearch(userId, seqId, null, true, filterCriteria, useCATH, maxArchitectures, reviewedOnly, useSSG);
            searchMade = "UniProt";
        }
        appFrame.setCursor(Cursor.getPredefinedCursor(0));
        if (seqSearchResults == null) {
            JOptionPane.showMessageDialog(appFrame, "<html>No sequences match the selection criteria!", "No match", 0);
            return false;
        }
        if (this.getRunStatus() == -1) {
            String errorType = this.getErrorType();
            String errorMessage = this.getErrorMessage();
            JOptionPane.showMessageDialog(appFrame, "<html>" + errorMessage, errorType, 0);
            return false;
        }
        int nSequences = this.getNSequences();
        int nUniqueArchitectures = this.getNArch();
        int nFinal = this.getNFinal();
        int nSpecies = this.getNSpecies();
        appFrame.setCursor(Cursor.getPredefinedCursor(3));
        this.parentSequence = this.getParentSequence();
        this.architectures = this.getArchitectures();
        Map<String, String> parentMap = null;
        for (Map<String, String> map : this.architectures) {
            if (!map.get("uniprot_id").equals(this.parentSequence)) continue;
            parentMap = map;
        }
        if (parentMap == null) {
            JOptionPane.showMessageDialog(appFrame, "<html>Search sequence not found in hits!", "Search sequence lost", 0);
            return false;
        }
        this.parentArchitecture = (String)parentMap.get("architecture");
        if (!useCATH) {
            this.domainType = 0;
            this.domainSeparator = "\\.";
            SearchPanelActions.domainCatDesc[0] = pfamCatDesc[0];
            SearchPanelActions.domainCatDesc[1] = pfamCatDesc[1];
        } else {
            this.domainType = 1;
            this.domainSeparator = "\\_";
            SearchPanelActions.domainCatDesc[0] = cathCatDesc[0];
            SearchPanelActions.domainCatDesc[1] = cathCatDesc[1];
        }
        String[] nodeDomains = this.parentArchitecture.split(this.domainSeparator);
        this.nParentDomains = nodeDomains.length;
        if (this.nParentDomains == 0) {
            this.nParentDomains = 1;
        }
        this.enzSet = this.getEnzymes();
        if (!appFrame.getGraphCriteriaPanel().isVisible()) {
            appFrame.getGraphCriteriaPanel().setVisible(true);
        }
        this.parentName = proteinName = parentMap.get("protein_name");
        appFrame.getGraphCriteriaPanel().getSequenceInfoLabel().setText("<html>" + parentMap.get("uniprot_id") + "<br>" + proteinName + "</html>");
        List<String> domains = this.getDomainList(parentMap.get("architecture"));
        DefaultListModel model = (DefaultListModel)appFrame.getGraphCriteriaPanel().getDomainList().getModel();
        model.clear();
        Map<String, Map<String, String>> domainDetails = this.getDomainDetails();
        Map<String, Map<String, String>> speciesDetails = this.getSpeciesDetails();
        this.archIndex = this.getArchIndex();
        this.connectionsList = this.getConnectionsList();
        maxArchitectures = this.getmaxArchitectures();
        appFrame.getInputPanel().setMaxArchitectures(maxArchitectures);
        for (String string : domains) {
            String pfId = domainDetails.get(string).get("id");
            String description = domainDetails.get(string).get("description");
            int nSeqs = Integer.parseInt(domainDetails.get(string).get("nseqs"));
            String endString = "seqs]";
            if (nSeqs == 1) {
                endString = "seq]";
            }
            model.add(model.size(), new NameValue(pfId + " " + description + " [" + nSeqs + endString, string));
        }
        appFrame.getGraphCriteriaPanel().getDomainList().setSelectionInterval(0, model.size() - 1);
        appFrame.getGraphCriteriaPanel().getOrganismComboBox().addItem(new NameValue("ALL", "ALL"));
        Set<String> extensions = speciesDetails.keySet();
        for (String special : specialOrganisms) {
            Map<String, String> speciesEntry = speciesDetails.get(special);
            if (speciesEntry == null) continue;
            int nSeqs = Integer.parseInt(speciesEntry.get("nseqs"));
            String endString = "seqs]";
            if (nSeqs == 1) {
                endString = "seq]";
            }
            String sp = speciesEntry.get("organism") + " [" + nSeqs + endString;
            appFrame.getGraphCriteriaPanel().getOrganismComboBox().addItem(new NameValue(sp, special));
            extensions.remove(special);
        }
        appFrame.getGraphCriteriaPanel().getOrganismComboBox().addItem(new NameValue("------------------------------", "ALL"));
        List<String> list = CollectionUtils.newList();
        for (String e : extensions) {
            Map<String, String> speciesEntry = speciesDetails.get(e);
            list.add(speciesEntry.get("organism") + "\t" + e);
        }
        Collections.sort(list);
        for (String org : list) {
            String[] namePlusExtension = org.split("\\t");
            String name = namePlusExtension[0];
            String extension = namePlusExtension[1];
            if (name.length() > 30) {
                name = name.substring(0, 30) + "...";
            }
            Map<String, String> speciesEntry = speciesDetails.get(extension);
            int nSeqs = 0;
            if (speciesEntry != null) {
                nSeqs = Integer.parseInt(speciesEntry.get("nseqs"));
            }
            if (nSeqs == 1) {
                name = name + " [" + nSeqs + "seq]";
            } else if (nSeqs > 1) {
                name = name + " [" + nSeqs + "seqs]";
            }
            NameValue nameValue = new NameValue(name, extension);
            appFrame.getGraphCriteriaPanel().getOrganismComboBox().addItem(nameValue);
        }
        appFrame.getGraphCriteriaPanel().getDrawGraphButton().setEnabled(true);
        appFrame.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public void drawGraphAction(AppFrame appFrame, SwissPfamSearcher searcher) throws Exception {
        appFrame.setCursor(Cursor.getPredefinedCursor(3));
        int nSeqs = this.getNSequences();
        int nArch = this.getNArch();
        int nFinal = this.getNFinal();
        int nCollapsed = this.getNCollapsed();
        int nPfam = this.getNPfam();
        int nSpecies = this.getNSpecies();
        appFrame.getSplitPane2().setOneTouchExpandable(true);
        appFrame.getSplitPane2().getTopComponent().setVisible(true);
        appFrame.getSplitPane2().setDividerLocation(500);
        this.getArchitectureMappings(this.architectures);
        this.getEnzymeMappings(this.enzSet);
        this.archSeqListPair = this.replaceParents(this.archSeqListPair, searcher);
        ArchitectureGraphBuilder graphBuilder = new ArchitectureGraphBuilder();
        Main.graph = graphBuilder.initialiseGraph(this.archSeqListPair, this.parentArchitecture, this.archPDBListPair, this.archCoveragePair, this.archEnzymeListPair, this.architectures);
        graphBuilder.addEdges(Main.graph, this.connectionsList, this.parentArchitecture);
        this.domainColour = CollectionUtils.newMap();
        Set<String> allDistinctDomains = CollectionUtils.newSet();
        Collections.addAll(allDistinctDomains, this.parentArchitecture.split(this.domainSeparator));
        for (String arch : this.archSeqListPair.keySet()) {
            Collections.addAll(allDistinctDomains, arch.split(this.domainSeparator));
        }
        Set<String> distinctPfamADomains = CollectionUtils.newSet();
        Set<String> distinctPfamBDomains = CollectionUtils.newSet();
        for (String domain : allDistinctDomains) {
            if (domain.substring(0, 2).equals("PF") || domain.charAt(0) != 'P' && domain.charAt(0) != 'p') {
                distinctPfamADomains.add(domain);
                continue;
            }
            distinctPfamBDomains.add(domain);
        }
        int colourIndex = 0;
        int[] colourTableA = new int[distinctPfamADomains.size()];
        int[] colorsA = ColorLib.getCategoryPalette(distinctPfamADomains.size(), 1.0f, 0.2f, 1.0f, 1.0f);
        int startColour = 0;
        colourTableA = this.copyToColourTable(colourTableA, colorsA, startColour);
        String[] domains = this.parentArchitecture.split(this.domainSeparator);
        for (String domain : domains) {
            if (!domain.substring(0, 2).equals("PF") && (domain.charAt(0) == 'P' || domain.charAt(0) == 'p') || this.domainColour.get(domain) != null) continue;
            this.domainColour.put(domain, colourTableA[colourIndex]);
            ++colourIndex;
        }
        for (String domain : distinctPfamADomains) {
            if (this.domainColour.get(domain) != null) continue;
            this.domainColour.put(domain, colourTableA[colourIndex]);
            ++colourIndex;
        }
        colourIndex = 0;
        int[] colourTableB = new int[distinctPfamBDomains.size()];
        int[] colorsB = ColorLib.getCategoryPalette(distinctPfamBDomains.size(), 1.0f, 0.2f, 1.0f, 1.0f);
        startColour = 10;
        colourTableB = this.copyToColourTable(colourTableB, colorsB, startColour);
        for (String thisDomain : distinctPfamBDomains) {
            this.domainColour.put(thisDomain, colourTableB[colourIndex]);
            ++colourIndex;
        }
        CustomizedForceDirectedLayout force = (CustomizedForceDirectedLayout)appFrame.getGraphPanel().getActionLayout().get(1);
        force.setnParentDomains(this.nParentDomains);
        appFrame.getGraphPanel().setDomainColours(this.domainColour, this.domainSeparator, this.useCATH);
        appFrame.getGraphPanel().getVisualization().getGroup(Visualization.FOCUS_ITEMS).clear();
        appFrame.getGraphPanel().getVisualization().removeGroup("graph");
        if (GraphStylePanelActions.getInstance().getGraphRenderingStatus().equals("stopped")) {
            GraphStylePanelActions.getInstance().toggleGraphAction(appFrame);
        }
        VisualGraph vg = appFrame.getGraphPanel().getVisualization().addGraph("graph", Main.graph);
        VisualItem f = (VisualItem)((Object)vg.getNode(graphBuilder.getParentNodeId()));
        appFrame.getGraphPanel().getVisualization().getGroup(Visualization.FOCUS_ITEMS).setTuple(f);
        f.setFixed(false);
        appFrame.getGraphPanel().getVisualization().setValue("graph.nodes", null, VisualItem.SHAPE, 1);
        appFrame.getGraphPanel().getVisualization().setValue("graph.edges", null, VisualItem.INTERACTIVE, Boolean.FALSE);
        appFrame.getGraphPanel().getVisualization().repaint();
        if (appFrame.getGraphStylePanel().getAddSequencesRadioButton().isSelected()) {
            GraphStylePanelActions.getInstance().AddRemoveSelectedNodes(appFrame, "add_sequences", this.offLine);
        } else if (appFrame.getGraphStylePanel().getAddStructuresRadioButton().isSelected()) {
            GraphStylePanelActions.getInstance().AddRemoveSelectedNodes(appFrame, "add_structures", this.offLine);
        } else if (appFrame.getGraphStylePanel().getAddEnzymesRadioButton().isSelected() || this.addEnzymes) {
            GraphStylePanelActions.getInstance().AddRemoveSelectedNodes(appFrame, "add_enzymes", this.offLine);
        }
        Rectangle2D bounds = appFrame.getGraphPanel().getVisualization().getBounds("graph");
        GraphicsLib.expand(bounds, 300 + (int)(1.0 / appFrame.getGraphPanel().getVisualization().getDisplay(0).getScale()));
        DisplayLib.fitViewToBounds(appFrame.getGraphPanel().getVisualization().getDisplay(0), bounds, 0L);
        Thread t = new Thread(new RenderingCountdown(appFrame));
        t.start();
        int sequenceCount = 0;
        Map<String, Integer> domainOccurrences = CollectionUtils.newMap();
        Map<String, Integer> domainArchitectureOccurrences = CollectionUtils.newMap();
        for (String d : allDistinctDomains) {
            domainOccurrences.put(d, 0);
            domainArchitectureOccurrences.put(d, 0);
        }
        for (String a : this.archSeqListPair.keySet()) {
            sequenceCount += this.archSeqListPair.get(a).size();
            Set tmp = CollectionUtils.newSet();
            for (String d : a.split(this.domainSeparator)) {
                int i = (Integer)domainOccurrences.get(d) + 1;
                domainOccurrences.put(d, i);
                if (tmp.contains(d)) continue;
                int j = (Integer)domainArchitectureOccurrences.get(d) + 1;
                domainArchitectureOccurrences.put(d, j);
                tmp.add(d);
            }
        }
        StringBuilder sb = new StringBuilder();
        String[] parentDomains = this.parentArchitecture.split(this.domainSeparator);
        List<String> pDomains = CollectionUtils.newList();
        for (String d : parentDomains) {
            pDomains.add(d);
        }
        String coverage = this.archCoveragePair.get(this.parentArchitecture);
        sb = this.addSpacer(sb, 1, 6);
        sb.append("<center>");
        sb.append("<b>Graph of related " + domainTypeDesc[this.domainType] + " domain architectures</b>");
        sb.append("</center>");
        sb = this.addSpacer(sb, 1, 6);
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td valign=top>");
        sb = this.nodeDomainsTable(sb, parentDomains, coverage, this.domainColour, "parent");
        sb.append("</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td valign=top><b>Parent sequence:</b></td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td valign=top><font color=blue>" + this.parentSequence + "</font></td>");
        sb.append("<td><font color=blue>&nbsp;-&nbsp;</font></td>");
        sb.append("<td valign=top><font color=blue>" + this.parentName + "</font></td>");
        sb.append("</tr>");
        sb.append("</table>");
        appFrame.setTitle(this.parentSequence + " - " + this.parentName);
        sb = this.addSpacer(sb, 1, 10);
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr><td valign=top>");
        sb = this.showKey(sb);
        sb.append("</td>");
        sb.append("<td align=right valign=top>");
        sb = this.showStats(sb, nArch, nFinal, nCollapsed, nPfam, nSeqs);
        sb.append("</td></tr>");
        sb.append("</table>");
        sb = this.addSpacer(sb, 1, 10);
        sb = this.showDomainList(sb, pDomains, null, null, this.domainColour);
        sb = this.addSpacer(sb, 1, 10);
        List<String> entries = CollectionUtils.getKeysSortedByValue(domainOccurrences, true);
        sb = this.showDomainList(sb, entries, domainOccurrences, domainArchitectureOccurrences, this.domainColour);
        this.masterText = "<html><head><style type=\"text/css\">\nbody { font-size: 12pt; font-family: sans-serif }\n</style><head><body font=\"sans-serif\">" + sb + "</body></html>";
        sb = new StringBuilder();
        sb = this.showEnzymeColoursTable(sb);
        sb = this.addSpacer(sb, 1, 10);
        Map<Integer, Map<String, String>> enzyme = this.getEnzymeDetails();
        sb = this.showEnzymeList(sb, enzyme);
        sb = this.addSpacer(sb, 1, 10);
        this.enzymesText = "<html><head><style type=\"text/css\">\nbody { font-size: 12pt; font-family: sans-serif }\n</style><head><body font=\"sans-serif\">" + sb + "</body></html>";
        appFrame.getDataPane().setText(this.masterText);
        appFrame.setCursor(Cursor.getPredefinedCursor(0));
        if (this.offLine) {
            for (int i = 0; i < 50 && t.isAlive(); ++i) {
                Thread.sleep(1000L);
            }
            int errorCode = 0;
            boolean landscape = false;
            boolean writeError = false;
            String psName = "ArchSchema.ps";
            try {
                WritePSFile writePS = new WritePSFile(psName, appFrame, this.useCATH, landscape);
                if (!writePS.getOK()) {
                    writeError = true;
                }
            }
            catch (IOException error) {
                writeError = true;
            }
            if (writeError) {
                System.out.println("*** ERROR. Failed to write output PostScript file " + psName);
                errorCode = -1;
            }
            for (int loop = 0; loop < 2; ++loop) {
                String htmlPage;
                String outName;
                if (loop == 0) {
                    outName = "domains.html";
                    htmlPage = this.masterText;
                } else {
                    outName = "enzymes.html";
                    htmlPage = this.enzymesText;
                }
                PrintStream out = new PrintStream(outName);
                out.println(htmlPage);
                out.close();
            }
            System.exit(errorCode);
        }
    }

    private Vector<Object> getUserFilterCriteria(AppFrame appFrame) {
        Vector<Object> filterCriteria = new Vector<Object>();
        String pfamDomainOperator = SwingUtils.getSelection(appFrame.getGraphCriteriaPanel().getDomainOperatorRadioButtonGroup()).getText().trim();
        List pfamDomainsSelected = CollectionUtils.newList();
        for (Object t : appFrame.getGraphCriteriaPanel().getDomainList().getSelectedValues()) {
            pfamDomainsSelected.add(((NameValue)t).getValue());
        }
        String organism = ((NameValue)appFrame.getGraphCriteriaPanel().getOrganismComboBox().getSelectedItem()).getValue();
        boolean pdbOnly = !appFrame.getGraphCriteriaPanel().getPdbOptionComboBox().getSelectedItem().toString().equals("ALL");
        filterCriteria.add(pfamDomainOperator);
        filterCriteria.add(pfamDomainsSelected);
        filterCriteria.add(organism);
        filterCriteria.add(pdbOnly);
        return filterCriteria;
    }

    public ArrayList<String> getClosestArchitectures(Map<Integer, Map<String, String>> index, int itemsToReturn) {
        Map<String, Double> distances = CollectionUtils.newMap();
        for (Integer key : index.keySet()) {
            Map<String, String> archData = index.get(key);
            String architecture = archData.get("architecture");
            double dist = 1000.0 - Double.parseDouble(archData.get("dist"));
            distances.put(architecture, dist);
        }
        List sortedArchitectures = CollectionUtils.getKeysSortedByValue(distances, true);
        return new ArrayList<String>(sortedArchitectures.subList(0, itemsToReturn));
    }

    private void getArchitectureMappings(Set<Map<String, String>> archSet) {
        this.archSeqListPair = CollectionUtils.newMap();
        this.archPDBListPair = CollectionUtils.newMap();
        this.archCoveragePair = CollectionUtils.newMap();
        for (Map<String, String> archDetails : archSet) {
            String architecture = archDetails.get("architecture");
            if (this.archSeqListPair.containsKey(architecture)) {
                String coverage;
                this.archSeqListPair.get(architecture).add(archDetails.get("uniprot_id"));
                String pdbCodes = archDetails.get("pdb_codes");
                if (pdbCodes != null && pdbCodes.length() != 0 && !pdbCodes.equals("NONE")) {
                    for (String code : pdbCodes.split(" ")) {
                        if (code.length() > 8) {
                            code = code.substring(0, 8) + "...";
                        }
                        this.archPDBListPair.get(architecture).add(code);
                    }
                }
                if ((coverage = archDetails.get("3D_coverage")).equals("NONE")) continue;
                String oldCoverage = this.archCoveragePair.get(architecture);
                if (oldCoverage.equals("NONE")) {
                    this.archCoveragePair.put(architecture, coverage);
                    continue;
                }
                if (coverage.length() != oldCoverage.length()) continue;
                String newCoverage = "";
                for (int iPos = 0; iPos < coverage.length(); ++iPos) {
                    char ch = coverage.charAt(iPos);
                    char oldCh = oldCoverage.charAt(iPos);
                    newCoverage = ch == 'A' && (oldCh == 'P' || oldCh == 'F' || oldCh == '.') || ch == 'P' && (oldCh == 'F' || oldCh == '.') || ch == 'F' && oldCh == '.' || ch == '-' && oldCh == ' ' ? newCoverage + ch : newCoverage + oldCh;
                }
                if (newCoverage.equals(oldCoverage)) continue;
                this.archCoveragePair.put(architecture, newCoverage);
                continue;
            }
            List seqList = CollectionUtils.newList();
            seqList.add(archDetails.get("uniprot_id"));
            this.archSeqListPair.put(architecture, seqList);
            String pdbCodes = archDetails.get("pdb_codes");
            List<String> pdbList = this.getPDBList(pdbCodes);
            this.archPDBListPair.put(architecture, pdbList);
            String coverage = archDetails.get("3D_coverage");
            this.archCoveragePair.put(architecture, coverage);
        }
    }

    private void getEnzymeMappings(Set<Map<String, String>> enzSet) {
        this.archEnzymeListPair = CollectionUtils.newMap();
        for (Map<String, String> enzDetails : enzSet) {
            String architecture = enzDetails.get("architecture");
            int nSeqs = Integer.parseInt(enzDetails.get("nseqs"));
            String endString = "seqs)";
            if (nSeqs == 1) {
                endString = "seq)";
            }
            String enzyme = enzDetails.get("id") + " (" + nSeqs + endString;
            if (this.archEnzymeListPair.containsKey(architecture)) {
                this.archEnzymeListPair.get(architecture).add(enzyme);
                continue;
            }
            List enzList = CollectionUtils.newList();
            enzList.add(enzyme);
            this.archEnzymeListPair.put(architecture, enzList);
        }
    }

    public List<String> getPDBList(String pdbCodes) {
        List<String> pdbList = CollectionUtils.newList();
        if (pdbCodes != null && pdbCodes.length() != 0 && !pdbCodes.equals("NONE")) {
            for (String code : pdbCodes.split(" ")) {
                if (code.length() > 8) {
                    code = code.substring(0, 8) + "...";
                }
                pdbList.add(code);
            }
        }
        return pdbList;
    }

    public String getErrorType() {
        String errorType = "Unknown error";
        if (seqSearchResults != null) {
            errorType = (String)seqSearchResults.get(1);
        }
        return errorType;
    }

    public String getErrorMessage() {
        String errorMessage = "No error message";
        if (seqSearchResults != null) {
            errorMessage = (String)seqSearchResults.get(2);
        }
        return errorMessage;
    }

    public int getNDomains() {
        int nDomains = 0;
        if (seqSearchResults != null) {
            nDomains = (Integer)seqSearchResults.get(5);
        }
        return nDomains;
    }

    public int getNPfam() {
        int nPfam = 0;
        if (seqSearchResults != null) {
            nPfam = (Integer)seqSearchResults.get(6);
        }
        return nPfam;
    }

    public int getNSequences() {
        int nSequences = 0;
        if (seqSearchResults != null) {
            nSequences = (Integer)seqSearchResults.get(1);
        }
        return nSequences;
    }

    public int getNArch() {
        int nUnique = 0;
        if (seqSearchResults != null) {
            nUnique = (Integer)seqSearchResults.get(2);
        }
        return nUnique;
    }

    public int getNFinal() {
        int nFinal = 0;
        if (seqSearchResults != null) {
            nFinal = (Integer)seqSearchResults.get(4);
        }
        return nFinal;
    }

    public int getNCollapsed() {
        int nCollapsed = 0;
        if (seqSearchResults != null) {
            nCollapsed = (Integer)seqSearchResults.get(3);
        }
        return nCollapsed;
    }

    public int getNSpecies() {
        int nSpecies = 0;
        if (seqSearchResults != null) {
            nSpecies = (Integer)seqSearchResults.get(7);
        }
        return nSpecies;
    }

    public String getParentSequence() {
        String seqId = "";
        if (seqSearchResults != null) {
            seqId = (String)seqSearchResults.get(8);
        }
        return seqId;
    }

    public int getRunStatus() {
        int status = -9;
        if (seqSearchResults != null) {
            status = (Integer)seqSearchResults.get(0);
        }
        return status;
    }

    public Set<Map<String, String>> getArchitectures() {
        Set archSet = CollectionUtils.newSet();
        if (seqSearchResults == null) {
            return null;
        }
        archSet = (Set)seqSearchResults.get(9);
        return archSet;
    }

    public Set<Map<String, String>> getEnzymes() {
        Set enzSet = CollectionUtils.newSet();
        if (seqSearchResults == null) {
            return null;
        }
        enzSet = (Set)seqSearchResults.get(10);
        return enzSet;
    }

    public List<String> getDomainList(String architecture) {
        List<String> domains = CollectionUtils.newList();
        for (String pfam : architecture.split(this.domainSeparator)) {
            if (domains.contains(pfam)) continue;
            domains.add(pfam);
        }
        return domains;
    }

    public Map<String, Map<String, String>> getDomainDetails() {
        Map domainMap = CollectionUtils.newMap();
        if (seqSearchResults == null) {
            return null;
        }
        domainMap = (Map)seqSearchResults.get(12);
        return domainMap;
    }

    public Map<String, Map<String, String>> getSpeciesDetails() {
        Map speciesMap = CollectionUtils.newMap();
        if (seqSearchResults == null) {
            return null;
        }
        speciesMap = (Map)seqSearchResults.get(11);
        return speciesMap;
    }

    public Map<Integer, Map<String, String>> getEnzymeDetails() {
        Map enzymeMap = CollectionUtils.newMap();
        if (seqSearchResults == null) {
            return null;
        }
        enzymeMap = (Map)seqSearchResults.get(13);
        return enzymeMap;
    }

    private Map<Integer, Map<String, String>> getArchIndex() {
        Map archIndex = CollectionUtils.newMap();
        if (seqSearchResults == null) {
            return null;
        }
        archIndex = (Map)seqSearchResults.get(14);
        return archIndex;
    }

    private Map<Pair<String, String>, Integer> getConnectionsList() {
        Map connectionsList = CollectionUtils.newMap();
        if (seqSearchResults == null) {
            return null;
        }
        connectionsList = (Map)seqSearchResults.get(15);
        return connectionsList;
    }

    public int getmaxArchitectures() {
        int maxArchitectures = 0;
        if (seqSearchResults != null) {
            try {
                maxArchitectures = (Integer)seqSearchResults.get(16);
            }
            catch (Exception e) {
                maxArchitectures = 0;
            }
        }
        return maxArchitectures;
    }

    public void resetAction(AppFrame appFrame) {
        appFrame.getGraphPanel().clearGraph();
        appFrame.getDataPane().setText("");
        appFrame.getInputPanel().getSequenceTextField().setText("");
        appFrame.getGraphCriteriaPanel().getSequenceInfoLabel().setText("");
    }

    public String getDomainSeparator() {
        return this.domainSeparator;
    }

    public String getParentArchitecture() {
        return this.parentArchitecture;
    }

    public String getEnzymesText() {
        return this.enzymesText;
    }

    public String getMasterText() {
        return this.masterText;
    }

    public void setImgURL(URL imgURL) {
        SearchPanelActions.imgURL = imgURL;
    }

    public int getDomainType() {
        return this.domainType;
    }

    public String getCoverage(String architecture) {
        String coverage = " ";
        if (this.archCoveragePair != null) {
            coverage = this.archCoveragePair.get(architecture);
        }
        return coverage;
    }

    public Map<String, Integer> getDomainColour() {
        return this.domainColour;
    }

    public StringBuilder addSpacer(StringBuilder sb, int width, int height) {
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td><img width=" + width + " height=" + height + " src=\"" + imgURL + "1x1.gif\"></td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    public StringBuilder showSequencesList(StringBuilder sb, String architecture) {
        String tickName = imgURL + "greentick.gif";
        String tickName1 = imgURL + "greentick1.gif";
        String tickImage = "<img border=0 src=\"" + imgURL + "greentick.gif" + "\">";
        String tickImage1 = "<img border=0 src=\"" + imgURL + "greentick1.gif" + "\">";
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><b>List of UniProt sequences:</b></td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=left><u>UniProt</u></td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=left><u>Code</u></td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td colspan=3 align=left><u>PDB*</u></td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=left><u>Protein name</u></td>");
        sb.append("</tr>");
        String doneSeqs = "";
        int nSeqs = 0;
        int nListed = 0;
        int nTotal = 0;
        for (int loop = 0; loop < 3; ++loop) {
            nSeqs = 0;
            for (Map<String, String> archDetails : this.architectures) {
                if (!architecture.equals(archDetails.get("architecture"))) continue;
                if (nListed < 200) {
                    String coverage = archDetails.get("3D_coverage");
                    if (nTotal == 0) {
                        nTotal = Integer.parseInt(archDetails.get("nseqs"));
                    }
                    boolean wanted = false;
                    if (loop == 0) {
                        if (coverage != null && !coverage.equals("NONE")) {
                            wanted = coverage.indexOf(32) <= -1 && coverage.indexOf(46) <= -1 && coverage.indexOf(80) <= -1 && coverage.indexOf(70) <= -1;
                        }
                    } else if (loop == 1) {
                        if (coverage != null && !coverage.equals("NONE")) {
                            wanted = coverage.indexOf(32) > -1 || coverage.indexOf(46) > -1 || coverage.indexOf(80) > -1 || coverage.indexOf(70) > -1;
                        }
                    } else if (loop == 2) {
                        wanted = coverage == null || coverage.equals("NONE");
                    }
                    if (wanted) {
                        sb.append("<tr>");
                        String code = archDetails.get("uniprot_acc");
                        String id = archDetails.get("uniprot_id");
                        sb.append("<td>&nbsp;&nbsp;</td>");
                        sb.append("<td valign=top align=left><a href=\"https://www.uniprot.org/uniprot/" + code + "\">" + code + "</a></td>");
                        sb.append("<td>&nbsp;&nbsp;</td>");
                        sb.append("<td valign=top align=left>" + id + "</td>");
                        String proteinName = archDetails.get("protein_name");
                        String organism = archDetails.get("organism");
                        sb.append("<td>&nbsp;&nbsp;</td>");
                        if (coverage != null && !coverage.equals("NONE")) {
                            String showImage = tickName;
                            if (coverage.indexOf(32) > -1 || coverage.indexOf(80) > -1 || coverage.indexOf(70) > -1) {
                                showImage = tickName1;
                            }
                            sb.append("<td valign=top align=center><a href=\"https://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/pdbsum/GetUnichains.pl?uniprot_id=" + code + "&uniprot_code=" + id + "\"><img border=0 src=\"" + showImage + "\"></a></td>");
                            sb.append("<td>&nbsp;&nbsp;</td>");
                            String numPDB = "-";
                            String pdbCodes = archDetails.get("pdb_codes");
                            if (pdbCodes != null && pdbCodes.length() != 0 && !pdbCodes.equals("NONE")) {
                                int nPDB = 0;
                                for (String c : pdbCodes.split(" ")) {
                                    numPDB = "" + ++nPDB;
                                }
                            }
                            sb.append("<td>" + numPDB + "</td>");
                        } else {
                            sb.append("<td colspan=3 valign=top align=center>-</td>");
                        }
                        sb.append("<td>&nbsp;&nbsp;</td>");
                        sb.append("<td valign=top align=left>" + proteinName);
                        if (organism != null && organism.length() > 1) {
                            sb.append(" <font color=purple><i>" + organism + "</i></font>");
                        }
                        sb.append("</td>");
                        sb.append("</tr>");
                        ++nListed;
                    }
                }
                ++nSeqs;
            }
        }
        sb.append("</table>");
        sb = this.addSpacer(sb, 1, 10);
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><b>Number of sequences listed: " + nSeqs);
        if (nTotal > nSeqs) {
            sb.append("<font color=red> (from " + nTotal + " total sequences for this architecture)</font>");
        }
        sb.append("</b>");
        sb.append("</td></tr>");
        sb.append("</table>");
        sb = this.addSpacer(sb, 1, 10);
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td colspan=13>* <i>PDB column indicates whether the ");
        sb.append("sequence has structural information in the PDB, as follows:");
        sb.append("</i></td></tr>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>");
        sb.append("<td>" + tickImage + "</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><i>Structure(s) of complete sequence;</i></td>");
        sb.append("<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>");
        sb.append("<td>" + tickImage1 + "</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><i>Structure(s) of part of sequence;</i></td>");
        sb.append("<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>");
        sb.append("<td>-</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><i>No structural data.</i></td>");
        sb.append("<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td colspan=13>The number to the right of the tick indicates ");
        sb.append("the number of PDB entries.");
        sb.append("</i></td></tr>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td colspan=13><i>Click on tick to go to list of PDB codes ");
        sb.append("for the sequence in PDBsum.");
        sb.append("</i></td></tr>");
        sb.append("</table>");
        return sb;
    }

    private int[] copyToColourTable(int[] colourTable, int[] prefuseColors, int startColour) {
        int nextPrefuseColour = 0;
        int dummyColourCode = 99999999;
        for (int iColour = 0; iColour < colourTable.length; ++iColour) {
            if (startColour + iColour < 45) {
                int colour = (startColour + iColour) % 45;
                String rgbString = Constants.COLOUR_DEFN[colour][2];
                String[] rgbVals = rgbString.split("\\s");
                int[] rgb = new int[3];
                int i = 0;
                for (String ival : rgbVals) {
                    rgb[i] = Integer.parseInt(ival);
                    ++i;
                }
                colourTable[iColour] = ColorLib.rgb(rgb[0], rgb[1], rgb[2]);
                int closestColour = dummyColourCode;
                int minDist = 0;
                for (i = 0; i < prefuseColors.length; ++i) {
                    int colourCode = prefuseColors[i];
                    if (colourCode == dummyColourCode) continue;
                    Color c = ColorLib.getColor(colourCode);
                    int red = c.getRed();
                    int green = c.getGreen();
                    int blue = c.getBlue();
                    int dist = (red - rgb[0]) * (red - rgb[0]) + (green - rgb[1]) * (green - rgb[1]) + (blue - rgb[2]) * (blue - rgb[2]);
                    if (i != 0 && dist >= minDist) continue;
                    minDist = dist;
                    closestColour = i;
                }
                if (closestColour == dummyColourCode) continue;
                prefuseColors[closestColour] = dummyColourCode;
                continue;
            }
            boolean ok = false;
            int colourCode = dummyColourCode;
            while (!ok && nextPrefuseColour < prefuseColors.length) {
                colourCode = prefuseColors[nextPrefuseColour];
                ++nextPrefuseColour;
                if (colourCode == dummyColourCode) continue;
                ok = true;
            }
            colourTable[iColour] = ok ? colourCode : ColorLib.rgb(0, 0, 0);
        }
        return colourTable;
    }

    private int getNextColour(int startColour, int iColour) {
        int colour = (startColour + iColour) % 45;
        String rgbString = Constants.COLOUR_DEFN[colour][2];
        String[] rgbVals = rgbString.split("\\s");
        int[] rgb = new int[3];
        int i = 0;
        for (String ival : rgbVals) {
            rgb[i] = Integer.parseInt(ival);
            ++i;
        }
        int colourCode = ColorLib.rgb(rgb[0], rgb[1], rgb[2]);
        return colourCode;
    }

    public StringBuilder newSearchIcon(StringBuilder sb, String architecture, boolean useCATH) {
        String seqId = null;
        Iterator<Map<String, String>> iArch = this.architectures.iterator();
        while (iArch.hasNext() && seqId == null) {
            Map<String, String> archDetails = iArch.next();
            if (!archDetails.get("architecture").equalsIgnoreCase(architecture)) continue;
            seqId = archDetails.get("uniprot_acc");
        }
        if (seqId == null) {
            return sb;
        }
        String iconURL = "<img border=0 src=\"" + imgURL + "new_search.jpg" + "\">";
        String url = "https://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/archschema/RunArchSchema.jnlp?seqId=" + seqId + "&source=New";
        if (useCATH) {
            url = url + "&cath=TRUE";
        }
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td valign=top><a href=\"" + url + "\">" + iconURL + "</a></td>");
        sb.append("<td><i>Run ArchSchema with this architecture as parent</i></td>");
        return sb;
    }

    public StringBuilder nodeDomainsTable(StringBuilder sb, String[] domains, String coverage, Map<String, Integer> domainColour, String nodeType) {
        String imgSrc = "<td><img src=\"" + imgURL;
        String imgEnd = "\"></td>";
        String borderBottom = imgSrc + "border_bottom.gif" + imgEnd;
        String borderMiddle = imgSrc + "border_middle.gif" + imgEnd;
        String borderTop = imgSrc + "border_top.gif" + imgEnd;
        String bottom = imgSrc + "bottom.gif" + imgEnd;
        String bottomGap1 = imgSrc + "bottom_gap1.gif" + imgEnd;
        String bottomGap2 = imgSrc + "bottom_gap2.gif" + imgEnd;
        String covA = imgSrc + "covA.gif" + imgEnd;
        String covAA = imgSrc + "covAA.gif" + imgEnd;
        String covP = imgSrc + "covP.gif" + imgEnd;
        String covGap = imgSrc + "covgap.gif" + imgEnd;
        String gap1 = imgSrc + "gap1.gif" + imgEnd;
        String gap2 = imgSrc + "gap2.gif" + imgEnd;
        String middle = imgSrc + "middle.gif" + imgEnd;
        String middleGap1 = imgSrc + "middle_gap1.gif" + imgEnd;
        String middleGap2 = imgSrc + "middle_gap2.gif" + imgEnd;
        String splitCATHgif = "split_cath.gif";
        String pFamACATHgif = "pfamA_CATH.gif";
        String pFamAgif = "pfamA.gif";
        String pFamBgif = "pfamB.gif";
        if (nodeType.equals("parent")) {
            bottom = imgSrc + "bottom_parent.gif" + imgEnd;
            bottomGap1 = imgSrc + "bottom_gap1_parent.gif" + imgEnd;
            bottomGap2 = imgSrc + "bottom_gap2_parent.gif" + imgEnd;
            covA = imgSrc + "covA_parent.gif" + imgEnd;
            covAA = imgSrc + "covAA_parent.gif" + imgEnd;
            covP = imgSrc + "covP_parent.gif" + imgEnd;
            covGap = imgSrc + "covgap_parent.gif" + imgEnd;
            gap1 = imgSrc + "gap1_parent.gif" + imgEnd;
            gap2 = imgSrc + "gap2_parent.gif" + imgEnd;
            middle = imgSrc + "middle_parent.gif" + imgEnd;
            middleGap1 = imgSrc + "middle_gap1_parent.gif" + imgEnd;
            middleGap2 = imgSrc + "middle_gap2_parent.gif" + imgEnd;
            splitCATHgif = "split_cath_parent.gif";
            pFamACATHgif = "pfamA_CATH_parent.gif";
            pFamAgif = "pfamA_parent.gif";
            pFamBgif = "pfamB_parent.gif";
        }
        boolean haveCoverage = false;
        int lenCoverage = 0;
        if (coverage.indexOf(65) > -1 || coverage.indexOf(80) > -1) {
            haveCoverage = true;
            lenCoverage = coverage.length();
        }
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append(borderTop);
        int gap = 0;
        for (String d : domains) {
            if (gap == 0) {
                sb.append(gap1);
            } else {
                sb.append(gap2);
            }
            ++gap;
            sb.append("<td bgcolor=\"");
            Color c = ColorLib.getColor(domainColour.get(d));
            sb.append(String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue()));
            sb.append("\"><img src=\"").append(imgURL);
            String gifName = d.substring(0, 2).equals("PB") ? pFamBgif : pFamAgif;
            if (this.useCATH) {
                if (d.substring(0, 2).equals("PF")) {
                    gifName = pFamACATHgif;
                } else if (d.charAt(0) == 'p') {
                    gifName = splitCATHgif;
                }
            }
            sb.append(gifName).append("\"></td>");
        }
        sb.append(gap1);
        sb.append(borderTop);
        sb.append("</tr>");
        if (haveCoverage) {
            sb.append("<tr>");
            sb.append(borderMiddle);
            gap = 0;
            int iPos = 0;
            String[] stringArray = domains;
            int n = stringArray.length;
            for (int d = 0; d < n; ++d) {
                String d2 = stringArray[d];
                if (gap == 0) {
                    sb.append(middleGap1);
                } else {
                    if (iPos < lenCoverage && coverage.charAt(iPos) == '-') {
                        sb.append(covGap);
                    } else {
                        sb.append(middleGap2);
                    }
                    ++iPos;
                }
                ++gap;
                int ch = 32;
                if (iPos < lenCoverage) {
                    ch = coverage.charAt(iPos);
                }
                if (ch == 32) {
                    sb.append(middle);
                } else if (ch == 65) {
                    if (iPos + 1 < coverage.length() && coverage.charAt(iPos + 1) == '-') {
                        sb.append(covAA);
                    } else {
                        sb.append(covA);
                    }
                } else if (ch == 80) {
                    sb.append(covP);
                } else {
                    sb.append(middle);
                }
                ++iPos;
            }
            sb.append(middleGap1);
            sb.append(borderMiddle);
            sb.append("</tr>");
        }
        sb.append("<tr>");
        sb.append(borderBottom);
        gap = 0;
        for (String d : domains) {
            if (gap == 0) {
                sb.append(bottomGap1);
            } else {
                sb.append(bottomGap2);
            }
            ++gap;
            sb.append(bottom);
        }
        sb.append(bottomGap1);
        sb.append(borderBottom);
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    private Map<String, List<String>> replaceParents(Map<String, List<String>> architectures, SwissPfamSearcher searcher) {
        if (!architectures.containsKey(this.parentArchitecture)) {
            List tmp = CollectionUtils.newList();
            tmp.add(this.parentSequence);
            architectures.put(this.parentArchitecture, tmp);
            List<String> pdbList = searcher.getPDBList(this.parentPDBCodes);
            this.archPDBListPair.put(this.parentArchitecture, pdbList);
            this.archCoveragePair.put(this.parentArchitecture, this.parentCoverage);
        } else if (!architectures.get(this.parentArchitecture).contains(this.parentSequence)) {
            List<String> pdbList = searcher.getPDBList(this.parentPDBCodes);
            this.archPDBListPair.put(this.parentArchitecture, pdbList);
            this.archCoveragePair.put(this.parentArchitecture, this.parentCoverage);
        }
        return architectures;
    }

    private StringBuilder showKey(StringBuilder sb) {
        String imgSrc = "<td align=center valign=center><img src=\"" + imgURL;
        String imgEnd = "\"></td>";
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><b>Key:</b></td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        int colourCode = this.getNextColour(0, 0);
        Color cCode = ColorLib.getColor(colourCode);
        String colourString = String.format("#%02X%02X%02X", cCode.getRed(), cCode.getGreen(), cCode.getBlue());
        sb.append("<td align=center valign=center>");
        String dummyDomain = "PF00000";
        if (this.useCATH) {
            dummyDomain = "1.10.20.300";
        }
        sb = this.singleDomainTable(sb, dummyDomain, colourString);
        sb.append("</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td>" + domainCatDesc[0] + " domain</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        colourCode = this.getNextColour(10, 0);
        cCode = ColorLib.getColor(colourCode);
        colourString = String.format("#%02X%02X%02X", cCode.getRed(), cCode.getGreen(), cCode.getBlue());
        sb.append("<td align=center valign=center>");
        dummyDomain = "PB00000";
        if (this.useCATH) {
            dummyDomain = "p1.10.20.300";
        }
        sb = this.singleDomainTable(sb, dummyDomain, colourString);
        sb.append("</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td>" + domainCatDesc[1] + " domain</td>");
        sb.append("<td><img width=100 height=1 src=\"" + imgURL + "1x1.gif" + imgEnd);
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td colspan=3>&nbsp;</td>");
        sb.append(imgSrc + "key_covA.gif" + imgEnd);
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td colspan=7>3D structure of whole domain is known</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td colspan=3>&nbsp;</td>");
        sb.append(imgSrc + "key_covP.gif" + imgEnd);
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td colspan=7>Only part of domain has a known 3D structure</td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    private StringBuilder showStats(StringBuilder sb, int nArch, int nFinal, int nCollapsed, int nPfam, int nSeqs) {
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><b>Stats:</b></td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td>No. of domain architectures:</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=right><b>" + nArch + "</b></td>");
        sb.append("</tr>");
        if (nFinal < nArch) {
            sb.append("<tr>");
            sb.append("<td colspan=3>&nbsp;</td>");
            sb.append("<td><font color=red>&nbsp;&nbsp;- of which number shown in plot:</td>");
            sb.append("<td>&nbsp;&nbsp;</td>");
            sb.append("<td align=right><b>" + nFinal + "</b></font></td>");
            sb.append("</tr>");
        }
        sb.append("<tr>");
        sb.append("<td colspan=3>&nbsp;</td>");
        sb.append("<td>No. of distinct domains:</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=right><b>" + nPfam + "</b></td>");
        sb.append("</tr>");
        if (nCollapsed < nArch) {
            sb.append("<tr>");
            sb.append("<td colspan=3>&nbsp;</td>");
            sb.append("<td><font color=red>Note: All Pfam-B domains (excluding any in the parent architecture) have been replaced by a single dummy domain, PB000000</font></td>");
            sb.append("<td>&nbsp;&nbsp;</td>");
            sb.append("<td align=right>&nbsp;</td>");
            sb.append("</tr>");
        }
        sb.append("<tr>");
        sb.append("<td colspan=3>&nbsp;</td>");
        sb.append("<td>No. of protein seqs:</td>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=right><b>" + nSeqs + "</b></td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    public StringBuilder showDomainList(StringBuilder sb, List<String> entries, Map<String, Integer> domainOccurrences, Map<String, Integer> domainArchitectureOccurrences, Map<String, Integer> domainColour) {
        String imgSrc = "<td align=center valign=center><img src=\"" + imgURL;
        String imgEnd = "\"></td>";
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        if (domainOccurrences != null && domainArchitectureOccurrences != null) {
            sb.append("<td><b>Sorted list of all " + domainTypeDesc[this.domainType] + " domains in graph:</b></td>");
        } else {
            sb.append("<td><b>List of " + domainTypeDesc[this.domainType] + " domains:</b></td>");
        }
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=center valign=bottom><u>Domain</u></td>");
        sb.append("<td>&nbsp;</td>");
        if (this.domainType == 0) {
            sb.append("<td align=left valign=bottom><u>Pfam id</u></td>");
        } else {
            sb.append("<td align=left valign=bottom><u>CATH/Pfam code</u></td>");
        }
        sb.append("<td>&nbsp;</td>");
        if (this.domainType == 0) {
            sb.append("<td align=left valign=bottom><u>Name</u></td>");
        } else {
            sb.append("<td align=left valign=bottom><u>Fold</u></td>");
        }
        sb.append("<td>&nbsp;</td>");
        sb.append("<td align=left valign=bottom><u>Description</u></td>");
        if (domainOccurrences != null && domainArchitectureOccurrences != null) {
            sb.append("<td>&nbsp;</td>");
            sb.append("<td align=right valign=bottom><u>Count</u></td>");
            sb.append("<td>&nbsp;</td>");
            sb.append("<td align=right valign=bottom><u>No.</u><br><u>arch.</u></td>");
        }
        sb.append("</tr>");
        Map<String, Map<String, String>> domainDetails = this.getDomainDetails();
        for (String d : entries) {
            sb.append("<tr>");
            sb.append("<td>&nbsp;&nbsp;</td>");
            Color c = ColorLib.getColor(domainColour.get(d));
            String colourString = String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
            sb.append("<td align=center valign=top>");
            sb = this.singleDomainTable(sb, d, colourString);
            sb.append("</td>");
            sb.append("<td>&nbsp;</td>");
            String url = "https://pfam.xfam.org/family?acc=";
            String domName = d;
            if (d.charAt(0) == 'p') {
                domName = d.substring(1);
            }
            if (d.charAt(0) != 'P') {
                url = "https://www.cathdb.info/cathnode/";
            }
            sb.append("<td valign=top><a href=\"" + url + domName + "\">" + d + "</a></td>");
            sb.append("<td>&nbsp;</td>");
            String name = "&nbsp;&nbsp;-";
            String description = "&nbsp;&nbsp;-";
            if (domainDetails.get(d) != null) {
                name = domainDetails.get(d).get("id");
                if (!d.substring(0, 2).equals("PB")) {
                    name = domainDetails.get(d).get("short_name");
                    description = domainDetails.get(d).get("description");
                }
            }
            sb.append("<td valign=top>" + name + "</td>");
            sb.append("<td>&nbsp;</td>");
            sb.append("<td valign=top>" + description + "</td>");
            if (domainOccurrences != null && domainArchitectureOccurrences != null) {
                sb.append("<td>&nbsp;</td>");
                int count = 0;
                if (domainOccurrences.get(d) != null) {
                    count = domainOccurrences.get(d);
                }
                sb.append("<td align=right valign=top>" + count + "</td>");
                sb.append("<td>&nbsp;</td>");
                count = 0;
                if (domainArchitectureOccurrences.get(d) != null) {
                    count = domainArchitectureOccurrences.get(d);
                }
                sb.append("<td align=right valign=top>" + count + "</td>");
                sb.append("<td>&nbsp;</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb;
    }

    private StringBuilder singleDomainTable(StringBuilder sb, String domain, String domainColour) {
        String imgSrc = "<img src=\"" + imgURL;
        String imgEnd = "\">";
        String domainImage = imgSrc + "key_pfamA.gif" + imgEnd;
        if (domain.substring(0, 2).equals("PB")) {
            domainImage = imgSrc + "key_pfamB.gif" + imgEnd;
        }
        if (this.useCATH && domain.charAt(0) != 'P') {
            if (domain.charAt(0) == 'p') {
                domainImage = imgSrc + "key_splitCATH.gif" + imgEnd;
            } else if (domain.substring(0, 2).equals("PF")) {
                domainImage = imgSrc + "key_pfamA_CATH.gif" + imgEnd;
            }
        }
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr><td bgcolor =\"" + domainColour + "\">" + domainImage + "</td></tr>");
        sb.append("</table>");
        return sb;
    }

    private StringBuilder showEnzymeColoursTable(StringBuilder sb) {
        String imgSrc = "<img src=\"" + imgURL;
        String imgEnd = "\">";
        int cellSize = 10;
        String blankImage = "src=\"" + imgURL + "1x1.gif\">";
        sb.append("<table border=0 cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><b>Enzyme node colours</b></td>");
        sb.append("</tr>");
        sb.append("<tr><td colspan=2>&nbsp;&nbsp;</td></tr>");
        sb.append("</table>");
        sb.append("<table border=0 cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        for (int i = 0; i < 6; ++i) {
            sb.append("<td>");
            sb.append("<table border=0 cellpadding=0 cellspacing=0>");
            sb.append("<tr>");
            sb.append("<td bgcolor=\"white\"><img width=10 height=1 " + blankImage + "</td>");
            sb.append("<td colspan=3 bgcolor=\"black\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("<td bgcolor=\"white\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("<td colspan=3 bgcolor=\"black\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("<td colspan=5 bgcolor=\"white\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("</tr>");
            int iRow = 2 + i;
            sb.append("<tr>");
            sb.append("<td bgcolor=\"white\"><img width=1 height=1 " + blankImage + "</td>");
            for (int j = 0; j < 2; ++j) {
                sb.append("<td bgcolor=\"black\"><img width=1 height=1 " + blankImage + "</td>");
                int[] rgb = new int[3];
                for (int k = 0; k < 3; ++k) {
                    rgb[k] = Constants.NODE_COLOUR[iRow][j + 1][k];
                }
                String cellColour = String.format("#%02X%02X%02X", rgb[0], rgb[1], rgb[2]);
                sb.append("<td bgcolor=" + cellColour + "><img width=" + cellSize + " height=" + cellSize + " " + blankImage + "</td>");
                sb.append("<td bgcolor=\"black\"><img width=1 height=1 " + blankImage + "</td>");
                if (j != 0) continue;
                sb.append("<td>&nbsp;to&nbsp;</td>");
            }
            sb.append("<td>&nbsp;&nbsp;</td>");
            sb.append("<td>E.C." + (i + 1) + "</td>");
            sb.append("<td>&nbsp;&nbsp;</td>");
            sb.append("<td>" + enzymeClass[i] + "</td>");
            sb.append("<td>&nbsp;&nbsp;</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td bgcolor=\"white\"><img width=10 height=1 " + blankImage + "</td>");
            sb.append("<td colspan=3 bgcolor=\"black\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("<td bgcolor=\"white\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("<td colspan=3 bgcolor=\"black\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("<td colspan=5 bgcolor=\"white\"><img width=1 height=1 " + blankImage + "</td>");
            sb.append("</tr>");
            sb.append("<tr>");
            sb.append("<td colspan=10 bgcolor=\"white\"><img width=2 height=2 " + blankImage + "</td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</td>");
            if ((i + 1) % 3 != 0) continue;
            sb.append("</tr>");
            if (i == 5) continue;
            sb.append("<tr>");
            sb.append("<td>&nbsp;&nbsp;</td>");
        }
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("<table border=0 cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><i>The darker colours for each E.C. class signify a higher number of sequences in that class</i></td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td><i>Any white E.C. class nodes signify mulitple E.C. numbers from different E.C. classes</i></td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    private StringBuilder showEnzymeList(StringBuilder sb, Map<Integer, Map<String, String>> enzyme) {
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        if (enzyme != null) {
            sb.append("<td><b>Sorted list of all enzymes in the graph:</b></td>");
        } else {
            sb.append("<td><b>No enzymes in graph</b></td>");
        }
        sb.append("</tr>");
        sb.append("</table>");
        if (enzyme == null) {
            return sb;
        }
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;&nbsp;</td>");
        sb.append("<td align=left valign=bottom><u>E.C. number</u></td>");
        sb.append("<td>&nbsp;</td>");
        sb.append("<td align=left valign=bottom><u>Description</u></td>");
        sb.append("<td>&nbsp;</td>");
        sb.append("<td align=right valign=bottom><u>No.</u><br><u>arch.</u></td>");
        sb.append("<td>&nbsp;</td>");
        sb.append("<td align=right valign=bottom><u>Seqs</u></td>");
        sb.append("</tr>");
        for (int i = 0; i < enzyme.size(); ++i) {
            sb.append("<tr>");
            sb.append("<td>&nbsp;&nbsp;</td>");
            String ecNumber = enzyme.get(i).get("id");
            String description = enzyme.get(i).get("description");
            int nArch = Integer.parseInt(enzyme.get(i).get("narch"));
            int nSeqs = Integer.parseInt(enzyme.get(i).get("nseqs"));
            String fontStart = "";
            String fontEnd = "";
            int colourCode = 0;
            boolean haveColour = false;
            int dotPos = ecNumber.indexOf(".");
            if (dotPos > -1) {
                int ecClass = Integer.parseInt(ecNumber.substring(0, 1));
                if (ecClass > 0 && ecClass < 7) {
                    int iCol = ecClass + 1;
                    int node = 2;
                    int eSeqs = 1000;
                    colourCode = GraphStylePanelActions.getInstance().getNodeColour(node, iCol, eSeqs);
                    haveColour = true;
                }
            } else {
                int spacePos = ecNumber.indexOf(" ");
                String numberString = spacePos > -1 ? ecNumber.substring(0, spacePos) : ecNumber;
                int ssgClass = Integer.parseInt(numberString);
                if (ssgClass > -1 && ssgClass < 45) {
                    int iCol = ssgClass % 45;
                    String rgbString = Constants.COLOUR_DEFN[iCol][2];
                    String[] rgbVals = rgbString.split("\\s");
                    int[] rgb = new int[3];
                    int j = 0;
                    for (String ival : rgbVals) {
                        rgb[j] = Integer.parseInt(ival);
                        ++j;
                    }
                    colourCode = ColorLib.rgb(rgb[0], rgb[1], rgb[2]);
                    haveColour = true;
                }
            }
            if (haveColour) {
                Color cCode = ColorLib.getColor(colourCode);
                String colourString = String.format("#%02X%02X%02X", cCode.getRed(), cCode.getGreen(), cCode.getBlue());
                fontStart = "<font color=\"" + colourString + "\">";
                fontEnd = "</font>";
            }
            String url = "https://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/enzymes/GetPage.pl?ec_number=";
            sb.append("<td valign=top><a href=\"" + url + ecNumber + "\">" + ecNumber + "</a></td>");
            sb.append("<td>&nbsp;</td>");
            sb.append("<td valign=top>" + fontStart + description + fontEnd + "</td>");
            sb.append("<td>&nbsp;</td>");
            sb.append("<td align=right valign=top>" + nArch + "</td>");
            sb.append("<td>&nbsp;</td>");
            sb.append("<td align=right valign=top>" + nSeqs + "</td>");
            sb.append("<td>&nbsp;</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb;
    }

    static {
        newSearch = true;
        seqSearchResults = null;
        domainCatDesc = new String[2];
        specialOrganisms = new String[]{"HUMAN", "MOUSE", "DROME", "CAEEL", "YEAST"};
        domainTypeDesc = new String[]{"Pfam", "CATH"};
        pfamCatDesc = new String[]{"PfamA", "PfamB"};
        cathCatDesc = new String[]{"CATH", "split-CATH"};
        enzymeClass = new String[]{"Oxidoreductases", "Transferases", "Hydrolases", "Lyases", "Isomerases", "Ligases"};
    }
}

