/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.actions;

import bbk.dng.actions.PostScript;
import bbk.dng.actions.WritePSFile;
import java.awt.geom.Rectangle2D;

class Scale {
    private static final float NEAR_ZERO = 1.0E-6f;
    private static final int X = 0;
    private static final int Y = 1;
    private float[] offset = new float[2];
    private float scaleFactor = 1.0f;
    private int plotAreaHeight = 0;
    private int plotAreaWidth = 0;

    public Scale(WritePSFile psFile, Rectangle2D bounds, boolean landscape, float margin) {
        float[] cMin = new float[2];
        float[] cMax = new float[2];
        cMin[0] = (float)(bounds.getX() - (double)margin);
        cMin[1] = (float)(bounds.getY() - (double)margin);
        cMax[0] = (float)(bounds.getX() + bounds.getWidth()) + margin;
        cMax[1] = (float)(bounds.getY() + bounds.getHeight()) + margin;
        float height = cMax[1] - cMin[1];
        float width = cMax[0] - cMin[0];
        float[] centre = new float[]{(cMin[0] + cMax[0]) / 2.0f, (cMin[1] + cMax[1]) / 2.0f};
        if (Math.abs(width) < 1.0E-6f) {
            width = 1.0f;
        }
        if (Math.abs(height) < 1.0E-6f) {
            height = 1.0f;
        }
        for (int i = 0; i < 2; ++i) {
            this.offset[i] = -cMin[i];
        }
        this.plotAreaHeight = PostScript.getHeight(landscape);
        this.plotAreaWidth = PostScript.getWidth(landscape);
        if (height / width < (float)this.plotAreaHeight / (float)this.plotAreaWidth) {
            this.scaleFactor = (float)this.plotAreaWidth / width;
            this.offset[1] = this.offset[1] + ((float)this.plotAreaHeight / this.scaleFactor - height) / 2.0f;
        } else {
            this.scaleFactor = (float)this.plotAreaHeight / height;
            this.offset[0] = this.offset[0] + ((float)this.plotAreaWidth / this.scaleFactor - width) / 2.0f;
        }
    }

    public float getOffset(int i) {
        return this.offset[i];
    }

    public int getPlotHeight() {
        return this.plotAreaHeight;
    }

    public int getPlotWidth() {
        return this.plotAreaWidth;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }
}

