/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.actions;

import java.awt.Color;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

class PostScript {
    private Color lastColour = null;
    private Color lastCircleColour = null;
    private Color lastSphereColour = null;
    private float lastLineWidth = -1.0f;
    private PrintStream file = null;
    private static double xx1 = -1.0;
    private static double xx2 = 650.0;
    private static double xy1 = -1.0;
    private static double xy2 = 951.0;
    private static float offset_x;
    private static float offset_y;
    private static float pageCentrex;
    private static float pageCentrey;
    private static float pageMaxx;
    private static float pageMaxy;
    private static float pageMinx;
    private static float pageMiny;
    private static final float DEFAULT_LINE_WIDTH = 2.0f;
    private static final float NEAR_ZERO = 1.0E-6f;
    public static final float PLOT_MARGIN = 20.0f;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final int BBOXX1 = 30;
    public static final int BBOXX2 = 550;
    public static final int BBOXY1 = 50;
    public static final int BBOXY2 = 780;
    public static final double BORDER_MARGIN = 0.93;

    PostScript(PrintStream file) {
        this.file = file;
    }

    public static int getWidth(boolean landscape) {
        int width = 0;
        width = landscape ? 730 : 520;
        return width;
    }

    public static int getHeight(boolean landscape) {
        int height = 0;
        height = landscape ? 520 : 730;
        return height;
    }

    public void psArc(float x, float y, float radius, float angle_start, float angle_end, float lineWidth, Color colour) {
        this.setRGBcolour(colour);
        x = this.convertx(x);
        y = this.converty(y);
        radius = this.convertLength(radius);
        this.writeCommand(x, y, radius, angle_start, angle_end, "Arc", 2);
    }

    public void psFilledCircle(float x, float y, float radius, Color colour) {
        this.setCircleColour(colour);
        x = this.convertx(x);
        y = this.converty(y);
        radius = this.convertLength(radius);
        this.writeCommand(x, y, radius, "Ucircle", 2);
    }

    public void psCentredText(float x, float y, float textSize, Color colour, String text) {
        x = this.convertx(x);
        y = this.converty(y);
        textSize = this.convertLength(textSize);
        this.setRGBcolour(colour);
        this.writeCommand(x, y, "moveto", 2);
        this.file.format("(%s) %s Center\n", text, this.format(textSize, 2));
        this.file.format("(%s) %s Print\n", text, this.format(textSize, 2));
    }

    public void psComment(String string) {
        this.file.format("\n", new Object[0]);
        this.file.format("%% %s\n", string);
    }

    public void psDrawDashedLine(float x1, float y1, float x2, float y2, float width, Color colour, float on, float off) {
        on = this.convertLength(on);
        off = this.convertLength(off);
        this.file.format("[ %s %s ] 0 setdash\n", this.format(on, 2), this.format(off, 2));
        this.psDrawLine(x1, y1, x2, y2, width, colour);
        this.file.format("[] 0 setdash\n", new Object[0]);
    }

    public void psEllipse(float x, float y, float width, float height, Color colour, float lineWidth, float angle) {
        float ratio = height / width;
        x = this.convertx(x);
        y = this.converty(y);
        width = this.convertLength(width);
        if (Math.abs(lineWidth = this.convertLength(lineWidth)) < 1.0E-6f) {
            lineWidth = 2.0f;
        }
        this.writeCommand(x, y, "moveto", 2);
        this.writeCommand(x, y, -angle, "RotAngle", 2);
        this.setLineWidth(lineWidth);
        this.setRGBcolour(colour);
        this.writeCommand(0.0f, 0.0f, width, 1.0f, ratio, 0.0f, 0.0f, "Oellipse", 2);
        this.file.format("R\n", new Object[0]);
    }

    public void setDashPattern(float on, float off) {
        on = this.convertLength(on);
        off = this.convertLength(off);
        if (on > 0.0f && off > 0.0f) {
            this.file.format("[ %s %s ] 0 setdash\n", this.format(on, 2), this.format(off, 2));
        } else {
            this.file.format("[] 0 setdash\n", new Object[0]);
        }
    }

    public void psDrawLine(float x1, float y1, float x2, float y2, float width, Color colour) {
        x1 = this.convertx(x1);
        y1 = this.converty(y1);
        x2 = this.convertx(x2);
        y2 = this.converty(y2);
        if (Math.abs(width = this.convertLength(width)) < 1.0E-6f) {
            width = 2.0f;
        }
        this.setLineWidth(width);
        this.setRGBcolour(colour);
        this.writeCommand(x1, y1, x2, y2, "L", 2);
    }

    public void psFillColour(Color colour) {
    }

    public void psRotate90(float new_origin_x, float new_origin_y) {
        this.file.format("\n", new Object[0]);
        this.writeCommand(new_origin_x, new_origin_y, " moveto Rot90", 1);
        this.file.format("\n", new Object[0]);
    }

    public void psSphere(float x, float y, float radius, Color colour, Color edgeColour) {
        x = this.convertx(x);
        y = this.converty(y);
        radius = this.convertLength(radius);
        this.setRGBcolour(edgeColour);
        this.setSphereColour(colour);
        this.setLineWidth(2.0f);
        this.writeCommand(x, y, radius, "Sphere", 2);
    }

    public void psUnboundedBox(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Color colour) {
        x1 = this.convertx(x1);
        y1 = this.converty(y1);
        x2 = this.convertx(x2);
        y2 = this.converty(y2);
        x3 = this.convertx(x3);
        y3 = this.converty(y3);
        x4 = this.convertx(x4);
        y4 = this.converty(y4);
        this.setLineWidth(0.0f);
        this.file.format("G\n", new Object[0]);
        this.setRGBcolour(colour);
        this.writeCommand(x1, y1, x2, y2, x3, y3, x4, y4, "Pl4", 2);
    }

    public void writeClosingLines() {
        this.file.format("%%Trailer\n", new Object[0]);
        String string = String.valueOf(29) + " " + String.valueOf(49) + " " + String.valueOf(551) + " " + String.valueOf(781);
        this.file.format("%%BoundingBox: %s\n", string);
        this.file.format("%%EOF\n", new Object[0]);
    }

    public void writeEndPage() {
        this.file.format("\n", new Object[0]);
        this.file.format("\n", new Object[0]);
        this.file.format("LigPlusSave restore\n", new Object[0]);
        this.file.format("showpage\n", new Object[0]);
    }

    public void writeMainHeaders(String plotTitle, String application, String version, String date, int npages) {
        this.file.format("%%!PS-Adobe-3.0\n", new Object[0]);
        this.file.format("%%%%Creator: " + application + " version " + version + "\n", new Object[0]);
        this.file.format("%%%%DocumentNeededResources: font Times-Roman Symbol\n", new Object[0]);
        this.file.format("%%%%BoundingBox: (atend)\n", new Object[0]);
        this.file.format("%%%%Pages: %d\n", npages);
        this.file.format("%%%%Date: %s\n", date);
        this.file.format("%%%%Title: %s\n", plotTitle);
        this.file.format("%%%%EndComments\n", new Object[0]);
        this.file.format("%%%%BeginProlog\n", new Object[0]);
        this.file.format("/L { moveto lineto stroke } bind def\n", new Object[0]);
        this.file.format("/G { gsave } bind def\n", new Object[0]);
        this.file.format("/R { grestore } bind def\n", new Object[0]);
        this.file.format("/W { setlinewidth } bind def\n", new Object[0]);
        this.file.format("/D { setdash } bind def\n", new Object[0]);
        this.file.format("/Col { setrgbcolor } bind def\n", new Object[0]);
        this.file.format("/Zero_linewidth { 0.0 } def\n", new Object[0]);
        this.file.format("/Sphcol { 1 setgray } def\n", new Object[0]);
        this.file.format("/Sphere { newpath 3 copy 0 360 arc gsave Sphcol fill 0\n", new Object[0]);
        this.file.format("          setgray 0.5 setlinewidth 3 copy 0.94 mul\n", new Object[0]);
        this.file.format("          260 350 arc stroke 3 copy 0.87 mul 275 335\n", new Object[0]);
        this.file.format("          arc stroke 3 copy 0.79 mul 295 315 arc\n", new Object[0]);
        this.file.format("          stroke 3 copy 0.8 mul 115 135 arc 3 copy\n", new Object[0]);
        this.file.format("          0.6 mul 135 115 arcn closepath gsave 1 setgray\n", new Object[0]);
        this.file.format("          fill grestore stroke 3 copy 0.7 mul 115 135\n", new Object[0]);
        this.file.format("          arc stroke 3 copy 0.6 mul 124.9 125 arc\n", new Object[0]);
        this.file.format("          0.8 mul 125 125.1 arc stroke grestore stroke\n", new Object[0]);
        this.file.format("        } bind def\n", new Object[0]);
        this.file.format("/Poly3  { moveto lineto lineto fill grestore } bind def\n", new Object[0]);
        this.file.format("/Pl3    { 6 copy Poly3 moveto moveto moveto closepath \n", new Object[0]);
        this.file.format("          stroke } bind def\n", new Object[0]);
        this.file.format("/Pline3 { 6 copy Poly3 moveto lineto lineto closepath\n", new Object[0]);
        this.file.format("          stroke } bind def\n", new Object[0]);
        this.file.format("/Poly4  { moveto lineto lineto lineto fill grestore } \n", new Object[0]);
        this.file.format("          bind def\n", new Object[0]);
        this.file.format("/Pl4    { 8 copy Poly4 moveto moveto moveto moveto \n", new Object[0]);
        this.file.format("          closepath stroke } bind def\n", new Object[0]);
        this.file.format("/Pline4 { 8 copy Poly4 moveto lineto lineto lineto\n", new Object[0]);
        this.file.format("          closepath stroke } bind def\n", new Object[0]);
        this.file.format("/Circol { 1 setgray } def\n", new Object[0]);
        this.file.format("/Circle { gsave newpath 0 360 arc gsave Circol fill \n", new Object[0]);
        this.file.format("          grestore stroke grestore } bind def\n", new Object[0]);
        this.file.format("/Ocircle { gsave newpath 0 360 arc stroke grestore } bind def \n", new Object[0]);
        this.file.format("/Ucircle { gsave newpath 0 360 arc gsave Circol fill \n", new Object[0]);
        this.file.format("           grestore grestore } bind def\n", new Object[0]);
        this.file.format("/Arc    { newpath arc stroke newpath } bind def\n", new Object[0]);
        this.file.format("/Ellipse { gsave translate scale Circle grestore } ", new Object[0]);
        this.file.format("bind def\n", new Object[0]);
        this.file.format("/Oellipse { gsave translate scale Ocircle grestore } ", new Object[0]);
        this.file.format("bind def\n", new Object[0]);
        this.file.format("/Print  { /Times-Roman findfont exch scalefont setfont\n", new Object[0]);
        this.file.format("          show } bind def\n", new Object[0]);
        this.file.format("/Gprint { /Symbol findfont exch scalefont setfont show\n", new Object[0]);
        this.file.format("          } bind def\n", new Object[0]);
        this.file.format("/Center { dup /Times-Roman findfont exch scalefont\n", new Object[0]);
        this.file.format("          setfont exch stringwidth pop -2 div exch -3\n", new Object[0]);
        this.file.format("          div rmoveto } bind def\n", new Object[0]);
        this.file.format("/CenterRot90 {\n", new Object[0]);
        this.file.format("          dup /Times-Roman findfont exch scalefont\n", new Object[0]);
        this.file.format("          setfont exch stringwidth pop -2 div exch 3\n", new Object[0]);
        this.file.format("          div exch rmoveto } bind def\n", new Object[0]);
        this.file.format("/UncenterRot90 {\n", new Object[0]);
        this.file.format("          dup /Times-Roman findfont exch scalefont\n", new Object[0]);
        this.file.format("          setfont exch stringwidth } bind def\n", new Object[0]);
        this.file.format("/Rot90  { gsave currentpoint translate 90 rotate }\n", new Object[0]);
        this.file.format("          bind def\n", new Object[0]);
        this.file.format("/RotAngle  { gsave currentpoint translate rotate } bind def\n", new Object[0]);
        this.file.format("%%%%EndProlog\n", new Object[0]);
        this.file.format("%%%%BeginSetup\n", new Object[0]);
        this.file.format("1 setlinecap 1 setlinejoin 1 setlinewidth 0 setgray\n", new Object[0]);
        this.file.format(" [ ] 0 setdash newpath\n", new Object[0]);
        this.file.format("%%%%EndSetup\n", new Object[0]);
    }

    public void writePageHeaders(int page, int npages, Color bgColour) {
        this.file.format("%%%%Page: p%d %d\n", page, page);
        this.file.format("/LigPlusSave save def\n", new Object[0]);
        String string = String.valueOf((float)xx1) + " " + String.valueOf((float)xy1) + " moveto " + String.valueOf((float)xx2) + " " + String.valueOf((float)xy1) + " lineto " + String.valueOf((float)xx2) + " " + String.valueOf((float)xy2) + " lineto ";
        this.file.format("%s\n", string);
        string = String.valueOf((float)xx1) + " " + String.valueOf((float)xy2) + " lineto closepath";
        this.file.format("%s\n", string);
        this.file.format("gsave 1.0000 setgray fill grestore\n", new Object[0]);
        this.file.format("stroke gsave\n", new Object[0]);
        this.psComment("Background\n");
        this.setRGBcolour(bgColour);
        this.writeCommand(30.0f, 50.0f, 550.0f, 50.0f, 550.0f, 780.0f, 30.0f, 780.0f, "Pl4", 2);
        this.lastColour = null;
        this.setLineWidth(2.0f);
    }

    public void writeLandscape() {
        this.psComment("Landscape orientation\n");
        this.psRotate90(580.0f, 0.0f);
    }

    public float convertLength(float length) {
        return length;
    }

    public float convertx(float x) {
        return x + 30.0f;
    }

    public float converty(float y) {
        return y + 50.0f;
    }

    private String format(float x, int nDecimals) {
        DecimalFormat number = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols symbols = number.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        number.setDecimalFormatSymbols(symbols);
        number.setMaximumFractionDigits(nDecimals);
        number.setGroupingUsed(false);
        return number.format(x);
    }

    private void getLandscapeHeight() {
        pageMinx = 50.0f;
        pageMaxx = 780.0f;
    }

    private void setLineWidth(float lineWidth) {
        if (lineWidth != this.lastLineWidth) {
            this.writeCommand(lineWidth, "W", 2);
        }
        this.lastLineWidth = lineWidth;
    }

    private void setCircleColour(Color colour) {
        if (colour != this.lastCircleColour) {
            float red = (float)colour.getRed() / 255.0f;
            float green = (float)colour.getGreen() / 255.0f;
            float blue = (float)colour.getBlue() / 255.0f;
            this.file.format("/Circol { " + this.format(red, 4) + " " + this.format(green, 4) + " " + this.format(blue, 4) + " setrgbcolor } def\n", new Object[0]);
        }
        this.lastCircleColour = colour;
    }

    private void setRGBcolour(Color colour) {
        if (colour != this.lastColour) {
            float red = (float)colour.getRed() / 255.0f;
            float green = (float)colour.getGreen() / 255.0f;
            float blue = (float)colour.getBlue() / 255.0f;
            this.writeCommand(red, green, blue, "setrgbcolor", 4);
        }
        this.lastColour = colour;
    }

    private void setSphereColour(Color colour) {
        if (colour != this.lastSphereColour) {
            float red = (float)colour.getRed() / 255.0f;
            float green = (float)colour.getGreen() / 255.0f;
            float blue = (float)colour.getBlue() / 255.0f;
            this.file.format("/Sphcol { " + this.format(red, 4) + " " + this.format(green, 4) + " " + this.format(blue, 4) + " setrgbcolor } def\n", new Object[0]);
        }
        this.lastSphereColour = colour;
    }

    private void writeCommand(float x, String command, int nDecimals) {
        String string = this.format(x, nDecimals) + " " + command;
        this.file.format("%s\n", string);
    }

    private void writeCommand(float x, float y, String command, int nDecimals) {
        String string = this.format(x, nDecimals) + " " + this.format(y, nDecimals) + " " + command;
        this.file.format("%s\n", string);
    }

    private void writeCommand(float x, float y, float z, String command, int nDecimals) {
        String string = this.format(x, nDecimals) + " " + this.format(y, nDecimals) + " " + this.format(z, nDecimals) + " " + command;
        this.file.format("%s\n", string);
    }

    private void writeCommand(float x1, float y1, float x2, float y2, String command, int nDecimals) {
        String string = this.format(x1, nDecimals) + " " + this.format(y1, nDecimals) + " " + this.format(x2, nDecimals) + " " + this.format(y2, nDecimals) + " " + command;
        this.file.format("%s\n", string);
    }

    private void writeCommand(float x1, float y1, float x2, float y2, float z, String command, int nDecimals) {
        String string = this.format(x1, nDecimals) + " " + this.format(y1, nDecimals) + " " + this.format(x2, nDecimals) + " " + this.format(y2, nDecimals) + " " + this.format(z, nDecimals) + " " + command;
        this.file.format("%s\n", string);
    }

    private void writeCommand(float f, float f0, float radius, float elongX, float elongY, float x, float y, String command, int nDecimals) {
        String string = this.format(f, nDecimals) + " " + this.format(f0, nDecimals) + " " + this.format(radius, nDecimals) + " " + this.format(elongX, nDecimals) + " " + this.format(elongY, nDecimals) + " " + this.format(x, nDecimals) + " " + this.format(y, nDecimals) + " " + command;
        this.file.format("%s\n", string);
    }

    private void writeCommand(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, String command, int nDecimals) {
        String string = this.format(x1, nDecimals) + " " + this.format(y1, nDecimals) + " " + this.format(x2, nDecimals) + " " + this.format(y2, nDecimals) + " " + this.format(x3, nDecimals) + " " + this.format(y3, nDecimals) + " " + this.format(x4, nDecimals) + " " + this.format(y4, nDecimals) + " " + command;
        this.file.format("%s\n", string);
    }
}

