/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.actions;

import bbk.dng.Constants;
import bbk.dng.Main;
import bbk.dng.actions.SearchPanelActions;
import bbk.dng.actions.WritePSFile;
import bbk.dng.graph.CustomizedForceDirectedLayout;
import bbk.dng.graph.PrintUtilities;
import bbk.dng.graph.RenderingCountdown;
import bbk.dng.ui.panels.AppFrame;
import bbk.dng.utils.CollectionUtils;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import prefuse.Visualization;
import prefuse.data.Edge;
import prefuse.data.Node;
import prefuse.data.tuple.TupleSet;
import prefuse.util.ColorLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class GraphStylePanelActions {
    public static final String DOMAINS_ONLY = "domains_only";
    public static final String ADD_SEQUENCES = "add_sequences";
    public static final String ADD_STRUCTURES = "add_structures";
    public static final String ADD_ENZYMES = "add_enzymes";
    private static GraphStylePanelActions instance;
    private String showNodesStatus = "domains_only";
    private String graphRenderingStatus = "running";
    private static String currentDirectory;
    private static File currentFile;
    private AppFrame appFrame;

    private GraphStylePanelActions() {
    }

    public static GraphStylePanelActions getInstance() {
        return instance == null ? (instance = new GraphStylePanelActions()) : instance;
    }

    public void toggleGraphAction(AppFrame appFrame) {
        if (this.graphRenderingStatus.equals("running")) {
            this.stopGraph(appFrame);
        } else {
            appFrame.getGraphPanel().zoomToFit(appFrame.getGraphPanel().getVisualization());
            appFrame.getGraphPanel().getActionLayout().setDuration(-1L);
            appFrame.getGraphPanel().getActionLayout().run();
            this.graphRenderingStatus = "running";
            appFrame.getGraphStylePanel().getGraphRenderButton().setText("Freeze Graph");
        }
    }

    public void saveGraphImageAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSequenceNodes(final AppFrame appFrame, String nodeType) {
        String splitChar = ",";
        int node = 0;
        if (nodeType.equals("pdb_codes")) {
            splitChar = ":";
            node = 1;
        } else if (nodeType.equals("enzymes")) {
            splitChar = ":";
            node = 2;
        }
        int defaultColour = ColorLib.rgb(Constants.NODE_COLOUR[node][0][0], Constants.NODE_COLOUR[node][0][1], Constants.NODE_COLOUR[node][0][2]);
        TupleSet ts = appFrame.getGraphPanel().getVisualization().getGroup("graph.nodes");
        Iterator iter = ts.tuples();
        while (iter.hasNext()) {
            NodeItem connectorNodeItem = (NodeItem)iter.next();
            Node connectorNode = (Node)connectorNodeItem.getSourceTuple();
            int nSeqs = Integer.parseInt(connectorNode.getString("nseqs"));
            Map<String, Integer> ecStub = CollectionUtils.newMap();
            if (connectorNode.getString("name").equals(connectorNode.getString(nodeType))) continue;
            double connectorX = connectorNodeItem.getX();
            double connectorY = connectorNodeItem.getY();
            Visualization visualization = appFrame.getGraphPanel().getVisualization();
            synchronized (visualization) {
                String nodeString = connectorNode.getString(nodeType);
                if (nodeString != null && nodeString.length() > 0) {
                    int colour = defaultColour;
                    int count = 0;
                    String storedSeqs = "";
                    for (String s : nodeString.split(splitChar)) {
                        String sString;
                        if (node == 2) {
                            String string = s;
                            int iPos = s.indexOf(" (");
                            if (iPos > -1) {
                                string = s.substring(0, iPos);
                            }
                            for (int i = 0; i < 3; ++i) {
                                int lPos = string.lastIndexOf(46);
                                if (lPos <= -1) continue;
                                String stub = string.substring(0, lPos);
                                if (ecStub.containsKey(stub)) {
                                    int nStub = (Integer)ecStub.get(stub);
                                    ecStub.put(stub, ++nStub);
                                } else {
                                    ecStub.put(stub, 1);
                                }
                                string = stub;
                            }
                        }
                        if (storedSeqs.indexOf(sString = splitChar + s + splitChar) != -1) continue;
                        storedSeqs = storedSeqs + sString;
                        ++count;
                    }
                    int nTotal = nSeqs;
                    if (node == 1) {
                        nTotal = count;
                    }
                    colour = this.getNodeColour(node, node, nTotal);
                    count = 0;
                    for (String s : storedSeqs.split(splitChar)) {
                        if (s.length() > 0 && node == 2) {
                            int dotPos = s.indexOf(".");
                            if (dotPos > -1) {
                                int ecClass = Integer.parseInt(s.substring(0, 1));
                                if (s.contains(",")) {
                                    ecClass = this.checkMultipleClass(s, ecClass, s.substring(0, 1));
                                }
                                if (ecClass > 0 && ecClass < 7) {
                                    String numberString;
                                    int iCol = ecClass + 1;
                                    int eSeqs = 1;
                                    int iPos = s.indexOf(40);
                                    if (iPos > -1 && (iPos = (numberString = s.substring(iPos + 1)).indexOf("seq")) > -1) {
                                        numberString = numberString.substring(0, iPos);
                                        eSeqs = Integer.parseInt(numberString);
                                    }
                                    colour = this.getNodeColour(node, iCol, eSeqs);
                                } else {
                                    colour = ColorLib.rgb(255, 255, 255);
                                }
                            } else {
                                int spacePos = s.indexOf(" ");
                                String numberString = spacePos > -1 ? s.substring(0, spacePos) : s;
                                int ssgClass = Integer.parseInt(numberString);
                                if (ssgClass > -1 && ssgClass < 45) {
                                    int iCol = ssgClass % 45;
                                    String rgbString = Constants.COLOUR_DEFN[iCol][2];
                                    String[] rgbVals = rgbString.split("\\s");
                                    int[] rgb = new int[3];
                                    int i = 0;
                                    for (String ival : rgbVals) {
                                        rgb[i] = Integer.parseInt(ival);
                                        ++i;
                                    }
                                    colour = ColorLib.rgb(rgb[0], rgb[1], rgb[2]);
                                } else {
                                    colour = ColorLib.rgb(255, 255, 255);
                                }
                            }
                        }
                        if (s.length() <= 0 || count >= 50) continue;
                        if (node == 2) {
                            // empty if block
                        }
                        Node aNode = Main.graph.addNode();
                        aNode.setString("name", s);
                        aNode.setString("label", s);
                        aNode.setString("type", nodeType);
                        aNode.setString("sequences", s);
                        aNode.setBoolean("parent", false);
                        Edge e = Main.graph.addEdge(connectorNode, aNode);
                        e.setString("name", "sequence");
                        VisualItem aNodeItem = appFrame.getGraphPanel().getVisualization().getVisualItem("graph", aNode);
                        aNodeItem.setFillColor(colour);
                        PrefuseLib.setX(aNodeItem, null, connectorX);
                        PrefuseLib.setY(aNodeItem, null, connectorY);
                        ++count;
                    }
                }
            }
        }
        boolean enzymesOn = appFrame.getGraphStylePanel().getAddEnzymesRadioButton().isSelected();
        if (!enzymesOn) {
            appFrame.getDataPane().setText(SearchPanelActions.getInstance().getMasterText());
        } else {
            appFrame.getDataPane().setText(SearchPanelActions.getInstance().getEnzymesText());
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                appFrame.getDataScrollPane().getVerticalScrollBar().setValue(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSequenceNodes(AppFrame appFrame, String nodeType) {
        TupleSet ts = appFrame.getGraphPanel().getVisualization().getGroup("graph.nodes");
        Iterator iter = ts.tuples();
        while (iter.hasNext()) {
            NodeItem connectorNodeItem = (NodeItem)iter.next();
            Node connectorNode = (Node)connectorNodeItem.getSourceTuple();
            if (!connectorNode.getString("name").equals(connectorNode.getString(nodeType))) continue;
            Visualization visualization = appFrame.getGraphPanel().getVisualization();
            synchronized (visualization) {
                Iterator edges = connectorNode.edges();
                while (edges.hasNext()) {
                    Edge edge = (Edge)edges.next();
                    Main.graph.removeEdge(edge);
                }
                Main.graph.removeNode(connectorNode);
            }
        }
    }

    public DomainsOnlyRadioButtonListener getDomainsOnlyRadioButtonListener(AppFrame appFrame) {
        return new DomainsOnlyRadioButtonListener(appFrame);
    }

    public AddSequencesRadioButtonListener getAddSequencesRadioButtonListener(AppFrame appFrame) {
        return new AddSequencesRadioButtonListener(appFrame);
    }

    public AddStructuresRadioButtonListener getAddStructuresRadioButtonListener(AppFrame appFrame) {
        return new AddStructuresRadioButtonListener(appFrame);
    }

    public AddEnzymesRadioButtonListener getAddEnzymesRadioButtonListener(AppFrame appFrame) {
        return new AddEnzymesRadioButtonListener(appFrame);
    }

    public SpringLengthChangeListener getSpringLengthChangeListener(AppFrame appFrame) {
        return new SpringLengthChangeListener(appFrame);
    }

    public ConnectionFilterChangeListener getConnectionFilterChangeListener(AppFrame appFrame) {
        return new ConnectionFilterChangeListener(appFrame);
    }

    public int getNodeColour(int node, int iCol, int nSeqs) {
        int colour = ColorLib.rgb(255, 255, 255);
        int[] rgb = new int[3];
        if ((node == 0 || node == 1) && nSeqs <= Constants.NSEQS_RANGE[node][0]) {
            for (int irgb = 0; irgb < 3; ++irgb) {
                rgb[irgb] = Constants.NODE_COLOUR[iCol][0][irgb];
            }
        } else {
            double factor = 0.0;
            if (nSeqs > Constants.NSEQS_RANGE[node][1]) {
                factor = 1.0;
            } else if (nSeqs > Constants.NSEQS_RANGE[node][0]) {
                factor = (double)(nSeqs - Constants.NSEQS_RANGE[node][0]) / (double)(Constants.NSEQS_RANGE[node][1] - Constants.NSEQS_RANGE[node][0]);
            }
            for (int irgb = 0; irgb < 3; ++irgb) {
                rgb[irgb] = Constants.NODE_COLOUR[iCol][1][irgb] + (int)(factor * (double)(Constants.NODE_COLOUR[iCol][2][irgb] - Constants.NODE_COLOUR[iCol][1][irgb]));
            }
        }
        colour = ColorLib.rgb(rgb[0], rgb[1], rgb[2]);
        return colour;
    }

    public void printGraphAction(AppFrame appFrame) {
        this.stopGraph(appFrame);
        PrintUtilities.printComponent(appFrame.getGraphPanel());
    }

    public void writePostScriptAction(AppFrame appFrame, boolean useCATH) {
        boolean landscape = false;
        this.stopGraph(appFrame);
        File file = this.getPostScriptOutputFile(appFrame);
        if (file == null) {
            return;
        }
        Object[] options = new Object[]{"Portrait", "Landscape", "Cancel"};
        int n = JOptionPane.showOptionDialog(appFrame, "Choose orientation for PostScript plot", "PostScript orientation", 1, 3, null, options, options[0]);
        boolean cancelled = false;
        if (n == 0) {
            landscape = false;
        } else if (n == 1) {
            landscape = true;
        } else {
            cancelled = n == 2 ? true : true;
        }
        if (!cancelled) {
            System.out.println("Writing PostScript file to: " + file.getPath());
            boolean writeError = false;
            try {
                Map<String, Integer> domainColour = SearchPanelActions.getInstance().getDomainColour();
                WritePSFile writePS = new WritePSFile(file.getPath(), appFrame, useCATH, landscape);
                if (writePS.getOK()) {
                    JOptionPane.showMessageDialog(appFrame, "PostScript file written to disk", "File written", 1);
                } else {
                    writeError = true;
                }
            }
            catch (IOException error) {
                writeError = true;
            }
            if (writeError) {
                JOptionPane.showMessageDialog(appFrame, "<html>Error writing PostScript file<p>" + file.getPath(), "Write error", 0);
            }
        }
    }

    private Rectangle getNodeBounds(VisualItem item, String domainSeparator) {
        int aType = 1;
        if (item.getSourceTuple().getBoolean("parent")) {
            aType = 0;
        }
        String[] arches = item.getSourceTuple().getString("name").split(domainSeparator);
        int archCount = arches.length;
        double boxWidth = 2.0 * Constants.xMargin[aType] + Constants.recWidth[aType] * (double)archCount + Constants.gap[aType] * (double)(archCount - 1);
        double x = item.getX() - boxWidth / 2.0;
        double y = item.getY();
        double height = Constants.pfamAHeight[aType];
        String coverage = item.getSourceTuple().getString("3D_coverage");
        if (coverage != null && !coverage.equals("NONE")) {
            height += Constants.extraForCoverage[aType];
        }
        return new Rectangle((int)x, (int)(y - height / 2.0 - Constants.yMargin[aType]), (int)boxWidth, (int)(height + 2.0 * Constants.yMargin[aType]));
    }

    private File getPostScriptOutputFile(AppFrame appFrame) {
        boolean done = false;
        boolean writeFile = false;
        File file = null;
        while (!done) {
            file = this.getFileName(appFrame);
            if (file == null) {
                return null;
            }
            String fileName = file.getPath();
            if (!fileName.endsWith(".ps")) {
                fileName = fileName + ".ps";
                file = new File(fileName);
            }
            if (file != null && file.exists()) {
                Object[] options = new Object[]{"Yes", "No", "Cancel"};
                int n = JOptionPane.showOptionDialog(appFrame, "File already exists. Do you want to overwrite it?", "File exists", 1, 3, null, options, options[1]);
                if (n == 0) {
                    done = true;
                    writeFile = true;
                    continue;
                }
                if (n == 1) {
                    done = false;
                    writeFile = false;
                    continue;
                }
                if (n == 2) {
                    done = true;
                    writeFile = false;
                    continue;
                }
                done = true;
                writeFile = false;
                continue;
            }
            if (file != null) {
                done = true;
                writeFile = true;
                continue;
            }
            done = true;
        }
        if (!writeFile) {
            file = null;
        }
        return file;
    }

    private File getFileName(AppFrame appFrame) {
        File file = null;
        Cursor cursor = new Cursor(3);
        appFrame.setCursor(cursor);
        FileSystemView fsv = FileSystemView.getFileSystemView();
        JFileChooser fc = new JFileChooser(currentDirectory, fsv);
        fc.setFileSelectionMode(2);
        FileNameExtensionFilter drwFilter = new FileNameExtensionFilter("PostScript files (*.ps)", "ps");
        fc.addChoosableFileFilter(drwFilter);
        fc.setDialogType(1);
        String label = "Save";
        if (currentFile != null) {
            fc.setSelectedFile(currentFile);
        }
        int returnVal = fc.showDialog(appFrame, label);
        appFrame.setCursor(Cursor.getPredefinedCursor(0));
        if (returnVal == 0) {
            file = fc.getSelectedFile();
            String fileName = file.getName();
            String fullName = file.getPath();
            currentDirectory = file.getParent();
            currentFile = file;
            System.out.println("Opening: " + fullName);
            System.out.println("File name: " + fileName);
            System.out.println("Directory: " + currentDirectory);
        } else {
            System.out.println("Open command cancelled by user.");
        }
        return file;
    }

    private void stopGraph(AppFrame appFrame) {
        appFrame.getGraphPanel().getActionLayout().setDuration(1000L);
        appFrame.getGraphStylePanel().getGraphRenderButton().setText("Plot Graph");
        this.graphRenderingStatus = "stopped";
        appFrame.getGraphPanel().zoomToFit(appFrame.getGraphPanel().getVisualization());
    }

    private int checkMultipleClass(String ecNumbers, int ecClass, String currentClass) {
        for (String s : ecNumbers.split(" ")) {
            String firstChar = s.substring(0, 1);
            if (firstChar.equals(currentClass) || firstChar.equals("(")) continue;
            ecClass = 0;
        }
        return ecClass;
    }

    public void AddRemoveSelectedNodes(AppFrame appFrame, String selected, boolean offLine) {
        if (this.showNodesStatus.equals(ADD_SEQUENCES) || this.showNodesStatus.equals(ADD_STRUCTURES) || this.showNodesStatus.equals(ADD_ENZYMES)) {
            GraphStylePanelActions.getInstance().removeSequenceNodes(appFrame, "sequences");
        }
        if (selected.equals(ADD_SEQUENCES)) {
            GraphStylePanelActions.getInstance().addSequenceNodes(appFrame, "sequences");
            this.resetEdgeLengthSlider(appFrame, 40);
        } else if (selected.equals(ADD_STRUCTURES)) {
            GraphStylePanelActions.getInstance().addSequenceNodes(appFrame, "pdb_codes");
            this.resetEdgeLengthSlider(appFrame, 20);
        } else if (selected.equals(ADD_ENZYMES)) {
            GraphStylePanelActions.getInstance().addSequenceNodes(appFrame, "enzymes");
            this.resetEdgeLengthSlider(appFrame, 50);
        } else {
            this.resetEdgeLengthSlider(appFrame, 20);
        }
        this.showNodesStatus = selected;
        if (this.graphRenderingStatus.equals("stopped")) {
            this.toggleGraphAction(appFrame);
        }
        if (!offLine) {
            Thread t = new Thread(new RenderingCountdown(appFrame));
            t.start();
        }
    }

    public void changeForceFactor(AppFrame appFrame, int factor) {
        CustomizedForceDirectedLayout force = (CustomizedForceDirectedLayout)appFrame.getGraphPanel().getActionLayout().get(1);
        force.setFactor(factor);
    }

    public String getGraphRenderingStatus() {
        return this.graphRenderingStatus;
    }

    private void resetEdgeLengthSlider(AppFrame appFrame, int factor) {
        JSlider edgeLengthSlider = appFrame.getGraphStylePanel().getEdgeLengthSlider();
        edgeLengthSlider.setValue(factor);
    }

    static {
        currentDirectory = ".";
        currentFile = null;
    }

    private class ConnectionFilterChangeListener
    implements ChangeListener {
        private AppFrame appFrame;

        ConnectionFilterChangeListener(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        public void stateChanged(ChangeEvent e) {
            JSlider s = (JSlider)e.getSource();
            this.appFrame.getGraphPanel().getFilter().setDistance(s.getValue());
            this.appFrame.getGraphPanel().getVisualization().runAfter("draw", "layout");
            if (GraphStylePanelActions.this.graphRenderingStatus.equals("stopped")) {
                GraphStylePanelActions.this.toggleGraphAction(this.appFrame);
            }
            Thread t = new Thread(new RenderingCountdown(this.appFrame));
            t.start();
        }
    }

    private class SpringLengthChangeListener
    implements ChangeListener {
        private AppFrame appFrame;

        SpringLengthChangeListener(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        public void stateChanged(ChangeEvent e) {
            JSlider s = (JSlider)e.getSource();
            GraphStylePanelActions.this.changeForceFactor(this.appFrame, s.getValue());
            if (GraphStylePanelActions.this.graphRenderingStatus.equals("stopped")) {
                GraphStylePanelActions.this.toggleGraphAction(this.appFrame);
            }
            Thread t = new Thread(new RenderingCountdown(this.appFrame));
            t.start();
        }
    }

    private class AddEnzymesRadioButtonListener
    implements ItemListener {
        private AppFrame appFrame;

        AddEnzymesRadioButtonListener(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GraphStylePanelActions.this.AddRemoveSelectedNodes(this.appFrame, GraphStylePanelActions.ADD_ENZYMES, false);
            }
        }
    }

    private class AddStructuresRadioButtonListener
    implements ItemListener {
        private AppFrame appFrame;

        AddStructuresRadioButtonListener(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GraphStylePanelActions.this.AddRemoveSelectedNodes(this.appFrame, GraphStylePanelActions.ADD_STRUCTURES, false);
            }
        }
    }

    private class AddSequencesRadioButtonListener
    implements ItemListener {
        private AppFrame appFrame;

        AddSequencesRadioButtonListener(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GraphStylePanelActions.this.AddRemoveSelectedNodes(this.appFrame, GraphStylePanelActions.ADD_SEQUENCES, false);
            }
        }
    }

    private class DomainsOnlyRadioButtonListener
    implements ItemListener {
        private AppFrame appFrame;

        DomainsOnlyRadioButtonListener(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                GraphStylePanelActions.this.AddRemoveSelectedNodes(this.appFrame, GraphStylePanelActions.DOMAINS_ONLY, false);
            }
        }
    }
}

