/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng.actions;

import bbk.dng.actions.SearchPanelActions;
import bbk.dng.data.index.SwissPfamSearcher;
import bbk.dng.ui.panels.AppFrame;
import bbk.dng.utils.CollectionUtils;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.controls.FocusControl;
import prefuse.data.tuple.TupleSet;
import prefuse.visual.VisualItem;

public class GraphActions {
    private static GraphActions instance;

    private GraphActions() {
    }

    public static GraphActions getInstance() {
        return instance == null ? (instance = new GraphActions()) : instance;
    }

    public GraphNodeClickControlAdapter getGraphNodeClickControlAdapter(AppFrame appFrame, SwissPfamSearcher searcher, boolean useCATH) {
        return new GraphNodeClickControlAdapter(appFrame, searcher, useCATH);
    }

    public GraphBackgroundClickFocus getGraphBackgroundClickFocus(AppFrame appFrame) {
        return new GraphBackgroundClickFocus(appFrame);
    }

    private class GraphBackgroundClickFocus
    extends FocusControl {
        private AppFrame appFrame;

        GraphBackgroundClickFocus(AppFrame appFrame) {
            super(2);
            this.appFrame = appFrame;
        }

        public void mouseClicked(MouseEvent event) {
            Visualization vis = ((Display)event.getSource()).getVisualization();
            if (event.getButton() == 2) {
                this.appFrame.getGraphPanel().panToParent(vis);
                return;
            }
            if (event.getButton() != 1 || event.getClickCount() != this.ccount) {
                return;
            }
            this.curFocus = null;
            TupleSet ts = vis.getFocusGroup(Visualization.FOCUS_ITEMS);
            ts.clear();
            if (this.activity != null) {
                vis.run(this.activity);
            }
            this.appFrame.getDataPane().setAutoscrolls(false);
            boolean enzymesOn = this.appFrame.getGraphStylePanel().getAddEnzymesRadioButton().isSelected();
            if (!enzymesOn) {
                this.appFrame.getDataPane().setText(SearchPanelActions.getInstance().getMasterText());
            } else {
                this.appFrame.getDataPane().setText(SearchPanelActions.getInstance().getEnzymesText());
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    GraphBackgroundClickFocus.this.appFrame.getDataScrollPane().getVerticalScrollBar().setValue(0);
                }
            });
        }
    }

    private class GraphNodeClickControlAdapter
    extends ControlAdapter {
        private AppFrame appFrame;
        private boolean useCATH;
        private SwissPfamSearcher searcher;

        GraphNodeClickControlAdapter(AppFrame appFrame, SwissPfamSearcher searcher, boolean useCATH) {
            this.appFrame = appFrame;
            this.searcher = searcher;
            this.useCATH = useCATH;
        }

        public void itemClicked(VisualItem item, MouseEvent event) {
            if (event.getClickCount() != 2) {
                if (event.getClickCount() == 1 && !item.getString("name").equals(item.getString("sequences"))) {
                    StringBuilder sb = new StringBuilder();
                    if (!item.getString("name").equals(item.getString("sequences"))) {
                        sb.append("<html>").append("<head><style type=\"text/css\">\nbody { font-size: 12pt; font-family: sans-serif }\n</style><head>").append("<body>");
                        String architecture = item.getString("name");
                        String[] nodeDomains = item.getString("name").split(SearchPanelActions.getInstance().getDomainSeparator());
                        List<String> entries = CollectionUtils.newList();
                        for (String d : nodeDomains) {
                            entries.add(d);
                        }
                        String nodeType = "any";
                        if (item.getString("name").equals(SearchPanelActions.getInstance().getParentArchitecture())) {
                            nodeType = "parent";
                        }
                        Map<String, Integer> domainColour = SearchPanelActions.getInstance().getDomainColour();
                        String coverage = SearchPanelActions.getInstance().getCoverage(architecture);
                        sb = SearchPanelActions.getInstance().addSpacer(sb, 1, 6);
                        sb.append("<table cellpadding=0 cellspacing=0>");
                        sb.append("<tr>");
                        sb.append("<td>&nbsp;&nbsp;</td>");
                        sb.append("<td><b>Selected architecture:</b></td>");
                        sb.append("<td>&nbsp;&nbsp;</td>");
                        sb.append("<td>");
                        sb = SearchPanelActions.getInstance().nodeDomainsTable(sb, nodeDomains, coverage, domainColour, nodeType);
                        sb.append("</td>");
                        sb.append("<td>&nbsp;&nbsp;</td>");
                        sb = SearchPanelActions.getInstance().newSearchIcon(sb, architecture, this.useCATH);
                        sb.append("</tr>");
                        sb.append("</table>");
                        sb = SearchPanelActions.getInstance().addSpacer(sb, 1, 10);
                        sb = SearchPanelActions.getInstance().showDomainList(sb, entries, null, null, domainColour);
                        sb = SearchPanelActions.getInstance().addSpacer(sb, 1, 10);
                        String[] seq = item.getString("sequences").split(",");
                        sb = SearchPanelActions.getInstance().showSequencesList(sb, architecture);
                        sb.append("</p></body></html>");
                        int buttonPressed = event.getButton();
                        int buttonModifiers = event.getModifiers();
                        boolean shiftPressed = false;
                        String modifiers = MouseEvent.getMouseModifiersText(buttonModifiers).toUpperCase();
                        if (modifiers.indexOf("SHIFT") > -1) {
                            shiftPressed = true;
                        }
                        if (buttonPressed == 1 && shiftPressed) {
                            Visualization vis = ((Display)event.getSource()).getVisualization();
                            this.appFrame.getGraphPanel().tracePathToParent(vis, item, architecture, this.useCATH);
                        }
                    }
                    this.appFrame.getDataPane().setAutoscrolls(false);
                    this.appFrame.getDataPane().setText(sb.toString());
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            GraphNodeClickControlAdapter.this.appFrame.getDataScrollPane().getVerticalScrollBar().setValue(0);
                        }
                    });
                } else if (event.getClickCount() == 1 && item.getString("name").equals(item.getString("sequences"))) {
                    String URL2 = null;
                    if (item.getString("type").equalsIgnoreCase("pdb_codes")) {
                        String pdbCode = item.getString("name").substring(0, 4);
                        URL2 = "https://www.ebi.ac.uk/pdbsum/" + pdbCode;
                    } else if (item.getString("type").equalsIgnoreCase("sequences")) {
                        String seqId = item.getString("name");
                        URL2 = "https://www.uniprot.org/uniprot/" + seqId;
                    } else if (item.getString("type").equalsIgnoreCase("enzymes")) {
                        String label = item.getString("name") + " ";
                        String ecNumber = "";
                        boolean done = false;
                        int level = 0;
                        int len = label.length();
                        String numberString = "";
                        for (int ipos = 0; !done && ipos < len; ++ipos) {
                            char ch = label.charAt(ipos);
                            if (ch >= '0' && ch <= '9') {
                                numberString = numberString + ch;
                                continue;
                            }
                            if (!numberString.equalsIgnoreCase("")) {
                                if (level > 0) {
                                    ecNumber = ecNumber + ".";
                                }
                                ecNumber = ecNumber + numberString;
                                numberString = "";
                                ++level;
                            }
                            if (ch == '.') continue;
                            done = true;
                        }
                        URL2 = "https://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/enzymes/GetPage.pl?ec_number=" + ecNumber;
                    }
                    if (URL2 != null) {
                        try {
                            BrowserLauncher bl = new BrowserLauncher();
                            bl.openURLinBrowser(URL2);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

