/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng;

public class SimpleThreads {
    static void threadMessage(String message) {
        String threadName = Thread.currentThread().getName();
        System.out.format("%s: %s%n", threadName, message);
    }

    public static void main(String[] args) throws InterruptedException {
        long patience = 3600000L;
        if (args.length > 0) {
            try {
                patience = Long.parseLong(args[0]) * 1000L;
            }
            catch (NumberFormatException e) {
                System.err.println("Argument must be an integer.");
                System.exit(1);
            }
        }
        SimpleThreads.threadMessage("Starting MessageLoop thread");
        long startTime = System.currentTimeMillis();
        Thread t = new Thread(new MessageLoop());
        t.start();
        SimpleThreads.threadMessage("Waiting for MessageLoop thread to finish");
        while (t.isAlive()) {
            SimpleThreads.threadMessage("Still waiting...");
            t.join(1000L);
            if (System.currentTimeMillis() - startTime <= patience || !t.isAlive()) continue;
            SimpleThreads.threadMessage("Tired of waiting!");
            t.interrupt();
            t.join();
        }
        SimpleThreads.threadMessage("Finally!");
    }

    private static class MessageLoop
    implements Runnable {
        private MessageLoop() {
        }

        public void run() {
            String[] importantInfo = new String[]{"Mares eat oats", "Does eat oats", "Little lambs eat ivy", "A kid will eat ivy too"};
            try {
                for (int i = 0; i < importantInfo.length; ++i) {
                    Thread.sleep(4000L);
                    SimpleThreads.threadMessage(importantInfo[i]);
                }
            }
            catch (InterruptedException e) {
                SimpleThreads.threadMessage("I wasn't done!");
            }
        }
    }
}

