/*
 * Decompiled with CFR 0.152.
 */
package bbk.dng;

import bbk.dng.actions.DataPaneActions;
import bbk.dng.actions.GraphActions;
import bbk.dng.actions.GraphStylePanelActions;
import bbk.dng.actions.SearchPanelActions;
import bbk.dng.data.index.SwissPfamSearcher;
import bbk.dng.ui.panels.AppFrame;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.EventQueue;
import java.net.URL;
import javax.swing.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import prefuse.data.Graph;

public class Main
extends SingleFrameApplication {
    private SwissPfamSearcher searcher;
    private AppFrame appFrame;
    public static boolean useCATH = false;
    public static boolean useSSG = false;
    public static boolean offLine = false;
    public static boolean addEnzymes = false;
    public static Graph graph;
    public static String pfamId;
    public static String seqId;
    public static String userId;
    public static URL imgURL;
    public static int nDomains;
    public static int nSeqs;
    public static int domainType;
    public static final int START_SCREEN = 0;
    public static final int SEARCH_SCREEN = 1;
    public static final int MANY_SEQUENCES = 2;
    public static final int SELECT_DOMAINS = 3;

    public static void main(String[] args) {
        Application.launch(Main.class, args);
    }

    protected void initialize(String[] args) {
        boolean haveIndexDir = false;
        boolean remoteSearch = false;
        String indexDir = null;
        int num = args.length;
        seqId = null;
        pfamId = null;
        userId = null;
        useCATH = false;
        useSSG = false;
        offLine = false;
        addEnzymes = false;
        for (int i = 0; i < num; ++i) {
            if (args[i].equals("-u")) {
                if (i >= num - 1) continue;
                seqId = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-p")) {
                if (i >= num - 1) continue;
                pfamId = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-cath")) {
                useCATH = true;
                continue;
            }
            if (args[i].equals("-offline")) {
                offLine = true;
                continue;
            }
            if (args[i].equals("-ec")) {
                addEnzymes = true;
                continue;
            }
            if (args[i].equals("-ssg")) {
                useSSG = true;
                continue;
            }
            if (args[i].equals("-uid")) {
                if (i >= num - 1) continue;
                userId = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-i")) {
                if (i >= num - 1) continue;
                indexDir = args[i + 1];
                haveIndexDir = true;
                ++i;
                continue;
            }
            if (args[i].equals("-r")) {
                if (i >= num - 1) continue;
                indexDir = args[i + 1];
                remoteSearch = true;
                ++i;
                continue;
            }
            indexDir = args[i];
        }
        remoteSearch = true;
        if (indexDir == null) {
            indexDir = "https://www.ebi.ac.uk/thornton-srv/databases/cgi-bin/archschema/ArchSearch.pl?";
        }
        try {
            this.searcher = new SwissPfamSearcher(indexDir);
        }
        catch (Exception e) {
            System.out.printf("*** Unable to locate ArchSchema database:\n%s\n", e.getMessage());
            e.printStackTrace();
            this.exit();
        }
    }

    protected void startup() {
        if (!offLine) {
            // empty if block
        }
        imgURL = this.getClass().getResource("images/");
        SearchPanelActions.getInstance().setImgURL(imgURL);
        this.setAppFrame(new AppFrame("ArchSchema", useCATH));
        this.getAppFrame().getInputPanel().getSearchButton().setAction(this.getAction("sequenceSubmitAction"));
        this.getAppFrame().getInputPanel().getSearchButton().setText("Search");
        this.getAppFrame().getInputPanel().getPfamSearchButton().setAction(this.getAction("pfamSubmitAction"));
        this.getAppFrame().getInputPanel().getPfamSearchButton().setText("Search");
        this.getAppFrame().getGraphCriteriaPanel().getDrawGraphButton().setAction(this.getAction("refineSearchAction"));
        this.getAppFrame().getGraphCriteriaPanel().getDrawGraphButton().setText("Refine search");
        this.getAppFrame().getGraphCriteriaPanel().getDrawGraphButton().setEnabled(false);
        this.getAppFrame().getGraphCriteriaPanel().getResetButton().setAction(this.getAction("resetAction"));
        this.getAppFrame().getGraphStylePanel().getGraphRenderButton().setAction(this.getAction("toggleGraphRenderingAction"));
        this.getAppFrame().getGraphStylePanel().getGraphRenderButton().setText("Freeze Graph");
        this.getAppFrame().getPrintMenuItem().setAction(this.getAction("printGraphAction"));
        this.getAppFrame().getPrintMenuItem().setText("Print graph");
        this.getAppFrame().getPrintMenuItem().setEnabled(false);
        this.getAppFrame().getPSMenuItem().setAction(this.getAction("postScriptAction"));
        this.getAppFrame().getPSMenuItem().setText("PostScript file");
        this.getAppFrame().getPSMenuItem().setEnabled(false);
        this.getAppFrame().getDocumentationMenuItem().setAction(this.getAction("documentationAction"));
        this.getAppFrame().getDocumentationMenuItem().setText("Documentation");
        if (!offLine) {
            this.getAppFrame().getGraphStylePanel().getEdgeLengthSlider().addChangeListener(GraphStylePanelActions.getInstance().getSpringLengthChangeListener(this.getAppFrame()));
            this.getAppFrame().getGraphStylePanel().getConnectivityFilterSlider().addChangeListener(GraphStylePanelActions.getInstance().getConnectionFilterChangeListener(this.getAppFrame()));
        }
        this.getAppFrame().getGraphStylePanel().getDomainsOnlyRadioButton().addItemListener(GraphStylePanelActions.getInstance().getDomainsOnlyRadioButtonListener(this.getAppFrame()));
        this.getAppFrame().getGraphStylePanel().getAddSequencesRadioButton().addItemListener(GraphStylePanelActions.getInstance().getAddSequencesRadioButtonListener(this.getAppFrame()));
        this.getAppFrame().getGraphStylePanel().getAddStructuresRadioButton().addItemListener(GraphStylePanelActions.getInstance().getAddStructuresRadioButtonListener(this.getAppFrame()));
        this.getAppFrame().getGraphStylePanel().getAddEnzymesRadioButton().addItemListener(GraphStylePanelActions.getInstance().getAddEnzymesRadioButtonListener(this.getAppFrame()));
        this.getAppFrame().getGraphPanel().getVisualization().getDisplay(0).addControlListener(GraphActions.getInstance().getGraphNodeClickControlAdapter(this.getAppFrame(), this.getSearcher(), useCATH));
        this.getAppFrame().getGraphPanel().getVisualization().getDisplay(0).addControlListener(GraphActions.getInstance().getGraphBackgroundClickFocus(this.getAppFrame()));
        this.getAppFrame().getSplitPane2().getTopComponent().setVisible(false);
        this.getAppFrame().getSplitPane2().setOneTouchExpandable(false);
        StringBuilder panelText = null;
        panelText = seqId == null ? this.setDataPanelText(0, true) : this.setDataPanelText(1, true);
        String masterText = "<html><head><style type=\"text/css\">\nbody { font-size: 12pt; font-family: sans-serif }\n</style><head><body font=\"sans-serif\">" + panelText + "</body></html>";
        this.getAppFrame().getDataPane().setText(masterText);
        this.getAppFrame().getDataPane().addHyperlinkListener(DataPaneActions.getInstance().getDataPaneHyperlinkListener());
        if (useCATH) {
            this.getAppFrame().getInputPanel().setLabel2(1);
            this.getAppFrame().getGraphStylePanel().setDomainsOnlyRadioButton(1);
        }
        this.getAppFrame().setSize(1000, 700);
        this.getAppFrame().setVisible(true);
        if (pfamId != null) {
            this.appFrame.getInputPanel().getPfamIdTextField().setText(pfamId);
            this.pfamSubmitAction();
        } else if (seqId != null) {
            this.appFrame.getInputPanel().getSequenceTextField().setText(seqId);
            this.sequenceSubmitAction();
        }
    }

    @org.jdesktop.application.Action
    public void refineSearchAction() {
        boolean newSearch = false;
        userId = null;
        seqId = this.appFrame.getInputPanel().getSequenceTextField().getText().toUpperCase();
        if (seqId != null && !seqId.equals("")) {
            pfamId = null;
            this.runSearch(newSearch);
        } else {
            pfamId = this.appFrame.getInputPanel().getPfamIdTextField().getText().toUpperCase();
            if (pfamId != null && !pfamId.equals("")) {
                seqId = null;
                this.runSearch(newSearch);
            }
        }
    }

    @org.jdesktop.application.Action
    public void pfamSubmitAction() {
        boolean newSearch = true;
        pfamId = this.appFrame.getInputPanel().getPfamIdTextField().getText().toUpperCase();
        seqId = null;
        this.appFrame.getInputPanel().getSequenceTextField().setText("");
        this.runSearch(newSearch);
    }

    @org.jdesktop.application.Action
    public void sequenceSubmitAction() {
        boolean newSearch = true;
        seqId = this.appFrame.getInputPanel().getSequenceTextField().getText().toUpperCase();
        pfamId = null;
        this.appFrame.getInputPanel().getPfamIdTextField().setText("");
        this.runSearch(newSearch);
    }

    @org.jdesktop.application.Action
    public void drawGraphAction() {
        try {
            SearchPanelActions.getInstance().drawGraphAction(this.getAppFrame(), this.getSearcher());
            this.getAppFrame().getPrintMenuItem().setEnabled(true);
            this.getAppFrame().getPSMenuItem().setEnabled(true);
        }
        catch (Exception e) {
            System.out.printf("Error executing Main.drawGraphAction().\n", new Object[0]);
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Main.this.getAppFrame().getDataScrollPane().getVerticalScrollBar().setValue(0);
                Main.this.getAppFrame().selectTab("Graph");
            }
        });
    }

    @org.jdesktop.application.Action
    public void resetAction() {
        SearchPanelActions.getInstance().resetAction(this.getAppFrame());
    }

    @org.jdesktop.application.Action
    public void toggleGraphRenderingAction() {
        GraphStylePanelActions.getInstance().toggleGraphAction(this.getAppFrame());
    }

    @org.jdesktop.application.Action
    public void printGraphAction() {
        GraphStylePanelActions.getInstance().printGraphAction(this.getAppFrame());
    }

    @org.jdesktop.application.Action
    public void postScriptAction() {
        GraphStylePanelActions.getInstance().writePostScriptAction(this.getAppFrame(), useCATH);
    }

    @org.jdesktop.application.Action
    public void documentationAction() {
        String URL2 = "https://www.ebi.ac.uk/thornton-srv/databases/archschema/documentation.html";
        try {
            BrowserLauncher bl = new BrowserLauncher();
            bl.openURLinBrowser(URL2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AppFrame getAppFrame() {
        return this.appFrame;
    }

    private void runSearch(boolean newSearch) {
        boolean haveGraphData = false;
        nDomains = 0;
        nSeqs = 0;
        StringBuilder panelText = this.setDataPanelText(1, true);
        String masterText = "<html><head><style type=\"text/css\">\nbody { font-size: 12pt; font-family: sans-serif }\n</style><head><body font=\"sans-serif\">" + panelText + "</body></html>";
        this.getAppFrame().getDataPane().setText(masterText);
        this.getAppFrame().getDataPane().repaint();
        try {
            haveGraphData = SearchPanelActions.getInstance().sequenceSearchAction(this.getAppFrame(), this.getSearcher(), seqId, pfamId, newSearch, userId, useCATH, useSSG, offLine, addEnzymes);
            nSeqs = SearchPanelActions.getInstance().getNSequences();
            nDomains = SearchPanelActions.getInstance().getNDomains();
            domainType = SearchPanelActions.getInstance().getDomainType();
        }
        catch (Exception ex) {
            nDomains = 0;
        }
        panelText = this.setDataPanelText(0, true);
        masterText = "<html><head><style type=\"text/css\">\nbody { font-size: 12pt; font-family: sans-serif }\n</style><head><body font=\"sans-serif\">" + panelText + "</body></html>";
        this.getAppFrame().getDataPane().setText(masterText);
        this.getAppFrame().getDataPane().repaint();
        if (this.getAppFrame().getSplitPane2().getTopComponent().isVisible()) {
            this.getAppFrame().getSplitPane2().getTopComponent().setVisible(false);
            this.getAppFrame().getSplitPane2().setOneTouchExpandable(false);
        }
        this.getAppFrame().getGraphStylePanel().setDomainsOnlyRadioButton(domainType);
        this.getAppFrame().getInputPanel().setLabel2(domainType);
        if (haveGraphData) {
            this.drawGraphAction();
        }
        newSearch = false;
        userId = null;
    }

    private void setAppFrame(AppFrame appFrame) {
        this.appFrame = appFrame;
    }

    private SwissPfamSearcher getSearcher() {
        return this.searcher;
    }

    private Action getAction(String actionName) {
        return this.getContext().getActionMap().get(actionName);
    }

    private StringBuilder setDataPanelText(int displayMode, boolean showLogo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<blockquote>");
        if (showLogo) {
            sb = this.showLogo(sb);
        }
        if (displayMode == 0) {
            sb = this.showDescription(sb);
        } else if (displayMode == 1) {
            sb = this.showWaitMessage(sb);
        } else if (displayMode == 2) {
            sb = this.showManySequencesMessage(sb);
        } else if (displayMode == 3) {
            sb = this.showDomainSelectMessage(sb);
        }
        sb.append("</blockquote>");
        return sb;
    }

    private StringBuilder showLogo(StringBuilder sb) {
        String imgSrc = "<img src=\"" + imgURL;
        String imgEnd = "\">";
        String logoImage = imgSrc + "ArchSchema_logo_start.gif" + imgEnd;
        sb = SearchPanelActions.getInstance().addSpacer(sb, 1, 20);
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td colspan=2>" + logoImage + "</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td colspan=2><img width=1 height=10 src=\"" + imgURL + "1x1.gif\"></td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td><b>Version 1.1</b></td>");
        sb.append("<td align=right><b>Written by:</b> Asif Tamuri</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;</td>");
        sb.append("<td align=right><b>Modified by:</b> Roman Laskowski</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td colspan=2><img width=1 height=15 src=\"" + imgURL + "1x1.gif\"></td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    private StringBuilder showDescription(StringBuilder sb) {
        String imgSrc = "<img src=\"" + imgURL;
        String imgEnd = "\">";
        String nodeImage1 = imgSrc + "eg_node1.gif" + imgEnd;
        String nodeImage2 = imgSrc + "eg_node2.gif" + imgEnd;
        String nodeImage3 = imgSrc + "eg_node3.gif" + imgEnd;
        String nodeSeqsImage = imgSrc + "eg_node_seqs.gif" + imgEnd;
        String nodeStrucsImage = imgSrc + "eg_node_strucs.gif" + imgEnd;
        String nodeManySeqsImage = imgSrc + "eg_node_manyseqs.gif" + imgEnd;
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td><b>Description</b></td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>");
        sb.append("ArchSchema plots the relationships between Pfam domain architectures. An architecture is defined as the sequence of Pfam domains common to a family of protein sequences. On the plot each architecture is represented by a node with the domains colour-coded, as shown in the examples below.");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td align=center>");
        sb.append("  <table cellpadding=0 cellspacing=0>");
        sb.append("  <tr>");
        sb.append("  <td align=center valign=top>" + nodeImage1 + "</td>");
        sb.append("  <td><img width=25 height=1 src=\"" + imgURL + "1x1.gif\"></td>");
        sb.append("  <td align=center valign=top>" + nodeImage2 + "</td>");
        sb.append("  <td><img width=25 height=1 src=\"" + imgURL + "1x1.gif\"></td>");
        sb.append("  <td align=center valign=top>" + nodeImage3 + "</td>");
        sb.append("  </tr>");
        sb.append("  <tr>");
        sb.append("  <td align=center><i>a.</i></td>");
        sb.append("  <td>&nbsp;</td>");
        sb.append("  <td align=center><i>b.</i></td>");
        sb.append("  <td>&nbsp;</td>");
        sb.append("  <td align=center><i>c.</i></td>");
        sb.append("  </td>");
        sb.append("  </tr>");
        sb.append("  </table>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>");
        sb.append("The red underlines in (c) indicate the extent to which 3D structures of the domains and architectures are available in the PDB. Left-clicking on a node shows a panel containing information about the constituent domains, the protein sequences having the given architecture, and any sequences that have whole or partial structures in the PDB.");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>&nbsp;</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>");
        sb.append("You can display UniProt identifiers (or, alternatively, PDB codes) associated with each architecture, as in the examples below. Where there are too many sequence or structure nodes to show, a selection are shown and are coloured pink (as in the third example). You can also display associated enzyme classes (not shown here).");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td align=center>");
        sb.append("  <table cellpadding=0 cellspacing=0>");
        sb.append("  <tr>");
        sb.append("  <td align=center valign=top>" + nodeSeqsImage + "</td>");
        sb.append("  <td><img width=25 height=1 src=\"" + imgURL + "1x1.gif\"></td>");
        sb.append("  <td align=center valign=top>" + nodeStrucsImage + "</td>");
        sb.append("  <td><img width=25 height=1 src=\"" + imgURL + "1x1.gif\"></td>");
        sb.append("  <td align=center valign=top>" + nodeManySeqsImage + "</td>");
        sb.append("  </tr>");
        sb.append("  <tr>");
        sb.append("  <td align=center><i>UniProt sequences</i></td>");
        sb.append("  <td>&nbsp;</td>");
        sb.append("  <td align=center><i>PDB structures</i></td>");
        sb.append("  <td>&nbsp;</td>");
        sb.append("  <td align=center><i>Many satellite nodes</i></td>");
        sb.append("  </td>");
        sb.append("  </tr>");
        sb.append("  </table>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td><b>Getting started</b></td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td>");
        sb.append("To start, use the text boxes at the top of the left-hand panel to enter either the UniProt id of your protein sequence, or the Pfam id of your protein domain of interest. Then press the corresponding Search button.");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</blockquote>");
        return sb;
    }

    private StringBuilder showWaitMessage(StringBuilder sb) {
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td><font color=blue>");
        sb.append("Searching for your sequence ...");
        sb.append("</font></td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    private StringBuilder showDomainSelectMessage(StringBuilder sb) {
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td><font color=blue><b>Select domains</b></font></td?");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td><font color=blue>");
        sb.append("Your search sequence contains <b>" + nDomains + "</b> different Pfam domains (listed in box in " + "left-hand panel). Select the domains you are interested " + "in (currently all are selected), by left-click and " + "shift-left-click. " + "You can then select which organisms to limit the selection " + "to and whether to include only sequences for which there " + "is structural information in the PDB. Finally, " + "press the Plot Graph button to obtain the ArchSchema " + "plot for the architectures containing the selected domains." + "<p><p>" + "Note that, for reference, your \"parent\" search sequence " + "will be retained whether or not it passes the selection " + "criteria.");
        sb.append("</font></td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    private StringBuilder showManySequencesMessage(StringBuilder sb) {
        sb.append("<table cellpadding=0 cellspacing=0>");
        sb.append("<tr>");
        sb.append("<td><font color=red><b>Very many sequences matched!</b></font></td?");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td><font color=red>");
        sb.append("The domains in your search sequence are found (individually or together) in <b>" + nSeqs + "</b> different UniProt sequences. The plotting of the graph " + "may thus be very slow. You can reduce the number of sequences " + "by using the filtering parameters in the panel on the left. " + "These allow you to: ");
        if (nDomains > 1) {
            sb.append("select specific domains, ");
        }
        sb.append("select a particular organism, and/or include only sequences for which there is structural information in the PDB. After making your selections, press the Plot Graph button to obtain the ArchSchema plot.</font><p><p><font color=blue>Note that, for reference, your \"parent\" search sequence will be retained whether or not it passes the selection criteria.");
        sb.append("</font></td>");
        sb.append("</tr>");
        sb.append("</table>");
        return sb;
    }

    static {
        pfamId = null;
        seqId = null;
        userId = null;
    }
}

